/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.wildfly.swarm.undertow.WARArchive;
import org.wildfly.swarm.undertow.internal.DefaultWarDeploymentFactory;
import org.wildfly.swarm.undertow.internal.UndertowExternalMountsAsset;

public interface StaticContentContainer<T extends Archive<T>>
extends Archive<T> {
    public static final Logger log = Logger.getLogger(StaticContentContainer.class.getName());
    public static final String EXTERNAL_MOUNT_PATH = "WEB-INF/undertow-external-mounts.conf";

    default public T staticContent() {
        return this.staticContent("");
    }

    default public T staticContent(String base) {
        UndertowExternalMountsAsset asset;
        ((WARArchive)this.as(WARArchive.class)).addModule("org.wildfly.swarm.undertow", "runtime");
        try {
            WARArchive allResources = DefaultWarDeploymentFactory.archiveFromCurrentApp();
            this.mergeIgnoringDuplicates(allResources, base, (Filter<ArchivePath>)Filters.exclude((String)".*\\.class$"));
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Error setting up static resources", ex);
        }
        Node node = this.get(EXTERNAL_MOUNT_PATH);
        if (node == null) {
            asset = new UndertowExternalMountsAsset();
            this.add(asset, EXTERNAL_MOUNT_PATH);
        } else {
            Asset tempAsset = node.getAsset();
            if (!(tempAsset instanceof UndertowExternalMountsAsset)) {
                asset = new UndertowExternalMountsAsset(tempAsset.openStream());
                this.add(asset, EXTERNAL_MOUNT_PATH);
            } else {
                asset = (UndertowExternalMountsAsset)node.getAsset();
            }
        }
        Path webResources = Paths.get(System.getProperty("user.dir"), "src", "main", "webapp");
        if (base != null) {
            webResources = webResources.resolve(base);
        }
        if (Files.exists(webResources, new LinkOption[0])) {
            asset.externalMount(webResources.toString());
        }
        webResources = Paths.get(System.getProperty("user.dir"), "src", "main", "resources");
        if (base != null) {
            webResources = webResources.resolve(base);
        }
        if (Files.exists(webResources, new LinkOption[0])) {
            asset.externalMount(webResources.toString());
        }
        return (T)this;
    }

    default public T mergeIgnoringDuplicates(Archive<?> source, String base, Filter<ArchivePath> filter) {
        if (!base.startsWith("/")) {
            base = "/" + base;
        }
        Map sourceContent = source.getContent();
        for (Map.Entry contentEntry : sourceContent.entrySet()) {
            Node node = (Node)contentEntry.getValue();
            ArchivePath nodePath = (ArchivePath)contentEntry.getKey();
            if (!nodePath.get().startsWith(base) || !filter.include((Object)nodePath) || this.contains(nodePath)) continue;
            nodePath = new BasicPath(nodePath.get().replaceFirst(base, ""));
            if (node.getAsset() == null) {
                this.addAsDirectory(nodePath);
                continue;
            }
            this.add(node.getAsset(), nodePath);
        }
        return (T)this;
    }
}

