/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow;

import java.util.List;
import org.wildfly.swarm.config.ManagementCoreService;
import org.wildfly.swarm.config.Undertow;
import org.wildfly.swarm.config.undertow.BufferCache;
import org.wildfly.swarm.config.undertow.HandlerConfiguration;
import org.wildfly.swarm.config.undertow.Server;
import org.wildfly.swarm.config.undertow.ServletContainer;
import org.wildfly.swarm.config.undertow.server.Host;
import org.wildfly.swarm.config.undertow.servlet_container.JSPSetting;
import org.wildfly.swarm.config.undertow.servlet_container.WebsocketsSetting;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.SocketBinding;
import org.wildfly.swarm.spi.api.SwarmProperties;
import org.wildfly.swarm.spi.api.annotations.Configuration;
import org.wildfly.swarm.spi.api.annotations.Default;

@Configuration(marshal=true, extension="org.wildfly.extension.undertow")
public class UndertowFraction
extends Undertow<UndertowFraction>
implements Fraction {
    private String keystorePath;
    private String keystorePassword;
    private String alias;
    private boolean enableAJP;

    @Default
    public static UndertowFraction createDefaultFraction() {
        UndertowFraction fraction = new UndertowFraction();
        boolean enabled = System.getProperty("swarm.http.eager") != null;
        ((UndertowFraction)((UndertowFraction)((UndertowFraction)fraction.server(new Server("default-server").httpListener("default", listener -> listener.socketBinding("http").enabled(Boolean.valueOf(enabled))).host(new Host("default-host")))).bufferCache(new BufferCache("default"))).servletContainer(new ServletContainer("default").websocketsSetting(new WebsocketsSetting()).jspSetting(new JSPSetting()))).handlerConfiguration(new HandlerConfiguration());
        return fraction;
    }

    public static UndertowFraction createDefaultFraction(String path, String password, String alias) {
        return UndertowFraction.createDefaultFraction().enableHTTPS(path, password, alias);
    }

    public static UndertowFraction createDefaultAndEnableAJPFraction() {
        return UndertowFraction.createDefaultFraction().enableAJP();
    }

    public static UndertowFraction createDefaultHTTPSOnlyFraction(String path, String password, String alias) {
        UndertowFraction fraction = UndertowFraction.createDefaultFraction();
        fraction.removeHttpListenersFromDefaultServer().enableHTTPS(path, password, alias);
        return fraction;
    }

    public static UndertowFraction createDefaultAJPOnlyFraction() {
        UndertowFraction fraction = UndertowFraction.createDefaultFraction();
        fraction.removeHttpListenersFromDefaultServer().enableAJP();
        return fraction;
    }

    public UndertowFraction enableHTTPS(String path, String password, String alias) {
        this.keystorePath = path;
        this.keystorePassword = password;
        this.alias = alias;
        return this;
    }

    public UndertowFraction enableAJP() {
        this.enableAJP = true;
        return this;
    }

    public void initialize(Fraction.InitContext initContext) {
        initContext.socketBinding(new SocketBinding("http").port(SwarmProperties.propertyVar((String)"swarm.http.port", (String)"8080")));
        initContext.socketBinding(new SocketBinding("https").port(SwarmProperties.propertyVar((String)"swarm.https.port", (String)"8443")));
    }

    public void postInitialize(Fraction.PostInitContext initContext) {
        if (this.keystorePassword != null & this.keystorePassword != null && this.alias != null) {
            ManagementCoreService management = (ManagementCoreService)initContext.fraction("management");
            if (management == null) {
                throw new RuntimeException("HTTPS configured but org.wildfly.swarm:management not available");
            }
            List servers = this.subresources().servers();
            for (Server server2 : servers) {
                if (!server2.subresources().httpsListeners().isEmpty()) continue;
                server2.httpsListener("default-https", listener -> {
                    listener.securityRealm("SSLRealm");
                    listener.socketBinding("https");
                });
            }
            management.securityRealm("SSLRealm", realm -> realm.sslServerIdentity(identity -> {
                identity.keystorePath(this.keystorePath);
                identity.keystorePassword(this.keystorePassword);
                identity.alias(this.alias);
            }));
        }
        if (this.enableAJP) {
            initContext.socketBinding(new SocketBinding("ajp").port(SwarmProperties.propertyVar((String)"swarm.ajp.port", (String)"8009")));
            this.subresources().servers().stream().filter(server -> server.subresources().ajpListeners().isEmpty()).forEach(server -> server.ajpListener("ajp", listener -> listener.socketBinding("ajp")));
        }
    }

    private UndertowFraction removeHttpListenersFromDefaultServer() {
        this.subresources().server("default-server").subresources().httpListeners().clear();
        return this;
    }
}

