/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClassConfigurator {
    public static final String MAGIC_NUMBER_FILE = "jg-magic-map.xml";
    public static final String PROTOCOL_ID_FILE = "jg-protocol-ids.xml";
    private static final int MAX_MAGIC_VALUE = 150;
    private static final short MIN_CUSTOM_MAGIC_NUMBER = 1024;
    private static final short MIN_CUSTOM_PROTOCOL_ID = 512;
    private static final Map<Class, Short> classMap = new IdentityHashMap<Class, Short>(150);
    private static final Class[] magicMap = new Class[150];
    private static final Map<Short, Class> magicMapUser = new HashMap<Short, Class>();
    private static final Map<Class, Short> protocol_ids = new HashMap<Class, Short>(150);
    private static final Map<Short, Class> protocol_names = new HashMap<Short, Class>(150);

    protected static void init() throws Exception {
        Class clazz;
        short m;
        Util.loadClass("javax.xml.parsers.DocumentBuilderFactory", ClassConfigurator.class);
        String magic_number_file = null;
        String protocol_id_file = null;
        try {
            magic_number_file = Util.getProperty(new String[]{"jgroups.conf.magic_number_file", "org.jgroups.conf.magicNumberFile"}, null, null, MAGIC_NUMBER_FILE);
            protocol_id_file = Util.getProperty(new String[]{"jgroups.conf.protocol_id_file", "org.jgroups.conf.protocolIDFile"}, null, null, PROTOCOL_ID_FILE);
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        List<Tuple<Short, String>> mapping = ClassConfigurator.readMappings(magic_number_file);
        for (Tuple<Short, String> tuple : mapping) {
            m = tuple.getVal1();
            if (m >= 150) {
                throw new IllegalArgumentException("ID " + m + " is bigger than MAX_MAGIC_VALUE (" + 150 + "); increase MAX_MAGIC_VALUE");
            }
            clazz = Util.loadClass(tuple.getVal2(), ClassConfigurator.class);
            if (magicMap[m] != null) {
                throw new Exception("key " + m + " (" + clazz.getName() + ')' + " is already in magic map; please make sure that all keys are unique");
            }
            ClassConfigurator.magicMap[m] = clazz;
            classMap.put(clazz, m);
        }
        mapping = ClassConfigurator.readMappings(protocol_id_file);
        for (Tuple<Short, String> tuple : mapping) {
            m = tuple.getVal1();
            clazz = Util.loadClass(tuple.getVal2(), ClassConfigurator.class);
            if (protocol_ids.containsKey(clazz)) {
                throw new Exception("ID " + m + " (" + clazz.getName() + ')' + " is already in protocol-id map; make sure that all protocol IDs are unique");
            }
            protocol_ids.put(clazz, m);
            protocol_names.put(m, clazz);
        }
    }

    public static void add(short magic, Class clazz) throws IllegalArgumentException {
        if (magic < 1024) {
            throw new IllegalArgumentException("magic number (" + magic + ") needs to be greater than " + 1024);
        }
        if (magicMapUser.containsKey(magic)) {
            throw new IllegalArgumentException("magic number " + magic + " for class " + clazz.getName() + " is already present");
        }
        if (classMap.containsKey(clazz)) {
            throw new IllegalArgumentException("class " + clazz.getName() + " is already present");
        }
        magicMapUser.put(magic, clazz);
        classMap.put(clazz, magic);
    }

    public static void addProtocol(short id, Class protocol) {
        if (id <= 512) {
            throw new IllegalArgumentException("protocol ID (" + id + ") needs to be greater than " + 512);
        }
        if (protocol_ids.containsKey(protocol)) {
            throw new IllegalArgumentException("Protocol " + protocol + " is already present");
        }
        protocol_ids.put(protocol, id);
    }

    public static Class<?> get(short magic) {
        return magic < 1024 ? magicMap[magic] : magicMapUser.get(magic);
    }

    public static Class get(String clazzname, ClassLoader loader) throws ClassNotFoundException {
        return Util.loadClass(clazzname, loader != null ? loader : ClassConfigurator.class.getClassLoader());
    }

    public static Class get(String clazzname) throws ClassNotFoundException {
        return Util.loadClass(clazzname, ClassConfigurator.class);
    }

    public static short getMagicNumber(Class clazz) {
        Short i = classMap.get(clazz);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public static short getProtocolId(Class protocol) {
        Short retval = protocol_ids.get(protocol);
        if (retval != null) {
            return retval;
        }
        return 0;
    }

    public static Class getProtocol(short id) {
        return protocol_names.get(id);
    }

    public String toString() {
        return ClassConfigurator.printMagicMap();
    }

    public static String printMagicMap() {
        StringBuilder sb = new StringBuilder();
        TreeSet<Short> keys = new TreeSet<Short>(magicMapUser.keySet());
        for (short i = 0; i < magicMap.length; i = (short)(i + 1)) {
            if (magicMap[i] == null) continue;
            keys.add(i);
        }
        for (Short key : keys) {
            sb.append(key).append(":\t").append(key < 1024 ? magicMap[key] : magicMapUser.get(key)).append('\n');
        }
        return sb.toString();
    }

    public static String printClassMap() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Class, Short> entry : classMap.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    protected static List<Tuple<Short, String>> readMappings(String name) throws Exception {
        InputStream stream = Util.getResourceAsStream(name, ClassConfigurator.class);
        if (stream == null) {
            stream = new FileInputStream(name);
        }
        return ClassConfigurator.parse(stream);
    }

    protected static List<Tuple<Short, String>> parse(InputStream stream) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(stream);
        NodeList class_list = document.getElementsByTagName("class");
        LinkedList<Tuple<Short, String>> list = new LinkedList<Tuple<Short, String>>();
        for (int i = 0; i < class_list.getLength(); ++i) {
            if (class_list.item(i).getNodeType() != 1) continue;
            list.add(ClassConfigurator.parseClassData(class_list.item(i)));
        }
        return list;
    }

    protected static Tuple<Short, String> parseClassData(Node protocol) {
        protocol.normalize();
        NamedNodeMap attrs = protocol.getAttributes();
        String magicnumber = attrs.getNamedItem("id").getNodeValue();
        String clazzname = attrs.getNamedItem("name").getNodeValue();
        return new Tuple<Short, String>(Short.valueOf(magicnumber), clazzname);
    }

    static {
        try {
            ClassConfigurator.init();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

