/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core;

import java.io.Serializable;
import java.util.List;
import org.hornetq.api.core.BroadcastEndpointFactoryConfiguration;

public final class BroadcastGroupConfiguration
implements Serializable {
    private static final long serialVersionUID = 2335634694112319124L;
    private String name;
    private long broadcastPeriod;
    private final BroadcastEndpointFactoryConfiguration endpointFactoryConfiguration;
    private List<String> connectorInfos;

    public BroadcastGroupConfiguration(String name, long broadcastPeriod, List<String> connectorInfos, BroadcastEndpointFactoryConfiguration endpointFactoryConfiguration) {
        this.name = name;
        this.broadcastPeriod = broadcastPeriod;
        this.connectorInfos = connectorInfos;
        this.endpointFactoryConfiguration = endpointFactoryConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public long getBroadcastPeriod() {
        return this.broadcastPeriod;
    }

    public List<String> getConnectorInfos() {
        return this.connectorInfos;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBroadcastPeriod(long broadcastPeriod) {
        this.broadcastPeriod = broadcastPeriod;
    }

    public void setConnectorInfos(List<String> connectorInfos) {
        this.connectorInfos = connectorInfos;
    }

    public BroadcastEndpointFactoryConfiguration getEndpointFactoryConfiguration() {
        return this.endpointFactoryConfiguration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.broadcastPeriod ^ this.broadcastPeriod >>> 32);
        result = 31 * result + (this.connectorInfos == null ? 0 : this.connectorInfos.hashCode());
        result = 31 * result + (this.endpointFactoryConfiguration == null ? 0 : this.endpointFactoryConfiguration.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BroadcastGroupConfiguration other = (BroadcastGroupConfiguration)obj;
        if (this.broadcastPeriod != other.broadcastPeriod) {
            return false;
        }
        if (this.connectorInfos == null ? other.connectorInfos != null : !this.connectorInfos.equals(other.connectorInfos)) {
            return false;
        }
        if (this.endpointFactoryConfiguration == null ? other.endpointFactoryConfiguration != null : !this.endpointFactoryConfiguration.equals(other.endpointFactoryConfiguration)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

