/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.jboss.ejb.client.TransactionID;

public final class XidTransactionID
extends TransactionID {
    private static final long serialVersionUID = -1895745528459825578L;
    private final Xid xid = new XidImpl();

    XidTransactionID(byte[] encodedBytes) {
        super(encodedBytes);
        byte gtidLen = encodedBytes[5];
        int length = encodedBytes.length;
        if (gtidLen > Math.min(127, 64) || gtidLen > length - 7) {
            throw new IllegalArgumentException("Invalid global transaction ID length");
        }
        byte bqalLen = encodedBytes[6 + gtidLen];
        if (bqalLen > Math.min(127, 64) || bqalLen != length - gtidLen - 7) {
            throw new IllegalArgumentException("Invalid branch qualifier length");
        }
    }

    public XidTransactionID(Xid original) {
        this(XidTransactionID.encode(original));
    }

    private static byte[] encode(Xid original) {
        byte[] gtid = original.getGlobalTransactionId();
        byte[] bqal = original.getBranchQualifier();
        int formatId = original.getFormatId();
        byte[] target = new byte[gtid.length + bqal.length + 7];
        target[0] = 2;
        target[1] = (byte)(formatId >>> 24);
        target[2] = (byte)(formatId >>> 16);
        target[3] = (byte)(formatId >>> 8);
        target[4] = (byte)formatId;
        target[5] = (byte)gtid.length;
        System.arraycopy(gtid, 0, target, 6, gtid.length);
        target[6 + gtid.length] = (byte)bqal.length;
        System.arraycopy(bqal, 0, target, 7 + gtid.length, bqal.length);
        return target;
    }

    static int getGtidLen(byte[] raw) {
        return raw[5];
    }

    static int getBqalLen(byte[] raw) {
        return raw[XidTransactionID.getGtidLen(raw) + 6];
    }

    public Xid getXid() {
        return this.xid;
    }

    public boolean isSameXid(Xid xid) {
        return this.xid.equals(xid);
    }

    final class XidImpl
    implements Xid {
        XidImpl() {
        }

        @Override
        public int getFormatId() {
            byte[] raw = XidTransactionID.this.getEncodedFormRaw();
            return (raw[1] & 0xFF) << 24 | (raw[2] & 0xFF) << 16 | (raw[3] & 0xFF) << 8 | raw[4] & 0xFF;
        }

        @Override
        public byte[] getGlobalTransactionId() {
            byte[] raw = XidTransactionID.this.getEncodedFormRaw();
            return Arrays.copyOfRange(raw, 6, XidTransactionID.getGtidLen(raw) + 6);
        }

        @Override
        public byte[] getBranchQualifier() {
            byte[] raw = XidTransactionID.this.getEncodedFormRaw();
            assert (raw.length == 7 + XidTransactionID.getGtidLen(raw) + XidTransactionID.getBqalLen(raw));
            return Arrays.copyOfRange(raw, 7 + XidTransactionID.getGtidLen(raw), raw.length);
        }

        public boolean equals(Object other) {
            return other instanceof XidImpl && this.equals((XidImpl)other) || other instanceof Xid && this.equals((Xid)other);
        }

        private boolean equals(XidImpl other) {
            return this == other || other != null && XidTransactionID.this.equals(other.getXidTransactionID());
        }

        private boolean equals(Xid other) {
            return other != null && Arrays.equals(XidTransactionID.encode(other), XidTransactionID.this.getEncodedFormRaw());
        }

        public int hashCode() {
            return XidTransactionID.this.hashCode();
        }

        XidTransactionID getXidTransactionID() {
            return XidTransactionID.this;
        }
    }
}

