/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import org.jboss.ejb.client.ClusterContext;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.remoting.MaxAttemptsReconnectHandler;
import org.jboss.ejb.client.remoting.RemotingCleanupHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;

class ClusterContextConnectionReconnectHandler
extends MaxAttemptsReconnectHandler {
    private final ClusterContext clusterContext;
    private final RemotingCleanupHandler remotingCleanupHandler = new RemotingCleanupHandler();

    ClusterContextConnectionReconnectHandler(ClusterContext clusterContext, Endpoint endpoint, String protocol, String host, int port, EJBClientConfiguration.CommonConnectionCreationConfiguration connectionConfiguration, int maxReconnectAttempts) {
        super(endpoint, protocol, host, port, connectionConfiguration, maxReconnectAttempts);
        this.clusterContext = clusterContext;
        this.clusterContext.getEJBClientContext().registerEJBClientContextListener(this.remotingCleanupHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect() throws IOException {
        Connection connection = null;
        try {
            connection = this.tryConnect();
            if (connection == null) {
                return;
            }
            this.remotingCleanupHandler.addConnection(connection);
            RemotingConnectionEJBReceiver ejbReceiver = new RemotingConnectionEJBReceiver(connection, this, this.connectionConfiguration.getChannelCreationOptions(), this.protocol);
            this.clusterContext.registerEJBReceiver(ejbReceiver);
        }
        finally {
            if (connection != null || !this.hasMoreAttempts()) {
                this.clusterContext.getEJBClientContext().unregisterReconnectHandler(this);
            }
        }
    }
}

