/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.ejb.client.remoting.EndpointPool;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

class RemotingEndpointManager {
    private static final Logger logger = Logger.getLogger(RemotingEndpointManager.class);
    private final EndpointPool endpointPool = EndpointPool.INSTANCE;
    private final List<Endpoint> managedEndpoints = Collections.synchronizedList(new ArrayList());

    RemotingEndpointManager() {
    }

    Endpoint getEndpoint(String endpointName, OptionMap endpointCreationOptions, OptionMap remotingConnectionProviderOptions) throws IOException {
        Endpoint endpoint = this.endpointPool.getEndpoint(endpointName, endpointCreationOptions, remotingConnectionProviderOptions);
        this.managedEndpoints.add(endpoint);
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void safeClose() {
        List<Endpoint> list = this.managedEndpoints;
        synchronized (list) {
            for (Endpoint endpoint : this.managedEndpoints) {
                try {
                    endpoint.close();
                }
                catch (Throwable t) {
                    logger.debugf(t, "Failed to close %s", (Object)endpoint);
                }
            }
        }
    }
}

