/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.buffers.impl;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;

public final class ResetLimitWrappedActiveMQBuffer
extends ChannelBufferWrapper {
    private final int limit;
    private MessageInternal message;

    public void setMessage(MessageInternal message) {
        this.message = message;
    }

    public ResetLimitWrappedActiveMQBuffer(int limit, ActiveMQBuffer buffer, MessageInternal message) {
        this(limit, ResetLimitWrappedActiveMQBuffer.unwrap(buffer.byteBuf()).duplicate(), message);
    }

    public ResetLimitWrappedActiveMQBuffer(int limit, ByteBuf buffer, MessageInternal message) {
        super(buffer);
        this.limit = limit;
        if (this.writerIndex() < limit) {
            this.writerIndex(limit);
        }
        this.readerIndex(limit);
        this.message = message;
    }

    private void changed() {
        if (this.message != null) {
            this.message.bodyChanged();
        }
    }

    public void setBuffer(ActiveMQBuffer buffer) {
        if (this.buffer != null) {
            this.buffer.release();
        }
        this.buffer = buffer.byteBuf();
    }

    @Override
    public void clear() {
        this.changed();
        this.buffer.clear();
        this.buffer.setIndex(this.limit, this.limit);
    }

    @Override
    public void readerIndex(int readerIndex) {
        this.changed();
        if (readerIndex < this.limit) {
            readerIndex = this.limit;
        }
        this.buffer.readerIndex(readerIndex);
    }

    @Override
    public void resetReaderIndex() {
        this.changed();
        this.buffer.readerIndex(this.limit);
    }

    @Override
    public void resetWriterIndex() {
        this.changed();
        this.buffer.writerIndex(this.limit);
    }

    @Override
    public void setIndex(int readerIndex, int writerIndex) {
        this.changed();
        if (readerIndex < this.limit) {
            readerIndex = this.limit;
        }
        if (writerIndex < this.limit) {
            writerIndex = this.limit;
        }
        this.buffer.setIndex(readerIndex, writerIndex);
    }

    @Override
    public void writerIndex(int writerIndex) {
        this.changed();
        if (writerIndex < this.limit) {
            writerIndex = this.limit;
        }
        this.buffer.writerIndex(writerIndex);
    }

    @Override
    public void setByte(int index, byte value) {
        this.changed();
        super.setByte(index, value);
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.changed();
        super.setBytes(index, src, srcIndex, length);
    }

    @Override
    public void setBytes(int index, byte[] src) {
        this.changed();
        super.setBytes(index, src);
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        this.changed();
        super.setBytes(index, src);
    }

    @Override
    public void setBytes(int index, ActiveMQBuffer src, int srcIndex, int length) {
        this.changed();
        super.setBytes(index, src, srcIndex, length);
    }

    @Override
    public void setBytes(int index, ActiveMQBuffer src, int length) {
        this.changed();
        super.setBytes(index, src, length);
    }

    @Override
    public void setBytes(int index, ActiveMQBuffer src) {
        this.changed();
        super.setBytes(index, src);
    }

    @Override
    public void setChar(int index, char value) {
        this.changed();
        super.setChar(index, value);
    }

    @Override
    public void setDouble(int index, double value) {
        this.changed();
        super.setDouble(index, value);
    }

    @Override
    public void setFloat(int index, float value) {
        this.changed();
        super.setFloat(index, value);
    }

    @Override
    public void setInt(int index, int value) {
        this.changed();
        super.setInt(index, value);
    }

    @Override
    public void setLong(int index, long value) {
        this.changed();
        super.setLong(index, value);
    }

    @Override
    public void setShort(int index, short value) {
        this.changed();
        super.setShort(index, value);
    }

    @Override
    public void writeBoolean(boolean val) {
        this.changed();
        super.writeBoolean(val);
    }

    @Override
    public void writeByte(byte value) {
        this.changed();
        super.writeByte(value);
    }

    @Override
    public void writeBytes(byte[] src, int srcIndex, int length) {
        this.changed();
        super.writeBytes(src, srcIndex, length);
    }

    @Override
    public void writeBytes(byte[] src) {
        this.changed();
        super.writeBytes(src);
    }

    @Override
    public void writeBytes(ByteBuffer src) {
        this.changed();
        super.writeBytes(src);
    }

    @Override
    public void writeBytes(ActiveMQBuffer src, int srcIndex, int length) {
        this.changed();
        super.writeBytes(src, srcIndex, length);
    }

    @Override
    public void writeBytes(ActiveMQBuffer src, int length) {
        this.changed();
        super.writeBytes(src, length);
    }

    @Override
    public void writeChar(char chr) {
        this.changed();
        super.writeChar(chr);
    }

    @Override
    public void writeDouble(double value) {
        this.changed();
        super.writeDouble(value);
    }

    @Override
    public void writeFloat(float value) {
        this.changed();
        super.writeFloat(value);
    }

    @Override
    public void writeInt(int value) {
        this.changed();
        super.writeInt(value);
    }

    @Override
    public void writeLong(long value) {
        this.changed();
        super.writeLong(value);
    }

    @Override
    public void writeNullableSimpleString(SimpleString val) {
        this.changed();
        super.writeNullableSimpleString(val);
    }

    @Override
    public void writeNullableString(String val) {
        this.changed();
        super.writeNullableString(val);
    }

    @Override
    public void writeShort(short value) {
        this.changed();
        super.writeShort(value);
    }

    @Override
    public void writeSimpleString(SimpleString val) {
        this.changed();
        super.writeSimpleString(val);
    }

    @Override
    public void writeString(String val) {
        this.changed();
        super.writeString(val);
    }

    @Override
    public void writeUTF(String utf) {
        this.changed();
        super.writeUTF(utf);
    }
}

