/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXServiceURL;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remotingjmx.Capability;
import org.jboss.remotingjmx.Constants;
import org.jboss.remotingjmx.DefaultServerInterceptorFactory;
import org.jboss.remotingjmx.MBeanServerLocator;
import org.jboss.remotingjmx.MBeanServerManager;
import org.jboss.remotingjmx.ServerMessageInterceptor;
import org.jboss.remotingjmx.ServerMessageInterceptorFactory;
import org.jboss.remotingjmx.Version;
import org.jboss.remotingjmx.VersionedProxy;
import org.jboss.remotingjmx.WrappedMBeanServerConnection;
import org.jboss.remotingjmx.protocol.CancellableDataOutputStream;
import org.jboss.remotingjmx.protocol.Versions;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class DelegatingRemotingConnectorServer {
    private static final Logger log = Logger.getLogger(DelegatingRemotingConnectorServer.class);
    private volatile boolean started = false;
    private volatile boolean stopped = false;
    private final MBeanServerManager mbeanServerManager;
    private volatile Endpoint endpoint;
    private volatile Registration registration;
    private final Executor executor;
    private final Versions versions;
    private final ServerMessageInterceptorFactory serverMessageInterceptorFactory;

    public DelegatingRemotingConnectorServer(MBeanServerLocator mbeanServerLocator, Endpoint endpoint) {
        this(mbeanServerLocator, endpoint, Executors.newCachedThreadPool(), Collections.EMPTY_MAP);
    }

    public DelegatingRemotingConnectorServer(MBeanServerLocator mbeanServerLocator, Endpoint endpoint, Map<String, ?> environment) {
        this(mbeanServerLocator, endpoint, Executors.newCachedThreadPool(), environment);
    }

    public DelegatingRemotingConnectorServer(MBeanServerLocator mbeanServerLocator, Endpoint endpoint, Map<String, ?> environment, ServerMessageInterceptorFactory serverMessageInterceptorFactory) {
        this(mbeanServerLocator, endpoint, (Executor)Executors.newCachedThreadPool(), environment, serverMessageInterceptorFactory);
    }

    public DelegatingRemotingConnectorServer(MBeanServerLocator mbeanServerLocator, Endpoint endpoint, Executor executor, Map<String, ?> environment) {
        this(mbeanServerLocator, endpoint, executor, environment, null);
    }

    public DelegatingRemotingConnectorServer(MBeanServerLocator mbeanServerLocator, Endpoint endpoint, Executor executor, Map<String, ?> environment, ServerMessageInterceptorFactory serverMessageInterceptorFactory) {
        this.mbeanServerManager = new DelegatingMBeanServerManager(mbeanServerLocator);
        this.endpoint = endpoint;
        this.executor = executor;
        this.versions = new Versions(environment);
        this.serverMessageInterceptorFactory = serverMessageInterceptorFactory != null ? serverMessageInterceptorFactory : DefaultServerInterceptorFactory.FACTORY_INSTANCE;
    }

    DelegatingRemotingConnectorServer(MBeanServerManager mbeanServerManager, Endpoint endpoint, Executor executor, Map<String, ?> environment, ServerMessageInterceptorFactory serverMessageInterceptorFactory) {
        this.mbeanServerManager = mbeanServerManager;
        this.endpoint = endpoint;
        this.executor = executor;
        this.versions = new Versions(environment);
        this.serverMessageInterceptorFactory = serverMessageInterceptorFactory != null ? serverMessageInterceptorFactory : DefaultServerInterceptorFactory.FACTORY_INSTANCE;
    }

    public void start() throws IOException {
        log.trace("start()");
        if (this.stopped) {
            throw new IOException("Unable to start connector as already stopped.");
        }
        if (this.started) {
            return;
        }
        log.trace("Registering service");
        this.registration = this.endpoint.registerService("jmx", new ChannelOpenListener(), OptionMap.EMPTY);
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        if (this.stopped) {
            return;
        }
        try {
            if (this.started) {
                this.registration.close();
            }
        }
        finally {
            this.endpoint = null;
            this.registration = null;
            this.stopped = true;
        }
    }

    public boolean isActive() {
        return this.started && !this.stopped;
    }

    public JMXServiceURL getAddress() {
        return null;
    }

    public Map<String, ?> getAttributes() {
        return Collections.emptyMap();
    }

    private void writeVersionHeader(Channel channel, boolean fullVersionList) throws IOException {
        try (CancellableDataOutputStream dos = new CancellableDataOutputStream(channel.writeMessage());){
            dos.writeBytes("JMX");
            byte[] versions = this.getSupportedVersions(fullVersionList);
            dos.writeInt(versions.length);
            dos.write(versions);
            if (Version.isSnapshot()) {
                dos.write(1);
            } else {
                dos.write(0);
            }
            if (fullVersionList) {
                String remotingJMXVersion = Version.getVersionString();
                byte[] versionBytes = remotingJMXVersion.getBytes("UTF-8");
                dos.writeInt(versionBytes.length);
                dos.write(versionBytes);
            }
        }
    }

    private byte[] getSupportedVersions(boolean fullVersionList) {
        Set<Byte> supportedVersions = this.versions.getSupportedVersions(new Capability[0]);
        if (fullVersionList) {
            Byte[] temp = supportedVersions.toArray(new Byte[supportedVersions.size()]);
            byte[] response = new byte[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                response[i] = temp[i];
            }
            return response;
        }
        for (byte current : supportedVersions) {
            if (current != 1) continue;
            return new byte[]{0, 1};
        }
        return new byte[]{0};
    }

    private class ClientVersionReceiver
    implements Channel.Receiver {
        final ServerMessageInterceptor serverMessageInterceptor;

        public ClientVersionReceiver(ServerMessageInterceptor serverMessageInterceptor) {
            this.serverMessageInterceptor = serverMessageInterceptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
            DataInputStream dis = new DataInputStream(messageInputStream);
            try {
                log.tracef("Bytes Available %d", dis.available());
                byte[] firstThree = new byte[3];
                dis.read(firstThree);
                log.tracef("First Three %s", (Object)new String(firstThree));
                if (!Arrays.equals(firstThree, Constants.JMX_BYTES)) {
                    throw new IOException("Invalid leading bytes in header.");
                }
                log.tracef("Bytes Available %d", dis.available());
                byte version = dis.readByte();
                log.debugf("Chosen version 0x0%d", version);
                if (version == 0) {
                    int length = dis.readInt();
                    byte[] versionBytes = new byte[length];
                    dis.read(versionBytes);
                    String clientVersion = new String(versionBytes, "UTF-8");
                    log.debugf("Client version %s", (Object)clientVersion);
                    DelegatingRemotingConnectorServer.this.writeVersionHeader(channel, true);
                    channel.receiveMessage(this);
                    return;
                }
                DelegatingRemotingConnectorServer.this.versions.startServer(version, channel, DelegatingRemotingConnectorServer.this.mbeanServerManager, DelegatingRemotingConnectorServer.this.executor, this.serverMessageInterceptor);
            }
            catch (IOException e) {
                log.error("Error determining version selected by client.");
            }
            finally {
                IoUtils.safeClose((Closeable)dis);
            }
        }

        @Override
        public void handleError(Channel channel, IOException e) {
            log.warn((Object)"Error on channel before fully established.", e);
        }

        @Override
        public void handleEnd(Channel channel) {
        }
    }

    private class ChannelOpenListener
    implements OpenListener {
        private ChannelOpenListener() {
        }

        @Override
        public void channelOpened(Channel channel) {
            log.trace("Channel Opened");
            try {
                DelegatingRemotingConnectorServer.this.writeVersionHeader(channel, false);
                channel.receiveMessage(new ClientVersionReceiver(DelegatingRemotingConnectorServer.this.serverMessageInterceptorFactory.create(channel)));
            }
            catch (IOException e) {
                log.error((Object)"Unable to send header, closing channel", e);
                IoUtils.safeClose((Closeable)channel);
            }
        }

        @Override
        public void registrationTerminated() {
        }
    }

    private class DelegatingMBeanServerManager
    implements MBeanServerManager {
        private final MBeanServerLocator mbeanServerLocator;

        public DelegatingMBeanServerManager(MBeanServerLocator mbeanServerLocator) {
            this.mbeanServerLocator = mbeanServerLocator;
        }

        @Override
        public WrappedMBeanServerConnection getDefaultMBeanServer() {
            return this.getMBeanServer(null);
        }

        @Override
        public WrappedMBeanServerConnection getMBeanServer(Map<String, String> parameters) {
            MBeanServerConnection mbeanServerConnection;
            MBeanServerConnection mBeanServerConnection = mbeanServerConnection = parameters == null ? this.mbeanServerLocator.getDefaultMBeanServer() : this.mbeanServerLocator.getMBeanServer(parameters);
            if (mbeanServerConnection instanceof WrappedMBeanServerConnection) {
                return (WrappedMBeanServerConnection)((Object)mbeanServerConnection);
            }
            return new WrappedMBeanServerConnection(){

                @Override
                public MBeanServerConnection getMBeanServerConnection() {
                    return mbeanServerConnection;
                }

                @Override
                public void connectionOpened(VersionedProxy proxy) {
                }

                @Override
                public void connectionClosed(VersionedProxy proxy) {
                }
            };
        }
    }
}

