/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.jboss.remoting3.ConnectionImpl;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3._private.IntIndexHashMap;
import org.jboss.remoting3._private.Messages;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.AuthenticationException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.PeerIdentity;
import org.wildfly.security.auth.client.PeerIdentityContext;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.sasl.util.ProtocolSaslClientFactory;
import org.wildfly.security.sasl.util.ServerNameSaslClientFactory;
import org.xnio.Cancellable;
import org.xnio.FinishedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;

public final class ConnectionPeerIdentityContext
extends PeerIdentityContext {
    private static final byte[] NO_BYTES = new byte[0];
    private final ConnectionImpl connection;
    private final Collection<String> offeredMechanisms;
    private final ConnectionPeerIdentity anonymousIdentity;
    private final ConnectionPeerIdentity connectionIdentity;
    private final FinishedIoFuture<ConnectionPeerIdentity> connectionIdentityFuture;
    private final FinishedIoFuture<ConnectionPeerIdentity> anonymousIdentityFuture;
    private final IntIndexHashMap<Authentication> authMap = new IntIndexHashMap<Authentication>(Authentication::getId);
    private final ConcurrentHashMap<AuthenticationConfiguration, IoFuture<ConnectionPeerIdentity>> futureAuths = new ConcurrentHashMap();
    private final UnaryOperator<SaslClientFactory> factoryOperator;
    private static final AuthenticationContextConfigurationClient CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient::new);
    private static final Object PENDING = new Object();
    private static final Object CANCELLED = new Object();
    private static final int WAITING = 0;
    private static final int CHALLENGE = 1;
    private static final int SUCCESS = 2;
    private static final int REJECT = 3;
    private static final int DELETE = 4;
    private static final int CLOSED = 5;

    ConnectionPeerIdentityContext(ConnectionImpl connection, Collection<String> offeredMechanisms, String peerSaslServer, String saslProtocol) {
        this.connection = connection;
        this.offeredMechanisms = offeredMechanisms == null ? Collections.emptySet() : offeredMechanisms;
        this.connectionIdentity = this.constructIdentity(conf -> new ConnectionPeerIdentity((PeerIdentity.Configuration)conf, connection.getPrincipal(), 0, connection));
        this.connectionIdentityFuture = new FinishedIoFuture<ConnectionPeerIdentity>(this.connectionIdentity);
        this.anonymousIdentity = this.constructIdentity(conf -> new ConnectionPeerIdentity((PeerIdentity.Configuration)conf, AnonymousPrincipal.getInstance(), 1, connection));
        this.anonymousIdentityFuture = new FinishedIoFuture<ConnectionPeerIdentity>(this.anonymousIdentity);
        this.factoryOperator = d -> new ServerNameSaslClientFactory(new ProtocolSaslClientFactory((SaslClientFactory)d, saslProtocol), peerSaslServer);
    }

    public IoFuture<ConnectionPeerIdentity> authenticateAsync(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam("configuration", configuration);
        if (configuration.equals(this.connection.getAuthenticationConfiguration())) {
            return this.connectionIdentityFuture;
        }
        if (CLIENT.getAuthorizationPrincipal(configuration) instanceof AnonymousPrincipal) {
            return this.anonymousIdentityFuture;
        }
        IoFuture<ConnectionPeerIdentity> ioFuture = this.futureAuths.get(configuration);
        if (ioFuture != null) {
            return ioFuture;
        }
        FutureResult futureResult = new FutureResult(this.connection.getEndpoint().getExecutor());
        ioFuture = this.futureAuths.putIfAbsent(configuration, futureResult.getIoFuture());
        if (ioFuture != null) {
            return ioFuture;
        }
        final AtomicReference<Object> statRef = new AtomicReference<Object>(PENDING);
        this.connection.getEndpoint().getExecutor().execute(() -> {
            do {
                Object oldVal;
                if ((oldVal = statRef.get()) != CANCELLED) continue;
                return;
            } while (!statRef.compareAndSet(PENDING, Thread.currentThread()));
            try {
                futureResult.setResult(this.authenticate(configuration));
            }
            catch (AuthenticationException e) {
                futureResult.setException(e);
            }
            statRef.set(null);
        });
        futureResult.addCancelHandler(new Cancellable(){

            @Override
            public Cancellable cancel() {
                do {
                    Object oldVal;
                    if ((oldVal = statRef.get()) == CANCELLED) {
                        return this;
                    }
                    if (!(oldVal instanceof Thread)) continue;
                    ((Thread)oldVal).interrupt();
                    return this;
                } while (!statRef.compareAndSet(PENDING, CANCELLED));
                return this;
            }
        });
        return futureResult.getIoFuture();
    }

    public ConnectionPeerIdentity getExistingIdentity(AuthenticationConfiguration configuration) throws AuthenticationException {
        if (configuration.equals(this.connection.getAuthenticationConfiguration())) {
            return this.connectionIdentity;
        }
        if (CLIENT.getAuthorizationPrincipal(configuration) instanceof AnonymousPrincipal) {
            return this.anonymousIdentity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionPeerIdentity authenticate(AuthenticationConfiguration configuration) throws AuthenticationException {
        if (configuration.equals(this.connection.getAuthenticationConfiguration())) {
            return this.connectionIdentity;
        }
        if (CLIENT.getAuthorizationPrincipal(configuration) instanceof AnonymousPrincipal) {
            return this.anonymousIdentity;
        }
        IoFuture<ConnectionPeerIdentity> ioFuture = this.futureAuths.get(configuration);
        if (ioFuture == null) {
            FutureResult<ConnectionPeerIdentity> futureResult = new FutureResult<ConnectionPeerIdentity>(this.connection.getEndpoint().getExecutor());
            IoFuture appearing = this.futureAuths.putIfAbsent(configuration, futureResult.getIoFuture());
            if (appearing != null) {
                ioFuture = appearing;
            } else {
                final AtomicReference<Thread> threadRef = new AtomicReference<Thread>(Thread.currentThread());
                futureResult.addCancelHandler(new Cancellable(){

                    @Override
                    public Cancellable cancel() {
                        Thread thread = (Thread)threadRef.get();
                        if (thread != null) {
                            thread.interrupt();
                        }
                        return this;
                    }
                });
                try {
                    this.doAuthenticate(configuration, futureResult);
                }
                finally {
                    threadRef.set(null);
                }
                ioFuture = futureResult.getIoFuture();
            }
        }
        try {
            return ioFuture.get();
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (IOException e) {
            throw new AuthenticationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doAuthenticate(AuthenticationConfiguration configuration, FutureResult<ConnectionPeerIdentity> futureResult) {
        Authentication authentication;
        int id;
        Assert.checkNotNullParam("configuration", configuration);
        ConnectionImpl connection = this.connection;
        assert (!configuration.equals(connection.getAuthenticationConfiguration()));
        if (!connection.supportsRemoteAuth()) {
            futureResult.setException(Messages.log.authenticationNotSupported());
            this.futureAuths.remove(configuration, futureResult.getIoFuture());
            return;
        }
        AuthenticationContextConfigurationClient client = CLIENT;
        IntIndexHashMap<Authentication> authMap = this.authMap;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((id = random.nextInt()) == 0 || id == 1 || authMap.containsKey(id) || authMap.putIfAbsent(authentication = new Authentication(id)) != null) {
        }
        int finalId = id;
        boolean intr = Thread.currentThread().isInterrupted();
        if (intr) {
            futureResult.setException(Messages.log.authenticationInterrupted());
            authMap.remove(authentication);
            this.futureAuths.remove(configuration, futureResult.getIoFuture());
            return;
        }
        try {
            String triedStr;
            Principal principal = client.getPrincipal(configuration);
            ConnectionHandler connectionHandler = connection.getConnectionHandler();
            LinkedHashSet<String> mechanisms = new LinkedHashSet<String>(this.offeredMechanisms);
            LinkedHashMap<String, Throwable> triedMechs = new LinkedHashMap<String, Throwable>();
            block32: while (!mechanisms.isEmpty()) {
                byte[] challenge;
                int status;
                byte[] response;
                SaslClient saslClient;
                SSLSession sslSession = connectionHandler.getSslSession();
                UnaryOperator<SaslClientFactory> factoryOperator = this.factoryOperator;
                try {
                    saslClient = client.createSaslClient(connection.getPeerURI(), configuration, mechanisms, factoryOperator, sslSession);
                }
                catch (SaslException e) {
                    futureResult.setException(Messages.log.authenticationNoSaslClient(e));
                    authMap.remove(authentication);
                    this.futureAuths.remove(configuration, futureResult.getIoFuture());
                    if (intr) {
                        Thread.currentThread().interrupt();
                    }
                    return;
                }
                if (saslClient == null) break;
                try {
                    block51: {
                        if (saslClient.hasInitialResponse()) {
                            try {
                                response = saslClient.evaluateChallenge(NO_BYTES);
                                break block51;
                            }
                            catch (SaslException e) {
                                Messages.log.tracef((Throwable)e, "Mechanism failed (client): \"%s\"", (Object)saslClient.getMechanismName());
                                mechanisms.remove(saslClient.getMechanismName());
                                triedMechs.put(saslClient.getMechanismName(), Messages.log.authenticationExceptionIo(e));
                                ConnectionPeerIdentityContext.safeDispose(saslClient);
                                continue;
                            }
                        }
                        response = null;
                    }
                    connectionHandler.sendAuthRequest(id, saslClient.getMechanismName(), response);
                    if (!connectionHandler.isOpen()) {
                        ConnectionPeerIdentityContext.safeDispose(saslClient);
                        futureResult.setException(Messages.log.authenticationExceptionClosed());
                        this.futureAuths.remove(configuration, futureResult.getIoFuture());
                        return;
                    }
                }
                catch (IOException e) {
                    authMap.remove(authentication);
                    ConnectionPeerIdentityContext.safeDispose(saslClient);
                    futureResult.setException(Messages.log.authenticationExceptionIo(e));
                    this.futureAuths.remove(configuration, futureResult.getIoFuture());
                    return;
                }
                while (true) {
                    Authentication authentication2 = authentication;
                    synchronized (authentication2) {
                        status = authentication.getStatus();
                        while (status == 0) {
                            try {
                                authentication.wait();
                            }
                            catch (InterruptedException e) {
                                intr = true;
                            }
                            status = authentication.getStatus();
                        }
                        challenge = authentication.getSaslBytes();
                        authentication.setStatus(0);
                        authentication.setSaslBytes(null);
                    }
                    if (status != 1) break;
                    try {
                        response = saslClient.evaluateChallenge(challenge);
                    }
                    catch (SaslException e) {
                        Messages.log.tracef((Throwable)e, "Mechanism failed (client): \"%s\"", (Object)saslClient.getMechanismName());
                        mechanisms.remove(saslClient.getMechanismName());
                        triedMechs.put(saslClient.getMechanismName(), Messages.log.authenticationExceptionIo(e));
                        ConnectionPeerIdentityContext.safeDispose(saslClient);
                        continue block32;
                    }
                    try {
                        connectionHandler.sendAuthResponse(id, response);
                        if (!connectionHandler.isOpen()) {
                            ConnectionPeerIdentityContext.safeDispose(saslClient);
                            futureResult.setException(Messages.log.authenticationExceptionClosed());
                            this.futureAuths.remove(configuration, futureResult.getIoFuture());
                            return;
                        }
                    }
                    catch (IOException e) {
                        ConnectionPeerIdentityContext.safeDispose(saslClient);
                        futureResult.setException(Messages.log.authenticationExceptionIo(e));
                        this.futureAuths.remove(configuration, futureResult.getIoFuture());
                        return;
                    }
                }
                if (status == 2) {
                    if (!saslClient.isComplete()) {
                        try {
                            response = saslClient.evaluateChallenge(challenge);
                        }
                        catch (SaslException e) {
                            Messages.log.tracef((Throwable)e, "Mechanism failed (client, possibly failed to verify server): \"%s\"", (Object)saslClient.getMechanismName());
                            mechanisms.remove(saslClient.getMechanismName());
                            triedMechs.put(saslClient.getMechanismName(), Messages.log.authenticationExceptionIo(e));
                            ConnectionPeerIdentityContext.safeDispose(saslClient);
                            continue;
                        }
                        if (response != null && response.length > 0) {
                            try {
                                connectionHandler.sendAuthDelete(id);
                            }
                            catch (IOException ignored) {
                                Messages.log.trace("Send failed", ignored);
                            }
                            ConnectionPeerIdentityContext.safeDispose(saslClient);
                            futureResult.setException(Messages.log.authenticationExtraResponse());
                            this.futureAuths.remove(configuration, futureResult.getIoFuture());
                            return;
                        }
                    }
                    Object principalObj = saslClient.getNegotiatedProperty("wildfly.sasl.principal");
                    ConnectionPeerIdentityContext.safeDispose(saslClient);
                    futureResult.setResult(this.constructIdentity(conf -> new ConnectionPeerIdentity((PeerIdentity.Configuration)conf, principalObj instanceof Principal ? (Principal)principalObj : principal, finalId, connection)));
                    return;
                }
                if (status == 3) {
                    Messages.log.tracef("Mechanism failed (client received authentication rejected): \"%s\"", (Object)saslClient.getMechanismName());
                    mechanisms.remove(saslClient.getMechanismName());
                    triedMechs.put(saslClient.getMechanismName(), Messages.log.serverRejectedAuthentication());
                    ConnectionPeerIdentityContext.safeDispose(saslClient);
                    continue;
                }
                if (status == 5) {
                    ConnectionPeerIdentityContext.safeDispose(saslClient);
                    futureResult.setException(Messages.log.authenticationExceptionClosed());
                    this.futureAuths.remove(configuration, futureResult.getIoFuture());
                    return;
                }
                if (status == 4) {
                    ConnectionPeerIdentityContext.safeDispose(saslClient);
                    futureResult.setException(Messages.log.serverRejectedAuthentication());
                    this.futureAuths.remove(configuration, futureResult.getIoFuture());
                    return;
                }
                throw Assert.unreachableCode();
            }
            if (!triedMechs.isEmpty()) {
                StringBuilder b = new StringBuilder();
                triedMechs.forEach((mechanismName, throwable) -> b.append("\n   ").append((String)mechanismName).append(": ").append(throwable.toString()));
                triedStr = b.toString();
            } else {
                triedStr = "(none)";
            }
            futureResult.setException(Messages.log.noAuthMechanismsLeft(triedStr));
            authMap.remove(authentication);
            this.futureAuths.remove(configuration, futureResult.getIoFuture());
            return;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void safeDispose(SaslClient saslClient) {
        try {
            saslClient.dispose();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveChallenge(int id, byte[] challenge) {
        Authentication authentication = this.authMap.get(id);
        if (authentication != null) {
            Authentication authentication2 = authentication;
            synchronized (authentication2) {
                authentication.setSaslBytes(challenge);
                authentication.setStatus(1);
                authentication.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveSuccess(int id, byte[] challenge) {
        Authentication authentication = this.authMap.get(id);
        if (authentication != null) {
            Authentication authentication2 = authentication;
            synchronized (authentication2) {
                authentication.setSaslBytes(challenge);
                authentication.setStatus(2);
                authentication.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveReject(int id) {
        Authentication authentication = this.authMap.get(id);
        if (authentication != null) {
            Authentication authentication2 = authentication;
            synchronized (authentication2) {
                authentication.setStatus(3);
                authentication.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveDeleteAck(int id) {
        Authentication authentication = this.authMap.removeKey(id);
        if (authentication != null) {
            Authentication authentication2 = authentication;
            synchronized (authentication2) {
                authentication.setStatus(4);
                authentication.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionClosed() {
        Iterator<Authentication> iterator = this.authMap.iterator();
        while (iterator.hasNext()) {
            Authentication authentication = iterator.next();
            iterator.remove();
            Authentication authentication2 = authentication;
            synchronized (authentication2) {
                authentication.setStatus(5);
                authentication.notifyAll();
            }
        }
    }

    public ConnectionPeerIdentity getAnonymousIdentity() {
        return this.anonymousIdentity;
    }

    ConnectionPeerIdentity getConnectionIdentity() {
        return this.connectionIdentity;
    }

    @Override
    public ConnectionPeerIdentity getCurrentIdentity() {
        ConnectionPeerIdentity currentIdentity = (ConnectionPeerIdentity)super.getCurrentIdentity();
        return currentIdentity == null ? this.anonymousIdentity : currentIdentity;
    }

    static final class Authentication {
        private final int id;
        private byte[] saslBytes;
        private int status;

        Authentication(int id) {
            this.id = id;
        }

        int getId() {
            return this.id;
        }

        byte[] getSaslBytes() {
            return this.saslBytes;
        }

        void setSaslBytes(byte[] saslBytes) {
            this.saslBytes = saslBytes;
        }

        int getStatus() {
            return this.status;
        }

        void setStatus(int status) {
            this.status = status;
        }
    }
}

