/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.jgroups;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.api.core.jgroups.JChannelManager;
import org.apache.activemq.artemis.api.core.jgroups.JGroupsReceiver;
import org.jboss.logging.Logger;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;

public class JChannelWrapper {
    private static final Logger logger = Logger.getLogger(JChannelWrapper.class);
    private boolean connected = false;
    int refCount = 1;
    final JChannel channel;
    final String channelName;
    final List<JGroupsReceiver> receivers = new ArrayList<JGroupsReceiver>();
    private final JChannelManager manager;

    public JChannelWrapper(JChannelManager manager, final String channelName, JChannel channel) throws Exception {
        this.channelName = channelName;
        this.channel = channel;
        this.manager = manager;
        if (logger.isTraceEnabled() && channel.getReceiver() != null) {
            logger.trace((Object)(this + "The channel already had a receiver previously!!!! == " + channel.getReceiver()), new Exception("trace"));
        }
        channel.setReceiver(new ReceiverAdapter(){

            public String toString() {
                return "ReceiverAdapter::" + JChannelWrapper.this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receive(Message msg) {
                if (logger.isTraceEnabled()) {
                    logger.trace(this + ":: Wrapper received " + msg + " on channel " + channelName);
                }
                List<JGroupsReceiver> list = JChannelWrapper.this.receivers;
                synchronized (list) {
                    for (JGroupsReceiver r : JChannelWrapper.this.receivers) {
                        r.receive(msg);
                    }
                }
            }
        });
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public synchronized void close(boolean closeWrappedChannel) {
        --this.refCount;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this + "::RefCount-- " + this.refCount + " on channel " + this.channelName), new Exception("Trace"));
        }
        if (this.refCount == 0) {
            if (closeWrappedChannel) {
                this.closeChannel();
            }
            this.manager.removeChannel(this.channelName);
        }
    }

    public synchronized void closeChannel() {
        this.connected = false;
        this.channel.setReceiver(null);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this + "::Closing Channel: " + this.channelName), new Exception("Trace"));
        }
        this.channel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReceiver(JGroupsReceiver receiver) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this + "::removeReceiver: " + receiver + " on " + this.channelName), new Exception("Trace"));
        }
        List<JGroupsReceiver> list = this.receivers;
        synchronized (list) {
            this.receivers.remove(receiver);
        }
    }

    public synchronized void connect() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this + ":: Connecting " + this.channelName), new Exception("Trace"));
        }
        if (this.connected) {
            return;
        }
        this.connected = true;
        if (!this.channel.isConnected()) {
            this.channel.connect(this.channelName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReceiver(JGroupsReceiver jGroupsReceiver) {
        List<JGroupsReceiver> list = this.receivers;
        synchronized (list) {
            if (logger.isTraceEnabled()) {
                logger.trace(this + "::Add Receiver: " + jGroupsReceiver + " on " + this.channelName);
            }
            this.receivers.add(jGroupsReceiver);
        }
    }

    public void send(Message msg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace(this + "::Sending JGroups Message: Open=" + this.channel.isOpen() + " on channel " + this.channelName + " msg=" + msg);
        }
        if (!this.manager.isLoopbackMessages()) {
            msg.setTransientFlag(Message.TransientFlag.DONT_LOOPBACK);
        }
        this.channel.send(msg);
    }

    public JChannelWrapper addRef() {
        ++this.refCount;
        if (logger.isTraceEnabled()) {
            logger.trace(this + "::RefCount++ = " + this.refCount + " on channel " + this.channelName);
        }
        return this;
    }

    public String toString() {
        return super.toString() + "{refCount=" + this.refCount + ", channel=" + this.channel + ", channelName='" + this.channelName + '\'' + ", connected=" + this.connected + '}';
    }
}

