/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.api.core.SimpleString;

public class CompositeAddress {
    public static String SEPARATOR = "::";

    public static String toFullyQualified(String address, String qName) {
        return CompositeAddress.toFullyQualified(SimpleString.toSimpleString(address), SimpleString.toSimpleString(qName)).toString();
    }

    public static SimpleString toFullyQualified(SimpleString address, SimpleString qName) {
        SimpleString result = address == null && qName == null ? null : (address != null && qName == null ? address : (address == null && qName != null ? qName : address.concat(SEPARATOR).concat(qName)));
        return result;
    }

    public static boolean isFullyQualified(String address) {
        return address == null ? false : address.contains(SEPARATOR);
    }

    public static boolean isFullyQualified(SimpleString address) {
        return address == null ? false : CompositeAddress.isFullyQualified(address.toString());
    }

    public static SimpleString extractQueueName(SimpleString name) {
        if (name == null) {
            return null;
        }
        String nameString = name.toString();
        String queueName = CompositeAddress.extractQueueName(nameString);
        if (queueName.equals(nameString)) {
            return name;
        }
        return new SimpleString(queueName);
    }

    public static String extractQueueName(String queue) {
        if (queue == null) {
            return null;
        }
        int index = queue.indexOf(SEPARATOR);
        if (index != -1) {
            return queue.substring(index + SEPARATOR.length());
        }
        return queue;
    }

    public static SimpleString extractAddressName(SimpleString address) {
        if (address == null) {
            return null;
        }
        String addrString = address.toString();
        String addressName = CompositeAddress.extractAddressName(addrString);
        if (addressName.equals(addrString)) {
            return address;
        }
        return new SimpleString(addressName);
    }

    public static String extractAddressName(String address) {
        if (address == null) {
            return null;
        }
        int index = address.indexOf(SEPARATOR);
        if (index != -1) {
            return address.substring(0, index);
        }
        return address;
    }
}

