/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.writer.openssh;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.loader.AESPrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.openssh.kdf.BCrypt;
import org.apache.sshd.common.config.keys.writer.KeyPairResourceWriter;
import org.apache.sshd.common.config.keys.writer.openssh.OpenSSHKeyEncryptionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.SecureByteArrayOutputStream;

public class OpenSSHKeyPairResourceWriter
implements KeyPairResourceWriter<OpenSSHKeyEncryptionContext> {
    public static final String DASHES = "-----";
    public static final int LINE_LENGTH = 70;
    public static final OpenSSHKeyPairResourceWriter INSTANCE = new OpenSSHKeyPairResourceWriter();
    private static final Pattern VERTICALSPACE = Pattern.compile("\\v");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePrivateKey(KeyPair key, String comment, OpenSSHKeyEncryptionContext options, OutputStream out) throws IOException, GeneralSecurityException {
        Objects.requireNonNull(key, "Cannot write null key");
        String keyType = KeyUtils.getKeyType(key);
        if (GenericUtils.isEmpty(keyType)) {
            throw new GeneralSecurityException("Unsupported key: " + key.getClass().getName());
        }
        OpenSSHKeyEncryptionContext opt = OpenSSHKeyPairResourceWriter.determineEncryption(options);
        OpenSSHKeyPairResourceWriter.write(out, "-----BEGIN OPENSSH PRIVATE KEY-----");
        out.write(10);
        String cipherName = "none";
        int blockSize = 8;
        if (opt != null) {
            cipherName = opt.getCipherFactoryName();
            BuiltinCiphers spec = BuiltinCiphers.fromFactoryName(cipherName);
            if (spec == null) {
                throw new IllegalArgumentException("Unsupported cipher " + cipherName);
            }
            blockSize = spec.getCipherBlockSize();
        }
        byte[] privateBytes = OpenSSHKeyPairResourceWriter.encodePrivateKey(key, keyType, blockSize, comment);
        String kdfName = "none";
        byte[] kdfOptions = GenericUtils.EMPTY_BYTE_ARRAY;
        try (SecureByteArrayOutputStream bytes = new SecureByteArrayOutputStream();){
            OpenSSHKeyPairResourceWriter.write(bytes, "openssh-key-v1");
            bytes.write(0);
            if (opt != null) {
                KeyEncryptor encryptor = new KeyEncryptor(opt);
                opt.setPrivateKeyObfuscator(encryptor);
                byte[] encodedBytes = encryptor.applyPrivateKeyCipher(privateBytes, opt, true);
                Arrays.fill(privateBytes, (byte)0);
                privateBytes = encodedBytes;
                kdfName = "bcrypt";
                kdfOptions = encryptor.getKdfOptions();
            }
            KeyEntryResolver.encodeString(bytes, cipherName);
            KeyEntryResolver.encodeString(bytes, kdfName);
            KeyEntryResolver.writeRLEBytes((OutputStream)bytes, kdfOptions);
            KeyEntryResolver.encodeInt(bytes, 1);
            KeyEntryResolver.writeRLEBytes((OutputStream)bytes, OpenSSHKeyPairResourceWriter.encodePublicKey(key.getPublic(), keyType));
            KeyEntryResolver.writeRLEBytes((OutputStream)bytes, privateBytes);
            OpenSSHKeyPairResourceWriter.write(out, bytes.toByteArray(), 70);
        }
        finally {
            Arrays.fill(privateBytes, (byte)0);
        }
        OpenSSHKeyPairResourceWriter.write(out, "-----END OPENSSH PRIVATE KEY-----");
        out.write(10);
    }

    public static OpenSSHKeyEncryptionContext determineEncryption(OpenSSHKeyEncryptionContext options) {
        String password;
        String string = password = options == null ? null : options.getPassword();
        if (GenericUtils.isEmpty(password)) {
            return null;
        }
        int len = password.length();
        for (int pos = 0; pos < len; ++pos) {
            char ch = password.charAt(pos);
            if (Character.isWhitespace(ch)) continue;
            return options;
        }
        return null;
    }

    public static byte[] encodePrivateKey(KeyPair key, String keyType, int blockSize, String comment) throws IOException, GeneralSecurityException {
        try (SecureByteArrayOutputStream out = new SecureByteArrayOutputStream();){
            int size;
            int extra;
            int check = new SecureRandom().nextInt();
            KeyEntryResolver.encodeInt(out, check);
            KeyEntryResolver.encodeInt(out, check);
            KeyEntryResolver.encodeString(out, keyType);
            PrivateKeyEntryDecoder<?, ?> encoder = OpenSSHKeyPairResourceParser.getPrivateKeyEntryDecoder(keyType);
            if (encoder.encodePrivateKey(out, key.getPrivate(), key.getPublic()) == null) {
                throw new GeneralSecurityException("Cannot encode key of type " + keyType);
            }
            KeyEntryResolver.encodeString(out, comment == null ? "" : comment);
            if (blockSize > 1 && (extra = (size = out.size()) % blockSize) != 0) {
                for (int i = 1; i <= blockSize - extra; ++i) {
                    out.write(i & 0xFF);
                }
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static byte[] encodePublicKey(PublicKey key, String keyType) throws IOException, GeneralSecurityException {
        PublicKeyEntryDecoder<?, ?> decoder = KeyUtils.getPublicKeyEntryDecoder(keyType);
        if (decoder == null) {
            throw new GeneralSecurityException("Unknown key type: " + keyType);
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            decoder.encodePublicKey(out, key);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(OutputStream out, byte[] bytes, int lineLength) throws IOException {
        byte[] encoded = Base64.getEncoder().encode(bytes);
        Arrays.fill(bytes, (byte)0);
        try {
            int last = encoded.length;
            for (int i = 0; i < last; i += lineLength) {
                if (i + lineLength <= last) {
                    out.write(encoded, i, lineLength);
                } else {
                    out.write(encoded, i, last - i);
                }
                out.write(10);
            }
        }
        finally {
            Arrays.fill(encoded, (byte)0);
        }
    }

    @Override
    public void writePublicKey(PublicKey key, String comment, OutputStream out) throws IOException, GeneralSecurityException {
        StringBuilder b = new StringBuilder(82);
        PublicKeyEntry.appendPublicKeyEntry(b, key);
        String line = OpenSSHKeyPairResourceWriter.firstLine(comment);
        if (GenericUtils.isNotEmpty(line)) {
            b.append(' ').append(line);
        }
        OpenSSHKeyPairResourceWriter.write(out, b.toString());
    }

    public static String firstLine(String text) {
        Matcher m;
        if (GenericUtils.isNotEmpty(text) && (m = VERTICALSPACE.matcher(text)).find()) {
            return text.substring(0, m.start()).trim();
        }
        return text;
    }

    public static void write(OutputStream out, String s) throws IOException {
        out.write(s.getBytes(StandardCharsets.UTF_8));
    }

    public static class KeyEncryptor
    extends AESPrivateKeyObfuscator {
        public static final int BCRYPT_SALT_LENGTH = 16;
        protected final OpenSSHKeyEncryptionContext options;
        private byte[] kdfOptions;

        public KeyEncryptor(OpenSSHKeyEncryptionContext options) {
            this.options = Objects.requireNonNull(options);
        }

        public byte[] getKdfOptions() {
            return this.kdfOptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        protected byte[] deriveEncryptionKey(PrivateKeyEncryptionContext context, int keyLength) throws IOException, GeneralSecurityException {
            byte[] iv = context.getInitVector();
            if (iv == null) {
                iv = this.generateInitializationVector(context);
            }
            byte[] salt = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(salt);
            byte[] kdfOutput = new byte[keyLength + iv.length];
            BCrypt bcrypt = new BCrypt();
            try {
                try (ByteArrayOutputStream kdf = new ByteArrayOutputStream();){
                    int rounds = this.options.getKdfRounds();
                    byte[] pwd2 = this.convert(this.options.getPassword());
                    try {
                        bcrypt.pbkdf(pwd2, salt, rounds, kdfOutput);
                    }
                    finally {
                        if (pwd2 != null) {
                            Arrays.fill(pwd2, (byte)0);
                        }
                    }
                    KeyEntryResolver.writeRLEBytes((OutputStream)kdf, salt);
                    KeyEntryResolver.encodeInt(kdf, rounds);
                    this.kdfOptions = kdf.toByteArray();
                    context.setInitVector(Arrays.copyOfRange(kdfOutput, keyLength, kdfOutput.length));
                    byte[] byArray = Arrays.copyOf(kdfOutput, keyLength);
                    return byArray;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Arrays.fill(kdfOutput, (byte)0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected byte[] convert(String password) {
            ByteBuffer bytes;
            if (GenericUtils.isEmpty(password)) {
                return GenericUtils.EMPTY_BYTE_ARRAY;
            }
            char[] pass = password.toCharArray();
            try {
                bytes = StandardCharsets.UTF_8.encode(CharBuffer.wrap(pass));
            }
            finally {
                Arrays.fill(pass, '\u0000');
            }
            byte[] pwd2 = new byte[bytes.remaining()];
            bytes.get(pwd2);
            if (bytes.hasArray()) {
                Arrays.fill(bytes.array(), (byte)0);
            }
            return pwd2;
        }
    }
}

