/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.audit;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.handlers.SyslogHandler;
import org.jboss.logmanager.handlers.TcpOutputStream;
import org.xnio.IoUtils;

public class SyslogAuditLogHandler
extends AuditLogHandler {
    private final PathManagerService pathManager;
    private volatile SyslogHandler handler;
    private volatile String appName = "WildFly";
    private volatile String hostName;
    private volatile SyslogHandler.SyslogType syslogType = SyslogHandler.SyslogType.RFC5424;
    private volatile boolean truncate;
    private volatile int maxLength;
    private volatile InetAddress syslogServerAddress;
    private volatile int port = 514;
    private volatile Transport transport = Transport.UDP;
    private volatile MessageTransfer messageTransfer = MessageTransfer.NON_TRANSPARENT_FRAMING;
    private volatile String tlsTrustStorePath;
    private volatile String tlsTrustStoreRelativeTo;
    private volatile String tlsTrustStorePassword;
    private volatile String tlsClientCertStorePath;
    private volatile String tlsClientCertStoreRelativeTo;
    private volatile String tlsClientCertStorePassword;
    private volatile String tlsClientCertStoreKeyPassword;

    public SyslogAuditLogHandler(String name, String formatterName, int maxFailureCount, PathManagerService pathManager) {
        super(name, formatterName, maxFailureCount);
        this.pathManager = pathManager;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setSyslogType(SyslogHandler.SyslogType syslogType) {
        this.syslogType = syslogType;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMessageTransfer(MessageTransfer messageTransfer) {
        this.messageTransfer = messageTransfer;
    }

    public void setSyslogServerAddress(InetAddress syslogServerAddress) {
        this.syslogServerAddress = syslogServerAddress;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public void setTlsTrustStorePath(String tlsTrustStorePath) {
        this.tlsTrustStorePath = tlsTrustStorePath;
    }

    public void setTlsTrustStoreRelativeTo(String tlsTrustStoreRelativeTo) {
        this.tlsTrustStoreRelativeTo = tlsTrustStoreRelativeTo;
    }

    public void setTlsTruststorePassword(String tlsTrustStorePassword) {
        this.tlsTrustStorePassword = tlsTrustStorePassword;
    }

    public void setTlsClientCertStorePath(String tlsClientCertStorePath) {
        this.tlsClientCertStorePath = tlsClientCertStorePath;
    }

    public void setTlsClientCertStoreRelativeTo(String tlsClientCertStoreRelativeTo) {
        this.tlsClientCertStoreRelativeTo = tlsClientCertStoreRelativeTo;
    }

    public void setTlsClientCertStorePassword(String tlsClientCertStorePassword) {
        this.tlsClientCertStorePassword = tlsClientCertStorePassword;
    }

    public void setTlsClientCertStoreKeyPassword(String tlsClientCertStoreKeyPassword) {
        this.tlsClientCertStoreKeyPassword = tlsClientCertStoreKeyPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initialize() {
        block20: {
            try {
                SyslogHandler.Protocol protocol;
                if (this.handler != null) {
                    return;
                }
                switch (this.transport) {
                    case UDP: {
                        protocol = SyslogHandler.Protocol.UDP;
                        break;
                    }
                    case TCP: {
                        protocol = SyslogHandler.Protocol.TCP;
                        break;
                    }
                    case TLS: {
                        protocol = SyslogHandler.Protocol.SSL_TCP;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown protocol");
                    }
                }
                this.handler = new SyslogHandler(this.syslogServerAddress, this.port, SyslogHandler.DEFAULT_FACILITY, this.syslogType, protocol, this.hostName == null ? InetAddress.getLocalHost().getHostName() : this.hostName);
                this.handler.setEscapeEnabled(false);
                this.handler.setAppName(this.appName);
                this.handler.setTruncate(this.truncate);
                if (this.maxLength != 0) {
                    this.handler.setMaxLength(this.maxLength);
                }
                this.handler.setSyslogType(this.syslogType);
                if (this.transport == Transport.UDP) break block20;
                if (this.messageTransfer == MessageTransfer.NON_TRANSPARENT_FRAMING) {
                    this.handler.setUseCountingFraming(false);
                    this.handler.setMessageDelimiter("\n");
                    this.handler.setUseMessageDelimiter(true);
                } else {
                    this.handler.setUseCountingFraming(true);
                    this.handler.setMessageDelimiter(null);
                    this.handler.setUseMessageDelimiter(false);
                }
                if (this.transport == Transport.TLS && (this.tlsClientCertStorePath != null || this.tlsTrustStorePath != null)) {
                    SSLContext context = SSLContext.getInstance("TLS");
                    KeyManager[] keyManagers = null;
                    if (this.tlsClientCertStorePath != null) {
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        FileInputStream in = new FileInputStream(this.pathManager.resolveRelativePathEntry(this.tlsClientCertStorePath, this.tlsClientCertStoreRelativeTo));
                        try {
                            KeyStore ks = KeyStore.getInstance("JKS");
                            ks.load(in, this.tlsClientCertStorePassword.toCharArray());
                            kmf.init(ks, this.tlsClientCertStoreKeyPassword != null ? this.tlsClientCertStoreKeyPassword.toCharArray() : this.tlsClientCertStorePassword.toCharArray());
                            keyManagers = kmf.getKeyManagers();
                        }
                        finally {
                            IoUtils.safeClose((Closeable)in);
                        }
                    }
                    TrustManager[] trustManagers = null;
                    if (this.tlsTrustStorePath != null) {
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        FileInputStream in = new FileInputStream(this.pathManager.resolveRelativePathEntry(this.tlsTrustStorePath, this.tlsTrustStoreRelativeTo));
                        try {
                            KeyStore ks = KeyStore.getInstance("JKS");
                            ks.load(in, this.tlsTrustStorePassword.toCharArray());
                            tmf.init(ks);
                            trustManagers = tmf.getTrustManagers();
                        }
                        finally {
                            IoUtils.safeClose((Closeable)in);
                        }
                    }
                    context.init(keyManagers, trustManagers, null);
                    this.handler.setOutputStream((OutputStream)((Object)new SSLContextOutputStream(context, this.syslogServerAddress, this.port)));
                    break block20;
                }
                this.handler.setProtocol(this.transport == Transport.TCP ? SyslogHandler.Protocol.TCP : SyslogHandler.Protocol.SSL_TCP);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    void stop() {
        SyslogHandler handler = this.handler;
        this.handler = null;
        if (handler != null) {
            handler.close();
        }
    }

    @Override
    void writeLogItem(String formattedItem) throws IOException {
        this.handler.publish(new ExtLogRecord((java.util.logging.Level)Level.WARN, formattedItem, SyslogAuditLogHandler.class.getName()));
    }

    @Override
    boolean isDifferent(AuditLogHandler other) {
        if (!(other instanceof SyslogAuditLogHandler)) {
            return true;
        }
        SyslogAuditLogHandler otherHandler = (SyslogAuditLogHandler)other;
        if (!this.name.equals(otherHandler.name)) {
            return true;
        }
        if (!this.getFormatterName().equals(otherHandler.getFormatterName())) {
            return true;
        }
        if (!this.appName.equals(otherHandler.appName)) {
            return true;
        }
        if (!this.hostName.equals(otherHandler.hostName)) {
            return true;
        }
        if (!this.syslogType.equals((Object)otherHandler.syslogType)) {
            return true;
        }
        if (!this.truncate == otherHandler.truncate) {
            return true;
        }
        if (this.maxLength != otherHandler.maxLength) {
            return true;
        }
        if (!this.syslogServerAddress.equals(otherHandler.syslogServerAddress)) {
            return true;
        }
        if (this.port != otherHandler.port) {
            return true;
        }
        if (!this.transport.equals((Object)otherHandler.transport)) {
            return true;
        }
        if (!this.compare((Object)this.messageTransfer, (Object)otherHandler.messageTransfer)) {
            return true;
        }
        if (!this.compare(this.tlsTrustStorePath, otherHandler.tlsTrustStorePath)) {
            return true;
        }
        if (!this.compare(this.tlsTrustStoreRelativeTo, otherHandler.tlsTrustStoreRelativeTo)) {
            return true;
        }
        if (!this.compare(this.tlsTrustStorePassword, otherHandler.tlsTrustStorePassword)) {
            return true;
        }
        if (!this.compare(this.tlsClientCertStorePath, otherHandler.tlsClientCertStorePath)) {
            return true;
        }
        if (!this.compare(this.tlsClientCertStoreRelativeTo, otherHandler.tlsClientCertStoreRelativeTo)) {
            return true;
        }
        if (!this.compare(this.tlsClientCertStorePassword, otherHandler.tlsClientCertStorePassword)) {
            return true;
        }
        return !this.compare(this.tlsClientCertStoreKeyPassword, otherHandler.tlsClientCertStoreKeyPassword);
    }

    private boolean compare(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null && two != null) {
            return false;
        }
        if (one != null && two == null) {
            return false;
        }
        return one.equals(two);
    }

    private static class SSLContextOutputStream
    extends TcpOutputStream {
        protected SSLContextOutputStream(SSLContext sslContext, InetAddress host, int port) throws IOException {
            super(sslContext.getSocketFactory().createSocket(host, port));
        }
    }

    public static enum MessageTransfer {
        OCTET_COUNTING,
        NON_TRANSPARENT_FRAMING;

    }

    public static enum Transport {
        UDP,
        TCP,
        TLS;

    }
}

