/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.util.List;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class MapValidator
extends ModelTypeValidator
implements ParameterValidator {
    private final int min;
    private final int max;
    private final ParameterValidator elementValidator;

    public MapValidator(ParameterValidator elementValidator) {
        this(elementValidator, false, 1, Integer.MAX_VALUE);
    }

    public MapValidator(ParameterValidator elementValidator, boolean nullable) {
        this(elementValidator, nullable, 1, Integer.MAX_VALUE);
    }

    public MapValidator(ParameterValidator elementValidator, boolean nullable, int minSize, int maxSize) {
        super(ModelType.OBJECT, nullable, false, false);
        if (elementValidator == null) {
            throw ControllerMessages.MESSAGES.nullVar("elementValidator");
        }
        this.min = minSize;
        this.max = maxSize;
        this.elementValidator = elementValidator;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            List list = value.asPropertyList();
            int size = list.size();
            if (size < this.min) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.invalidMinSize(size, parameterName, this.min)));
            }
            if (size > this.max) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.invalidMaxSize(size, parameterName, this.max)));
            }
            for (Property property : list) {
                this.elementValidator.validateParameter(parameterName, property.getValue());
            }
        }
    }
}

