/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.jaxrs.logging.JaxrsLogger;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.config.Configuration;
import org.jboss.resteasy.spi.config.ConfigurationFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WildFlyConfigurationFactory
implements ConfigurationFactory {
    private static final ConfigurationFactory DEFAULT = () -> Integer.MAX_VALUE;
    private final Map<ClassLoader, ConfigurationFactory> delegates = new ConcurrentHashMap<ClassLoader, ConfigurationFactory>();

    static WildFlyConfigurationFactory getInstance() {
        ConfigurationFactory result = ConfigurationFactory.getInstance();
        if (!(result instanceof WildFlyConfigurationFactory)) {
            throw JaxrsLogger.JAXRS_LOGGER.invalidConfigurationFactory(result == null ? null : result.getClass());
        }
        return (WildFlyConfigurationFactory)result;
    }

    void register(ClassLoader classLoader, boolean useMpConfig) {
        this.delegates.put(classLoader, WildFlyConfigurationFactory.createDelegate(classLoader, useMpConfig));
    }

    void unregister(ClassLoader classLoader) {
        this.delegates.remove(classLoader);
    }

    public Configuration getConfiguration() {
        return this.getDelegate().getConfiguration();
    }

    public Configuration getConfiguration(ResteasyConfiguration config) {
        return this.getDelegate().getConfiguration(config);
    }

    public int priority() {
        return 0;
    }

    private ConfigurationFactory getDelegate() {
        return this.delegates.getOrDefault(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged(), DEFAULT);
    }

    private static ConfigurationFactory createDelegate(ClassLoader classLoader, boolean useMpConfig) {
        if (useMpConfig) {
            try {
                Constructor<? extends ConfigurationFactory> constructor = WildFlyConfigurationFactory.getMpConfigFactory(classLoader).getConstructor(new Class[0]);
                return constructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                JaxrsLogger.JAXRS_LOGGER.failedToLoadConfigurationFactory(e.getMessage());
            }
        }
        return DEFAULT;
    }

    private static Class<? extends ConfigurationFactory> getMpConfigFactory(ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName("org.jboss.resteasy.microprofile.config.ConfigConfigurationFactory", false, classLoader);
    }
}

