/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyAddStepHandler;
import org.jboss.as.controller.ModelOnlyResourceDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.keycloak.subsystem.adapter.extension.KeycloakExtension;
import org.keycloak.subsystem.adapter.extension.SharedAttributeDefinitons;

abstract class AbstractAdapterConfigurationDefinition
extends ModelOnlyResourceDefinition {
    protected static final SimpleAttributeDefinition REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition RESOURCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("resource", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition USE_RESOURCE_ROLE_MAPPINGS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-resource-role-mappings", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition BEARER_ONLY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("bearer-only", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition ENABLE_BASIC_AUTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-basic-auth", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition PUBLIC_CLIENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("public-client", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition TURN_OFF_CHANGE_SESSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("turn-off-change-session-id-on-login", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition TOKEN_MINIMUM_TIME_TO_LIVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("token-minimum-time-to-live", ModelType.INT, true).setValidator((ParameterValidator)new IntRangeValidator(-1, true))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition MIN_TIME_BETWEEN_JWKS_REQUESTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("min-time-between-jwks-requests", ModelType.INT, true).setValidator((ParameterValidator)new IntRangeValidator(-1, true))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition PUBLIC_KEY_CACHE_TTL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("public-key-cache-ttl", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(-1, true))).build();
    protected static final SimpleAttributeDefinition ADAPTER_STATE_COOKIE_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("adapter-state-cookie-path", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    static final List<SimpleAttributeDefinition> DEPLOYMENT_ONLY_ATTRIBUTES = new ArrayList<SimpleAttributeDefinition>();
    static final List<SimpleAttributeDefinition> ALL_ATTRIBUTES;
    static final SimpleAttributeDefinition[] ALL_ATTRIBUTES_ARRAY;
    static final Map<String, SimpleAttributeDefinition> XML_ATTRIBUTES;
    private static final Map<String, SimpleAttributeDefinition> DEFINITION_LOOKUP;

    protected AbstractAdapterConfigurationDefinition(String name, SimpleAttributeDefinition[] attributes) {
        super(PathElement.pathElement((String)name), KeycloakExtension.getResourceDescriptionResolver(name), new ModelOnlyAddStepHandler((AttributeDefinition[])attributes), (AttributeDefinition[])attributes);
    }

    public static SimpleAttributeDefinition lookup(String name) {
        return DEFINITION_LOOKUP.get(name);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)KeycloakExtension.CREDENTIAL_DEFINITION);
        resourceRegistration.registerSubModel((ResourceDefinition)KeycloakExtension.REDIRECT_RULE_DEFINITON);
    }

    static {
        DEPLOYMENT_ONLY_ATTRIBUTES.add(REALM);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(RESOURCE);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(USE_RESOURCE_ROLE_MAPPINGS);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(BEARER_ONLY);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(ENABLE_BASIC_AUTH);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(PUBLIC_CLIENT);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(TURN_OFF_CHANGE_SESSION);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(TOKEN_MINIMUM_TIME_TO_LIVE);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(MIN_TIME_BETWEEN_JWKS_REQUESTS);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(PUBLIC_KEY_CACHE_TTL);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(ADAPTER_STATE_COOKIE_PATH);
        ALL_ATTRIBUTES = new ArrayList<SimpleAttributeDefinition>();
        ALL_ATTRIBUTES.addAll(DEPLOYMENT_ONLY_ATTRIBUTES);
        ALL_ATTRIBUTES.addAll(SharedAttributeDefinitons.ATTRIBUTES);
        ALL_ATTRIBUTES_ARRAY = ALL_ATTRIBUTES.toArray(new SimpleAttributeDefinition[ALL_ATTRIBUTES.size()]);
        XML_ATTRIBUTES = new HashMap<String, SimpleAttributeDefinition>();
        for (SimpleAttributeDefinition def : ALL_ATTRIBUTES) {
            XML_ATTRIBUTES.put(def.getXmlName(), def);
        }
        DEFINITION_LOOKUP = new HashMap<String, SimpleAttributeDefinition>();
        for (SimpleAttributeDefinition def : ALL_ATTRIBUTES) {
            DEFINITION_LOOKUP.put(def.getXmlName(), def);
        }
    }
}

