/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.HornetQService;
import org.jboss.dmr.ModelNode;

interface HornetQReloadRequiredHandlers {

    public static final class WriteAttributeHandler
    extends AbstractWriteAttributeHandler<Void> {
        public WriteAttributeHandler(AttributeDefinition ... definitions) {
            super(definitions);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            return HornetQService.isHornetQServiceInstalled(context, operation);
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            if (HornetQService.isHornetQServiceInstalled(context, operation)) {
                context.revertReloadRequired();
            }
        }
    }

    public static final class RemoveStepHandler
    extends AbstractRemoveStepHandler {
        private boolean reloadRequired = false;

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (HornetQService.isHornetQServiceInstalled(context, operation)) {
                context.reloadRequired();
                this.reloadRequired = true;
            }
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (this.reloadRequired && HornetQService.isHornetQServiceInstalled(context, operation)) {
                context.revertReloadRequired();
            }
        }
    }

    public static class AddStepHandler
    extends AbstractAddStepHandler {
        private boolean reloadRequired = false;

        public AddStepHandler(AttributeDefinition ... attributes) {
            super(attributes);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (HornetQService.isHornetQServiceInstalled(context, operation)) {
                context.reloadRequired();
                this.reloadRequired = true;
            }
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            if (this.reloadRequired && HornetQService.isHornetQServiceInstalled(context, operation)) {
                context.revertReloadRequired();
            }
        }
    }
}

