/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class QueueService
implements Service<Void> {
    private final InjectedValue<HornetQServer> hornetQService = new InjectedValue();
    private final CoreQueueConfiguration queueConfiguration;
    private final boolean temporary;

    public QueueService(CoreQueueConfiguration queueConfiguration, boolean temporary) {
        if (queueConfiguration == null) {
            throw MessagingMessages.MESSAGES.nullVar("queueConfiguration");
        }
        this.queueConfiguration = queueConfiguration;
        this.temporary = temporary;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            HornetQServer hornetQServer = (HornetQServer)this.hornetQService.getValue();
            hornetQServer.deployQueue(new SimpleString(this.queueConfiguration.getAddress()), new SimpleString(this.queueConfiguration.getName()), SimpleString.toSimpleString((String)this.queueConfiguration.getFilterString()), this.queueConfiguration.isDurable(), this.temporary);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            HornetQServer hornetQService = (HornetQServer)this.hornetQService.getValue();
            hornetQService.destroyQueue(new SimpleString(this.queueConfiguration.getName()), null, false);
        }
        catch (Exception e) {
            MessagingLogger.MESSAGING_LOGGER.failedToDestroy("queue", this.queueConfiguration.getName());
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    InjectedValue<HornetQServer> getHornetQService() {
        return this.hornetQService;
    }
}

