/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.messaging.BridgeDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingSubsystemParser;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class Messaging12SubsystemParser
extends MessagingSubsystemParser {
    private static final Messaging12SubsystemParser INSTANCE = new Messaging12SubsystemParser();

    public static MessagingSubsystemParser getInstance() {
        return INSTANCE;
    }

    protected Messaging12SubsystemParser() {
    }

    @Override
    protected void handleUnknownConnectionFactoryAttribute(XMLExtendedStreamReader reader, Element element, ModelNode connectionFactory, boolean pooled) throws XMLStreamException {
        switch (element) {
            case MAX_POOL_SIZE: 
            case MIN_POOL_SIZE: {
                if (!pooled) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                Messaging12SubsystemParser.handleElementText(reader, element, connectionFactory);
                break;
            }
            default: {
                super.handleUnknownConnectionFactoryAttribute(reader, element, connectionFactory, pooled);
            }
        }
    }

    @Override
    protected void processBridge(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode bridgeAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("bridge", name));
        EnumSet<Element> required = EnumSet.of(Element.QUEUE_NAME);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            required.remove((Object)element);
            switch (element) {
                case QUEUE_NAME: 
                case HA: 
                case TRANSFORMER_CLASS_NAME: 
                case USER: 
                case PASSWORD: {
                    Messaging12SubsystemParser.handleElementText(reader, element, bridgeAdd);
                    continue block9;
                }
                case FILTER: {
                    String string = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string");
                    CommonAttributes.FILTER.parseAndSetParameter(string, bridgeAdd, (XMLStreamReader)reader);
                    continue block9;
                }
                case CHECK_PERIOD: 
                case CONNECTION_TTL: 
                case MAX_RETRY_INTERVAL: 
                case MIN_LARGE_MESSAGE_SIZE: 
                case RETRY_INTERVAL: 
                case RETRY_INTERVAL_MULTIPLIER: {
                    Messaging12SubsystemParser.handleElementText(reader, element, "default", bridgeAdd);
                    continue block9;
                }
                case CONFIRMATION_WINDOW_SIZE: 
                case FORWARDING_ADDRESS: 
                case RECONNECT_ATTEMPTS: 
                case USE_DUPLICATE_DETECTION: {
                    Messaging12SubsystemParser.handleElementText(reader, element, "bridge", bridgeAdd);
                    continue block9;
                }
                case STATIC_CONNECTORS: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.STATIC_CONNECTORS, Element.DISCOVERY_GROUP_REF);
                    this.processStaticConnectors(reader, bridgeAdd, false);
                    continue block9;
                }
                case DISCOVERY_GROUP_REF: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.DISCOVERY_GROUP_REF, Element.STATIC_CONNECTORS);
                    String groupRef = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)BridgeDefinition.DISCOVERY_GROUP_NAME.getXmlName());
                    BridgeDefinition.DISCOVERY_GROUP_NAME.parseAndSetParameter(groupRef, bridgeAdd, (XMLStreamReader)reader);
                    continue block9;
                }
                case FAILOVER_ON_SERVER_SHUTDOWN: {
                    MessagingLogger.ROOT_LOGGER.deprecatedXMLElement(element.toString());
                    Messaging12SubsystemParser.handleElementText(reader, element, bridgeAdd);
                    continue block9;
                }
            }
            this.handleUnknownBridgeAttribute(reader, element, bridgeAdd);
        }
        Messaging12SubsystemParser.checkOnlyOneOfElements(reader, seen, Element.STATIC_CONNECTORS, Element.DISCOVERY_GROUP_REF);
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(bridgeAdd);
    }

    protected void handleUnknownBridgeAttribute(XMLExtendedStreamReader reader, Element element, ModelNode bridgeAdd) throws XMLStreamException {
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    @Override
    protected void handleUnknownClusterConnectionAttribute(XMLExtendedStreamReader reader, Element element, ModelNode clusterConnectionAdd) throws XMLStreamException {
        switch (element) {
            case CALL_TIMEOUT: {
                Messaging12SubsystemParser.handleElementText(reader, element, clusterConnectionAdd);
                break;
            }
            case CHECK_PERIOD: 
            case CONNECTION_TTL: 
            case MAX_RETRY_INTERVAL: 
            case RETRY_INTERVAL_MULTIPLIER: 
            case RECONNECT_ATTEMPTS: {
                Messaging12SubsystemParser.handleElementText(reader, element, "cluster", clusterConnectionAdd);
                break;
            }
            case MIN_LARGE_MESSAGE_SIZE: {
                Messaging12SubsystemParser.handleElementText(reader, element, "default", clusterConnectionAdd);
                break;
            }
            default: {
                super.handleUnknownClusterConnectionAttribute(reader, element, clusterConnectionAdd);
            }
        }
    }

    @Override
    protected void checkClusterConnectionConstraints(XMLExtendedStreamReader reader, Set<Element> seen) throws XMLStreamException {
        Messaging12SubsystemParser.checkOnlyOneOfElements(reader, seen, Element.STATIC_CONNECTORS, Element.DISCOVERY_GROUP_REF);
    }
}

