/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.HTTPAcceptorDefinition;
import org.jboss.as.messaging.HTTPUpgradeService;
import org.jboss.as.messaging.TransportConfigOperationHandlers;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class HTTPAcceptorAdd
extends TransportConfigOperationHandlers.BasicTransportConfigAdd
implements DescriptionProvider {
    public static final HTTPAcceptorAdd INSTANCE = new HTTPAcceptorAdd();

    private HTTPAcceptorAdd() {
        super(false, HTTPAcceptorDefinition.ATTRIBUTES);
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        super.performRuntime(context, operation, model, verificationHandler, newControllers);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String hornetqServerName = address.getElement(address.size() - 2).getValue();
        String acceptorName = address.getLastElement().getValue();
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        this.launchServices(context, hornetqServerName, acceptorName, fullModel, verificationHandler, newControllers);
    }

    void launchServices(OperationContext context, String hornetqServerName, String acceptorName, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String httpConnectorName = HTTPAcceptorDefinition.HTTP_LISTENER.resolveModelAttribute(context, model).asString();
        HTTPUpgradeService.installService(context.getServiceTarget(), hornetqServerName, acceptorName, httpConnectorName, verificationHandler, newControllers);
    }
}

