/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.naming.InitialContextFactory;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.naming.logging.NamingLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class InitialContext
extends InitialLdapContext {
    private static volatile Map<String, ObjectFactory> urlContextFactories = Collections.emptyMap();

    public static synchronized void addUrlContextFactory(String scheme, ObjectFactory factory) {
        HashMap<String, ObjectFactory> factories = new HashMap<String, ObjectFactory>(urlContextFactories);
        factories.put(scheme, factory);
        urlContextFactories = Collections.unmodifiableMap(factories);
    }

    public static synchronized void removeUrlContextFactory(String scheme, ObjectFactory factory) {
        HashMap<String, ObjectFactory> factories = new HashMap<String, ObjectFactory>(urlContextFactories);
        ObjectFactory f = (ObjectFactory)factories.get(scheme);
        if (f == factory) {
            factories.remove(scheme);
            urlContextFactories = Collections.unmodifiableMap(factories);
            return;
        }
        throw new IllegalArgumentException();
    }

    public InitialContext(Hashtable<?, ?> environment) throws NamingException {
        super(environment, null);
    }

    @Override
    protected void init(Hashtable<?, ?> environment) throws NamingException {
        this.myProps = environment;
        if (this.myProps != null && this.myProps.get("java.naming.factory.initial") != null) {
            this.getDefaultInitCtx();
        }
    }

    @Override
    protected Context getDefaultInitCtx() throws NamingException {
        if (!this.gotDefault) {
            String factoryClassName;
            String string = factoryClassName = this.myProps != null ? (String)this.myProps.get("java.naming.factory.initial") : null;
            if (factoryClassName == null || InitialContextFactory.class.getName().equals(factoryClassName)) {
                this.defaultInitCtx = new DefaultInitialContext((Hashtable<Object, Object>)this.myProps);
            } else {
                ClassLoader classLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    Class<?> factoryClass = Class.forName(factoryClassName, true, classLoader);
                    this.defaultInitCtx = ((javax.naming.spi.InitialContextFactory)factoryClass.newInstance()).getInitialContext(this.myProps);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw NamingLogger.ROOT_LOGGER.failedToInstantiate(e, "InitialContextFactory", factoryClassName, classLoader);
                }
            }
            this.gotDefault = true;
        }
        return this.defaultInitCtx;
    }

    @Override
    protected Context getURLOrDefaultInitCtx(String name) throws NamingException {
        String scheme = InitialContext.getURLScheme(name);
        if (scheme != null && !scheme.equals("java")) {
            ObjectFactory factory = urlContextFactories.get(scheme);
            if (factory != null) {
                try {
                    return (Context)factory.getObjectInstance(null, null, null, this.myProps);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    NamingException n = new NamingException(e.getMessage());
                    n.initCause(e);
                    throw n;
                }
            }
            Context ctx = NamingManager.getURLContext(scheme, this.myProps);
            if (ctx != null) {
                return ctx;
            }
        }
        return this.getDefaultInitCtx();
    }

    @Override
    protected Context getURLOrDefaultInitCtx(Name name) throws NamingException {
        if (name.size() > 0) {
            return this.getURLOrDefaultInitCtx(name.get(0));
        }
        return this.getDefaultInitCtx();
    }

    public static String getURLScheme(String str) {
        int colon_posn = str.indexOf(58);
        int slash_posn = str.indexOf(47);
        if (colon_posn > 0 && (slash_posn == -1 || colon_posn < slash_posn)) {
            return str.substring(0, colon_posn);
        }
        return null;
    }

    static class DefaultInitialContext
    extends NamingContext {
        public DefaultInitialContext(Hashtable<Object, Object> environment) {
            super(environment);
        }

        private Context findContext(Name name, ParsedName parsedName) throws NamingException {
            if (parsedName.namespace() == null || parsedName.namespace().equals("")) {
                return null;
            }
            NamespaceContextSelector selector = NamespaceContextSelector.getCurrentSelector();
            if (selector == null) {
                throw new NameNotFoundException(name.toString());
            }
            Context namespaceContext = selector.getContext(parsedName.namespace());
            if (namespaceContext == null) {
                throw new NameNotFoundException(name.toString());
            }
            return namespaceContext;
        }

        private ParsedName parse(Name name) throws NamingException {
            Name remaining;
            String namespace;
            if (name.isEmpty()) {
                namespace = null;
                remaining = name;
            } else {
                String first = name.get(0);
                if (first.startsWith("java:")) {
                    String theRest = first.substring(5);
                    if (theRest.startsWith("/")) {
                        namespace = null;
                        remaining = this.getNameParser(theRest).parse(theRest);
                    } else if (theRest.equals("jboss") && name.size() > 1 && name.get(1).equals("exported")) {
                        namespace = "jboss/exported";
                        remaining = name.getSuffix(2);
                    } else {
                        namespace = theRest;
                        remaining = name.getSuffix(1);
                    }
                } else {
                    namespace = null;
                    remaining = name;
                }
            }
            return new ParsedName(){

                @Override
                public String namespace() {
                    return namespace;
                }

                @Override
                public Name remaining() {
                    return remaining;
                }
            };
        }

        @Override
        public Object lookup(Name name, boolean dereference) throws NamingException {
            ParsedName parsedName = this.parse(name);
            Context namespaceContext = this.findContext(name, parsedName);
            if (namespaceContext == null) {
                return super.lookup(parsedName.remaining(), dereference);
            }
            return namespaceContext.lookup(parsedName.remaining());
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
            ParsedName parsedName = this.parse(name);
            Context namespaceContext = this.findContext(name, parsedName);
            if (namespaceContext == null) {
                return super.listBindings(parsedName.remaining());
            }
            return namespaceContext.listBindings(parsedName.remaining());
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
            ParsedName parsedName = this.parse(name);
            Context namespaceContext = this.findContext(name, parsedName);
            if (namespaceContext == null) {
                return super.list(parsedName.remaining());
            }
            return namespaceContext.list(parsedName.remaining());
        }

        @Override
        public void bind(Name name, Object object) throws NamingException {
            ParsedName parsedName = this.parse(name);
            Context namespaceContext = this.findContext(name, parsedName);
            if (namespaceContext == null) {
                super.bind(parsedName.remaining(), object);
            } else {
                namespaceContext.bind(parsedName.remaining(), object);
            }
        }

        @Override
        public void rebind(Name name, Object object) throws NamingException {
            ParsedName parsedName = this.parse(name);
            Context namespaceContext = this.findContext(name, parsedName);
            if (namespaceContext == null) {
                super.rebind(parsedName.remaining(), object);
            } else {
                namespaceContext.rebind(parsedName.remaining(), object);
            }
        }

        @Override
        public void unbind(Name name) throws NamingException {
            ParsedName parsedName = this.parse(name);
            Context namespaceContext = this.findContext(name, parsedName);
            if (namespaceContext == null) {
                super.unbind(parsedName.remaining());
            } else {
                namespaceContext.unbind(parsedName.remaining());
            }
        }

        @Override
        public void destroySubcontext(Name name) throws NamingException {
            ParsedName parsedName = this.parse(name);
            Context namespaceContext = this.findContext(name, parsedName);
            if (namespaceContext == null) {
                super.destroySubcontext(parsedName.remaining());
            } else {
                namespaceContext.destroySubcontext(parsedName.remaining());
            }
        }

        @Override
        public Context createSubcontext(Name name) throws NamingException {
            ParsedName parsedName = this.parse(name);
            Context namespaceContext = this.findContext(name, parsedName);
            if (namespaceContext == null) {
                return super.createSubcontext(parsedName.remaining());
            }
            return namespaceContext.createSubcontext(parsedName.remaining());
        }
    }

    private static interface ParsedName {
        public String namespace();

        public Name remaining();
    }
}

