/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Collections;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.CollectorContext;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonType;
import wiremock.com.networknt.schema.TypeFactory;
import wiremock.com.networknt.schema.UnionTypeValidator;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.utils.JsonNodeUtil;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class TypeValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(TypeValidator.class);
    private JsonType schemaType;
    private JsonSchema parentSchema;
    private UnionTypeValidator unionTypeValidator;

    public TypeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.TYPE, validationContext);
        this.schemaType = TypeFactory.getSchemaNodeType(schemaNode);
        this.parentSchema = parentSchema;
        this.validationContext = validationContext;
        if (this.schemaType == JsonType.UNION) {
            this.unionTypeValidator = new UnionTypeValidator(schemaPath, schemaNode, parentSchema, validationContext);
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    public JsonType getSchemaType() {
        return this.schemaType;
    }

    public boolean equalsToSchemaType(JsonNode node) {
        return JsonNodeUtil.equalsToSchemaType(node, this.schemaType, this.parentSchema, this.validationContext);
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        TypeValidator.debug(logger, node, rootNode, at);
        if (this.schemaType == JsonType.UNION) {
            return this.unionTypeValidator.validate(node, rootNode, at);
        }
        if (!this.equalsToSchemaType(node)) {
            JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
            return Collections.singleton(this.buildValidationMessage(at, nodeType.toString(), this.schemaType.toString()));
        }
        if (this.schemaPath.endsWith("/type")) {
            if (rootNode.isArray()) {
                CollectorContext.getInstance().getEvaluatedItems().add(at);
            } else if (rootNode.isObject()) {
                CollectorContext.getInstance().getEvaluatedProperties().add(at);
            }
        }
        return Collections.emptySet();
    }
}

