/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.hpack;

import wiremock.org.eclipse.jetty.http.HostPortHttpField;
import wiremock.org.eclipse.jetty.http.HttpField;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.HttpMethod;
import wiremock.org.eclipse.jetty.http.HttpScheme;
import wiremock.org.eclipse.jetty.http.HttpVersion;
import wiremock.org.eclipse.jetty.http.MetaData;
import wiremock.org.eclipse.jetty.http2.hpack.AuthorityHttpField;
import wiremock.org.eclipse.jetty.http2.hpack.HpackException;
import wiremock.org.eclipse.jetty.http2.hpack.StaticTableHttpField;

public class MetaDataBuilder {
    private final HttpFields.Mutable _fields = HttpFields.build();
    private int _maxSize;
    private int _size;
    private Integer _status;
    private String _method;
    private HttpScheme _scheme;
    private HostPortHttpField _authority;
    private String _path;
    private String _protocol;
    private long _contentLength = -1L;
    private HpackException.StreamException _streamException;
    private boolean _request;
    private boolean _response;

    protected MetaDataBuilder(int maxHeadersSize) {
        this._maxSize = maxHeadersSize;
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public void setMaxSize(int maxSize) {
        this._maxSize = maxSize;
    }

    public int getSize() {
        return this._size;
    }

    public void emit(HttpField field) throws HpackException.SessionException {
        HttpHeader header = field.getHeader();
        String name = field.getName();
        if (name == null || name.length() == 0) {
            throw new HpackException.SessionException("Header size 0", new Object[0]);
        }
        String value = field.getValue();
        int fieldSize = name.length() + (value == null ? 0 : value.length());
        this._size += fieldSize + 32;
        int maxSize = this.getMaxSize();
        if (maxSize > 0 && this._size > maxSize) {
            throw new HpackException.SessionException("Header size %d > %d", this._size, maxSize);
        }
        if (field instanceof StaticTableHttpField) {
            StaticTableHttpField staticField = (StaticTableHttpField)field;
            switch (header) {
                case C_STATUS: {
                    if (this.checkPseudoHeader(header, this._status)) {
                        this._status = staticField.getIntValue();
                    }
                    this._response = true;
                    break;
                }
                case C_METHOD: {
                    if (this.checkPseudoHeader(header, this._method)) {
                        this._method = value;
                    }
                    this._request = true;
                    break;
                }
                case C_SCHEME: {
                    if (this.checkPseudoHeader(header, (Object)this._scheme)) {
                        this._scheme = (HttpScheme)((Object)staticField.getStaticValue());
                    }
                    this._request = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(name);
                }
            }
        } else if (header != null) {
            switch (header) {
                case C_STATUS: {
                    if (this.checkPseudoHeader(header, this._status)) {
                        this._status = field.getIntValue();
                    }
                    this._response = true;
                    break;
                }
                case C_METHOD: {
                    if (this.checkPseudoHeader(header, this._method)) {
                        this._method = value;
                    }
                    this._request = true;
                    break;
                }
                case C_SCHEME: {
                    if (this.checkPseudoHeader(header, (Object)this._scheme) && value != null) {
                        this._scheme = HttpScheme.CACHE.get(value);
                    }
                    this._request = true;
                    break;
                }
                case C_AUTHORITY: {
                    if (this.checkPseudoHeader(header, this._authority)) {
                        if (field instanceof HostPortHttpField) {
                            this._authority = (HostPortHttpField)field;
                        } else if (value != null) {
                            this._authority = new AuthorityHttpField(value);
                        }
                    }
                    this._request = true;
                    break;
                }
                case C_PATH: {
                    if (this.checkPseudoHeader(header, this._path)) {
                        if (value != null && value.length() > 0) {
                            this._path = value;
                        } else {
                            this.streamException("No Path", new Object[0]);
                        }
                    }
                    this._request = true;
                    break;
                }
                case C_PROTOCOL: {
                    if (this.checkPseudoHeader(header, this._protocol)) {
                        this._protocol = value;
                    }
                    this._request = true;
                    break;
                }
                case HOST: {
                    this._fields.add(field);
                    break;
                }
                case CONTENT_LENGTH: {
                    this._contentLength = field.getLongValue();
                    this._fields.add(field);
                    break;
                }
                case TE: {
                    if ("trailers".equalsIgnoreCase(value)) {
                        this._fields.add(field);
                        break;
                    }
                    this.streamException("Unsupported TE value '%s'", value);
                    break;
                }
                case CONNECTION: {
                    if ("TE".equalsIgnoreCase(value)) {
                        this._fields.add(field);
                        break;
                    }
                    this.streamException("Connection specific field '%s'", new Object[]{header});
                    break;
                }
                default: {
                    if (name.charAt(0) == ':') {
                        this.streamException("Unknown pseudo header '%s'", name);
                        break;
                    }
                    this._fields.add(field);
                    break;
                }
            }
        } else if (name.charAt(0) == ':') {
            this.streamException("Unknown pseudo header '%s'", name);
        } else {
            this._fields.add(field);
        }
    }

    public void streamException(String messageFormat, Object ... args) {
        HpackException.StreamException stream = new HpackException.StreamException(messageFormat, args);
        if (this._streamException == null) {
            this._streamException = stream;
        } else {
            this._streamException.addSuppressed(stream);
        }
    }

    protected boolean checkPseudoHeader(HttpHeader header, Object value) {
        if (this._fields.size() > 0) {
            this.streamException("Pseudo header %s after fields", header.asString());
            return false;
        }
        if (value == null) {
            return true;
        }
        this.streamException("Duplicate pseudo header %s", header.asString());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaData build() throws HpackException.StreamException {
        if (this._streamException != null) {
            this._streamException.addSuppressed(new Throwable());
            throw this._streamException;
        }
        if (this._request && this._response) {
            throw new HpackException.StreamException("Request and Response headers", new Object[0]);
        }
        HttpFields.Mutable fields = this._fields;
        try {
            if (this._request) {
                if (this._method == null) {
                    throw new HpackException.StreamException("No Method", new Object[0]);
                }
                boolean isConnect = HttpMethod.CONNECT.is(this._method);
                if (!isConnect || this._protocol != null) {
                    if (this._scheme == null) {
                        throw new HpackException.StreamException("No Scheme", new Object[0]);
                    }
                    if (this._path == null) {
                        throw new HpackException.StreamException("No Path", new Object[0]);
                    }
                }
                if (isConnect) {
                    MetaData.ConnectRequest connectRequest = new MetaData.ConnectRequest(this._scheme, this._authority, this._path, (HttpFields)fields, this._protocol);
                    return connectRequest;
                }
                MetaData.Request request = new MetaData.Request(this._method, this._scheme == null ? HttpScheme.HTTP.asString() : this._scheme.asString(), this._authority, this._path, HttpVersion.HTTP_2, fields, this._contentLength);
                return request;
            }
            if (this._response) {
                if (this._status == null) {
                    throw new HpackException.StreamException("No Status", new Object[0]);
                }
                MetaData.Response response = new MetaData.Response(HttpVersion.HTTP_2, this._status, fields, this._contentLength);
                return response;
            }
            MetaData metaData = new MetaData(HttpVersion.HTTP_2, fields, this._contentLength);
            return metaData;
        }
        finally {
            this._fields.clear();
            this._request = false;
            this._response = false;
            this._status = null;
            this._method = null;
            this._scheme = null;
            this._authority = null;
            this._path = null;
            this._protocol = null;
            this._size = 0;
            this._contentLength = -1L;
        }
    }
}

