/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import wiremock.com.networknt.schema.InvalidSchemaException;
import wiremock.com.networknt.schema.Keyword;
import wiremock.com.networknt.schema.KeywordFactory;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class DisallowUnknownKeywordFactory
implements KeywordFactory {
    private static final Logger logger = LoggerFactory.getLogger(DisallowUnknownKeywordFactory.class);

    @Override
    public Keyword getKeyword(String value, ValidationContext validationContext) {
        logger.error("Keyword '{}' is unknown and must be configured on the meta-schema or vocabulary", (Object)value);
        throw new InvalidSchemaException(((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().message("Keyword ''{1}'' is unknown and must be configured on the meta-schema or vocabulary")).arguments(value)).build());
    }

    public static DisallowUnknownKeywordFactory getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final DisallowUnknownKeywordFactory INSTANCE = new DisallowUnknownKeywordFactory();

        private Holder() {
        }
    }
}

