/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import wiremock.org.apache.hc.core5.concurrent.CallbackContribution;
import wiremock.org.apache.hc.core5.concurrent.FutureCallback;
import wiremock.org.apache.hc.core5.function.Decorator;
import wiremock.org.apache.hc.core5.io.CloseMode;
import wiremock.org.apache.hc.core5.net.NamedEndpoint;
import wiremock.org.apache.hc.core5.reactor.Command;
import wiremock.org.apache.hc.core5.reactor.IOEventHandler;
import wiremock.org.apache.hc.core5.reactor.IOSession;
import wiremock.org.apache.hc.core5.reactor.IOSessionListener;
import wiremock.org.apache.hc.core5.reactor.InternalChannel;
import wiremock.org.apache.hc.core5.reactor.ProtocolIOSession;
import wiremock.org.apache.hc.core5.reactor.ProtocolUpgradeHandler;
import wiremock.org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import wiremock.org.apache.hc.core5.reactor.ssl.SSLIOSession;
import wiremock.org.apache.hc.core5.reactor.ssl.SSLMode;
import wiremock.org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import wiremock.org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import wiremock.org.apache.hc.core5.reactor.ssl.TlsDetails;
import wiremock.org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import wiremock.org.apache.hc.core5.util.Args;
import wiremock.org.apache.hc.core5.util.Asserts;
import wiremock.org.apache.hc.core5.util.TextUtils;
import wiremock.org.apache.hc.core5.util.Timeout;

final class InternalDataChannel
extends InternalChannel
implements ProtocolIOSession {
    private final IOSession ioSession;
    private final NamedEndpoint initialEndpoint;
    private final Decorator<IOSession> ioSessionDecorator;
    private final IOSessionListener sessionListener;
    private final Queue<InternalDataChannel> closedSessions;
    private final AtomicReference<SSLIOSession> tlsSessionRef;
    private final AtomicReference<IOSession> currentSessionRef;
    private final AtomicReference<IOEventHandler> eventHandlerRef;
    private final ConcurrentMap<String, ProtocolUpgradeHandler> protocolUpgradeHandlerMap;
    private final AtomicBoolean closed;

    InternalDataChannel(IOSession ioSession, NamedEndpoint initialEndpoint, Decorator<IOSession> ioSessionDecorator, IOSessionListener sessionListener, Queue<InternalDataChannel> closedSessions) {
        this.ioSession = ioSession;
        this.initialEndpoint = initialEndpoint;
        this.closedSessions = closedSessions;
        this.ioSessionDecorator = ioSessionDecorator;
        this.sessionListener = sessionListener;
        this.tlsSessionRef = new AtomicReference();
        this.currentSessionRef = new AtomicReference<IOSession>(ioSessionDecorator != null ? ioSessionDecorator.decorate(ioSession) : ioSession);
        this.eventHandlerRef = new AtomicReference();
        this.protocolUpgradeHandlerMap = new ConcurrentHashMap<String, ProtocolUpgradeHandler>();
        this.closed = new AtomicBoolean();
    }

    @Override
    public String getId() {
        return this.ioSession.getId();
    }

    @Override
    public NamedEndpoint getInitialEndpoint() {
        return this.initialEndpoint;
    }

    @Override
    public IOEventHandler getHandler() {
        return this.eventHandlerRef.get();
    }

    @Override
    public void upgrade(IOEventHandler handler) {
        IOSession currentSession = this.currentSessionRef.get();
        currentSession.upgrade(handler);
        this.eventHandlerRef.set(handler);
    }

    private IOEventHandler ensureHandler(IOSession session) {
        IOEventHandler handler = session.getHandler();
        Asserts.notNull(handler, "IO event handler");
        return handler;
    }

    @Override
    void onIOEvent(int readyOps) throws IOException {
        IOEventHandler handler;
        IOSession currentSession;
        if ((readyOps & 8) != 0) {
            currentSession = this.currentSessionRef.get();
            currentSession.clearEvent(8);
            if (this.tlsSessionRef.get() == null) {
                if (this.sessionListener != null) {
                    this.sessionListener.connected(currentSession);
                }
                handler = this.ensureHandler(currentSession);
                handler.connected(currentSession);
            }
        }
        if ((readyOps & 1) != 0) {
            currentSession = this.currentSessionRef.get();
            currentSession.updateReadTime();
            if (this.sessionListener != null) {
                this.sessionListener.inputReady(currentSession);
            }
            handler = this.ensureHandler(currentSession);
            handler.inputReady(currentSession, null);
        }
        if ((readyOps & 4) != 0 || (this.ioSession.getEventMask() & 4) != 0) {
            currentSession = this.currentSessionRef.get();
            currentSession.updateWriteTime();
            if (this.sessionListener != null) {
                this.sessionListener.outputReady(currentSession);
            }
            handler = this.ensureHandler(currentSession);
            handler.outputReady(currentSession);
        }
    }

    @Override
    Timeout getTimeout() {
        IOSession currentSession = this.currentSessionRef.get();
        return currentSession.getSocketTimeout();
    }

    @Override
    void onTimeout(Timeout timeout) throws IOException {
        IOSession currentSession = this.currentSessionRef.get();
        if (this.sessionListener != null) {
            this.sessionListener.timeout(currentSession);
        }
        IOEventHandler handler = this.ensureHandler(currentSession);
        handler.timeout(currentSession, timeout);
    }

    @Override
    void onException(Exception cause) {
        IOEventHandler handler;
        IOSession currentSession = this.currentSessionRef.get();
        if (this.sessionListener != null) {
            this.sessionListener.exception(currentSession, cause);
        }
        if ((handler = currentSession.getHandler()) != null) {
            handler.exception(currentSession, cause);
        }
    }

    void onTLSSessionStart(SSLIOSession sslSession) {
        IOSession currentSession = this.currentSessionRef.get();
        if (this.sessionListener != null) {
            this.sessionListener.connected(currentSession);
        }
    }

    void onTLSSessionEnd(SSLIOSession sslSession) {
        if (this.closed.compareAndSet(false, true)) {
            this.closedSessions.add(this);
        }
    }

    void disconnected() {
        IOEventHandler handler;
        IOSession currentSession = this.currentSessionRef.get();
        if (this.sessionListener != null) {
            this.sessionListener.disconnected(currentSession);
        }
        if ((handler = currentSession.getHandler()) != null) {
            handler.disconnected(currentSession);
        }
    }

    @Override
    public void startTls(SSLContext sslContext, NamedEndpoint endpoint, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier, Timeout handshakeTimeout) {
        this.startTls(sslContext, endpoint, sslBufferMode, initializer, verifier, handshakeTimeout, null);
    }

    @Override
    public void startTls(SSLContext sslContext, NamedEndpoint endpoint, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier, Timeout handshakeTimeout, final FutureCallback<TransportSecurityLayer> callback) {
        SSLIOSession sslioSession = new SSLIOSession(endpoint != null ? endpoint : this.initialEndpoint, this.ioSession, this.initialEndpoint != null ? SSLMode.CLIENT : SSLMode.SERVER, sslContext, sslBufferMode, initializer, verifier, handshakeTimeout, this::onTLSSessionStart, this::onTLSSessionEnd, (FutureCallback<SSLSession>)new CallbackContribution<SSLSession>(callback){

            @Override
            public void completed(SSLSession sslSession) {
                if (callback != null) {
                    callback.completed(InternalDataChannel.this);
                }
            }
        });
        if (!this.tlsSessionRef.compareAndSet(null, sslioSession)) {
            throw new IllegalStateException("TLS already activated");
        }
        this.currentSessionRef.set(this.ioSessionDecorator != null ? this.ioSessionDecorator.decorate(sslioSession) : sslioSession);
        try {
            if (this.sessionListener != null) {
                this.sessionListener.startTls(sslioSession);
            }
            sslioSession.beginHandshake(this);
        }
        catch (Exception ex) {
            this.onException(ex);
        }
    }

    @Override
    public TlsDetails getTlsDetails() {
        SSLIOSession sslIoSession = this.tlsSessionRef.get();
        return sslIoSession != null ? sslIoSession.getTlsDetails() : null;
    }

    @Override
    public Lock getLock() {
        return this.ioSession.getLock();
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    @Override
    public void close(CloseMode closeMode) {
        IOSession currentSession = this.currentSessionRef.get();
        if (closeMode == CloseMode.IMMEDIATE) {
            this.closed.set(true);
            currentSession.close(closeMode);
        } else if (this.closed.compareAndSet(false, true)) {
            try {
                currentSession.close(closeMode);
            }
            finally {
                this.closedSessions.add(this);
            }
        }
    }

    @Override
    public IOSession.Status getStatus() {
        IOSession currentSession = this.currentSessionRef.get();
        return currentSession.getStatus();
    }

    @Override
    public boolean isOpen() {
        IOSession currentSession = this.currentSessionRef.get();
        return currentSession.isOpen();
    }

    @Override
    public void enqueue(Command command, Command.Priority priority) {
        IOSession currentSession = this.currentSessionRef.get();
        currentSession.enqueue(command, priority);
    }

    @Override
    public boolean hasCommands() {
        IOSession currentSession = this.currentSessionRef.get();
        return currentSession.hasCommands();
    }

    @Override
    public Command poll() {
        IOSession currentSession = this.currentSessionRef.get();
        return currentSession.poll();
    }

    @Override
    public ByteChannel channel() {
        IOSession currentSession = this.currentSessionRef.get();
        return currentSession.channel();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public int getEventMask() {
        IOSession currentSession = this.currentSessionRef.get();
        return currentSession.getEventMask();
    }

    @Override
    public void setEventMask(int ops) {
        IOSession currentSession = this.currentSessionRef.get();
        currentSession.setEventMask(ops);
    }

    @Override
    public void setEvent(int op) {
        IOSession currentSession = this.currentSessionRef.get();
        currentSession.setEvent(op);
    }

    @Override
    public void clearEvent(int op) {
        IOSession currentSession = this.currentSessionRef.get();
        currentSession.clearEvent(op);
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        IOSession currentSession = this.currentSessionRef.get();
        return currentSession.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        IOSession currentSession = this.currentSessionRef.get();
        return currentSession.write(src);
    }

    @Override
    public void updateReadTime() {
        this.ioSession.updateReadTime();
    }

    @Override
    public void updateWriteTime() {
        this.ioSession.updateWriteTime();
    }

    @Override
    public long getLastReadTime() {
        return this.ioSession.getLastReadTime();
    }

    @Override
    public long getLastWriteTime() {
        return this.ioSession.getLastWriteTime();
    }

    @Override
    public long getLastEventTime() {
        return this.ioSession.getLastEventTime();
    }

    @Override
    public void switchProtocol(String protocolId, FutureCallback<ProtocolIOSession> callback) {
        Args.notEmpty(protocolId, "Application protocol ID");
        ProtocolUpgradeHandler upgradeHandler = (ProtocolUpgradeHandler)this.protocolUpgradeHandlerMap.get(TextUtils.toLowerCase(protocolId));
        if (upgradeHandler == null) {
            throw new IllegalStateException("Unsupported protocol: " + protocolId);
        }
        upgradeHandler.upgrade(this, callback);
    }

    @Override
    public void registerProtocol(String protocolId, ProtocolUpgradeHandler upgradeHandler) {
        Args.notEmpty(protocolId, "Application protocol ID");
        Args.notNull(upgradeHandler, "Protocol upgrade handler");
        this.protocolUpgradeHandlerMap.put(TextUtils.toLowerCase(protocolId), upgradeHandler);
    }

    public String toString() {
        IOSession currentSession = this.currentSessionRef.get();
        return Objects.toString(currentSession != null ? currentSession : this.ioSession, null);
    }
}

