/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Stack;
import wiremock.com.networknt.schema.CollectorContext;
import wiremock.com.networknt.schema.DiscriminatorContext;
import wiremock.com.networknt.schema.ExecutionConfig;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.ValidatorState;
import wiremock.com.networknt.schema.annotation.JsonNodeAnnotations;
import wiremock.com.networknt.schema.result.JsonNodeResults;

public class ExecutionContext {
    private ExecutionConfig executionConfig;
    private CollectorContext collectorContext;
    private ValidatorState validatorState = null;
    private Stack<DiscriminatorContext> discriminatorContexts = new Stack();
    private JsonNodeAnnotations annotations = new JsonNodeAnnotations();
    private JsonNodeResults results = new JsonNodeResults();
    private Boolean failFast = null;

    public ExecutionContext() {
        this(new CollectorContext());
    }

    public ExecutionContext(CollectorContext collectorContext) {
        this(new ExecutionConfig(), collectorContext);
    }

    public ExecutionContext(ExecutionConfig executionConfig) {
        this(executionConfig, new CollectorContext());
    }

    public ExecutionContext(ExecutionConfig executionConfig, CollectorContext collectorContext) {
        this.collectorContext = collectorContext;
        this.executionConfig = executionConfig;
    }

    public CollectorContext getCollectorContext() {
        return this.collectorContext;
    }

    public void setCollectorContext(CollectorContext collectorContext) {
        this.collectorContext = collectorContext;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public void setExecutionConfig(ExecutionConfig executionConfig) {
        this.executionConfig = executionConfig;
    }

    public JsonNodeAnnotations getAnnotations() {
        return this.annotations;
    }

    public JsonNodeResults getResults() {
        return this.results;
    }

    public boolean isFailFast() {
        if (this.failFast == null) {
            this.failFast = this.getExecutionConfig().isFailFast();
        }
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public ValidatorState getValidatorState() {
        return this.validatorState;
    }

    public void setValidatorState(ValidatorState validatorState) {
        this.validatorState = validatorState;
    }

    public DiscriminatorContext getCurrentDiscriminatorContext() {
        if (!this.discriminatorContexts.empty()) {
            return this.discriminatorContexts.peek();
        }
        return null;
    }

    public void enterDiscriminatorContext(DiscriminatorContext ctx, JsonNodePath instanceLocation) {
        this.discriminatorContexts.push(ctx);
    }

    public void leaveDiscriminatorContextImmediately(JsonNodePath instanceLocation) {
        this.discriminatorContexts.pop();
    }
}

