/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.JsonNodeType;
import wiremock.com.fasterxml.jackson.databind.node.ObjectNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorState;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.annotation.JsonNodeAnnotation;
import wiremock.com.networknt.schema.walk.WalkListenerRunner;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class PropertiesValidator
extends BaseJsonValidator {
    public static final String PROPERTY = "properties";
    private static final Logger logger = LoggerFactory.getLogger(PropertiesValidator.class);
    private final Map<String, JsonSchema> schemas = new LinkedHashMap<String, JsonSchema>();
    private Boolean hasUnevaluatedPropertiesValidator;

    public PropertiesValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.PROPERTIES, validationContext);
        Iterator<String> it = schemaNode.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            this.schemas.put(pname, validationContext.newSchema(schemaLocation.append(pname), evaluationPath.append(pname), schemaNode.get(pname), parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        PropertiesValidator.debug(logger, node, rootNode, instanceLocation);
        LinkedHashSet<ValidationMessage> errors = null;
        ValidatorState state = executionContext.getValidatorState();
        Set<ValidationMessage> requiredErrors = null;
        LinkedHashSet<String> matchedInstancePropertyNames = null;
        boolean collectAnnotations = this.collectAnnotations() || this.collectAnnotations(executionContext);
        for (Map.Entry<String, JsonSchema> entry : this.schemas.entrySet()) {
            JsonSchema propertySchema = entry.getValue();
            JsonNode propertyNode = node.get(entry.getKey());
            if (propertyNode != null) {
                JsonNodePath path = instanceLocation.append(entry.getKey());
                if (collectAnnotations) {
                    if (matchedInstancePropertyNames == null) {
                        matchedInstancePropertyNames = new LinkedHashSet<String>();
                    }
                    matchedInstancePropertyNames.add(entry.getKey());
                }
                boolean isComplex = state.isComplexValidator();
                if (state.isComplexValidator()) {
                    state.setMatchedNode(true);
                }
                state.setComplexValidator(false);
                if (!state.isWalkEnabled()) {
                    Set<ValidationMessage> result = propertySchema.validate(executionContext, propertyNode, rootNode, path);
                    if (!result.isEmpty()) {
                        if (errors == null) {
                            errors = new LinkedHashSet();
                        }
                        errors.addAll(result);
                    }
                } else {
                    if (errors == null) {
                        errors = new LinkedHashSet<ValidationMessage>();
                    }
                    this.walkSchema(executionContext, entry, node, rootNode, instanceLocation, state.isValidationEnabled(), errors, this.validationContext.getConfig().getPropertyWalkListenerRunner());
                }
                state.setComplexValidator(isComplex);
                if (!state.isComplexValidator()) continue;
                state.setMatchedNode(true);
                continue;
            }
            if (!this.getParentSchema().hasRequiredValidator() || requiredErrors != null || (requiredErrors = this.getParentSchema().getRequiredValidator().validate(executionContext, node, rootNode, instanceLocation)).isEmpty()) continue;
            if (state.isComplexValidator()) {
                state.setMatchedNode(false);
                return Collections.emptySet();
            }
            if (errors == null) {
                errors = new LinkedHashSet();
            }
            errors.addAll(requiredErrors);
        }
        if (collectAnnotations) {
            executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(matchedInstancePropertyNames == null ? Collections.emptySet() : matchedInstancePropertyNames).build());
        }
        return errors == null || errors.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(errors);
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (this.validationContext.getConfig().getApplyDefaultsStrategy().shouldApplyPropertyDefaults() && null != node && node.getNodeType() == JsonNodeType.OBJECT) {
            this.applyPropertyDefaults((ObjectNode)node);
        }
        if (shouldValidateSchema) {
            validationMessages.addAll(this.validate(executionContext, node, rootNode, instanceLocation));
        } else {
            WalkListenerRunner propertyWalkListenerRunner = this.validationContext.getConfig().getPropertyWalkListenerRunner();
            for (Map.Entry<String, JsonSchema> entry : this.schemas.entrySet()) {
                this.walkSchema(executionContext, entry, node, rootNode, instanceLocation, shouldValidateSchema, validationMessages, propertyWalkListenerRunner);
            }
        }
        return validationMessages;
    }

    private boolean collectAnnotations() {
        return this.hasUnevaluatedPropertiesValidator();
    }

    private boolean hasUnevaluatedPropertiesValidator() {
        if (this.hasUnevaluatedPropertiesValidator == null) {
            this.hasUnevaluatedPropertiesValidator = this.hasAdjacentKeywordInEvaluationPath("unevaluatedProperties");
        }
        return this.hasUnevaluatedPropertiesValidator;
    }

    private void applyPropertyDefaults(ObjectNode node) {
        for (Map.Entry<String, JsonSchema> entry : this.schemas.entrySet()) {
            boolean applyDefault;
            JsonNode propertyNode = node.get(entry.getKey());
            JsonNode defaultNode = PropertiesValidator.getDefaultNode(entry);
            if (defaultNode == null || !(applyDefault = propertyNode == null || propertyNode.isNull() && this.validationContext.getConfig().getApplyDefaultsStrategy().shouldApplyPropertyDefaultsIfNull())) continue;
            node.set(entry.getKey(), defaultNode);
        }
    }

    private static JsonNode getDefaultNode(Map.Entry<String, JsonSchema> entry) {
        JsonSchema propertySchema = entry.getValue();
        return propertySchema.getSchemaNode().get("default");
    }

    private void walkSchema(ExecutionContext executionContext, Map.Entry<String, JsonSchema> entry, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema, Set<ValidationMessage> validationMessages, WalkListenerRunner propertyWalkListenerRunner) {
        JsonSchema propertySchema = entry.getValue();
        JsonNode propertyNode = node == null ? null : node.get(entry.getKey());
        JsonNodePath path = instanceLocation.append(entry.getKey());
        boolean executeWalk = propertyWalkListenerRunner.runPreWalkListeners(executionContext, ValidatorTypeCode.PROPERTIES.getValue(), propertyNode, rootNode, path, propertySchema.getEvaluationPath(), propertySchema.getSchemaLocation(), propertySchema.getSchemaNode(), propertySchema.getParentSchema(), this.validationContext, this.validationContext.getJsonSchemaFactory());
        if (executeWalk) {
            validationMessages.addAll(propertySchema.walk(executionContext, propertyNode, rootNode, path, shouldValidateSchema));
        }
        propertyWalkListenerRunner.runPostWalkListeners(executionContext, ValidatorTypeCode.PROPERTIES.getValue(), propertyNode, rootNode, path, propertySchema.getEvaluationPath(), propertySchema.getSchemaLocation(), propertySchema.getSchemaNode(), propertySchema.getParentSchema(), this.validationContext, this.validationContext.getJsonSchemaFactory(), validationMessages);
    }

    public Map<String, JsonSchema> getSchemas() {
        return this.schemas;
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas.values());
        this.collectAnnotations();
    }
}

