/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store;

import java.util.Objects;
import org.wiremock.annotations.Beta;

@Beta(justification="Externalized State API: https://github.com/wiremock/wiremock/issues/2144")
public class StoreEvent<K, V> {
    private final K key;
    private final V oldValue;
    private final V newValue;

    public static <K, V> StoreEvent<K, V> set(K key, V previousValue, V newValue) {
        return new StoreEvent<K, V>(key, previousValue, newValue);
    }

    public static <K, V> StoreEvent<K, V> remove(K key, V previousValue) {
        return new StoreEvent<K, Object>(key, previousValue, null);
    }

    public StoreEvent(K key, V oldValue, V newValue) {
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public K getKey() {
        return this.key;
    }

    public V getOldValue() {
        return this.oldValue;
    }

    public V getNewValue() {
        return this.newValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreEvent that = (StoreEvent)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.oldValue, that.oldValue) && Objects.equals(this.newValue, that.newValue);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.oldValue, this.newValue);
    }

    public String toString() {
        return "StoreEvent{key=" + this.key + ", oldValue=" + this.oldValue + ", newValue=" + this.newValue + "}";
    }
}

