/*
 * Decompiled with CFR 0.152.
 */
package org.wololo.jts2geojson;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.PrecisionModel;
import org.wololo.geojson.GeoJSON;
import org.wololo.geojson.GeoJSONFactory;
import org.wololo.geojson.LineString;
import org.wololo.geojson.MultiLineString;
import org.wololo.geojson.MultiPoint;
import org.wololo.geojson.MultiPolygon;
import org.wololo.geojson.Point;
import org.wololo.geojson.Polygon;

public class GeoJSONReader {
    static final GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING));

    public Geometry read(String json) {
        GeoJSON geoJSON = GeoJSONFactory.create(json);
        return this.read(geoJSON);
    }

    public Geometry read(GeoJSON geoJSON) {
        if (geoJSON instanceof Point) {
            return this.convert((Point)geoJSON);
        }
        if (geoJSON instanceof LineString) {
            return this.convert((LineString)geoJSON);
        }
        if (geoJSON instanceof Polygon) {
            return this.convert((Polygon)geoJSON);
        }
        if (geoJSON instanceof MultiPoint) {
            return this.convert((MultiPoint)geoJSON);
        }
        if (geoJSON instanceof MultiLineString) {
            return this.convert((MultiLineString)geoJSON);
        }
        if (geoJSON instanceof MultiPolygon) {
            return this.convert((MultiPolygon)geoJSON);
        }
        throw new UnsupportedOperationException();
    }

    Geometry convert(Point point) {
        return factory.createPoint(this.convert(point.getCoordinates()));
    }

    Geometry convert(MultiPoint multiPoint) {
        return factory.createMultiPoint(this.convert(multiPoint.getCoordinates()));
    }

    Geometry convert(LineString lineString) {
        return factory.createLineString(this.convert(lineString.getCoordinates()));
    }

    Geometry convert(MultiLineString multiLineString) {
        int size = multiLineString.getCoordinates().length;
        com.vividsolutions.jts.geom.LineString[] lineStrings = new com.vividsolutions.jts.geom.LineString[size];
        int i = 0;
        while (i < size) {
            lineStrings[i] = factory.createLineString(this.convert(multiLineString.getCoordinates()[i]));
            ++i;
        }
        return factory.createMultiLineString(lineStrings);
    }

    Geometry convert(Polygon polygon) {
        return this.convertToPolygon(polygon.getCoordinates());
    }

    com.vividsolutions.jts.geom.Polygon convertToPolygon(double[][][] coordinates) {
        LinearRing shell = factory.createLinearRing(this.convert(coordinates[0]));
        if (coordinates.length > 1) {
            int size = coordinates.length - 1;
            LinearRing[] holes = new LinearRing[size];
            int i = 0;
            while (i < size) {
                holes[i] = factory.createLinearRing(this.convert(coordinates[i + 1]));
                ++i;
            }
            return factory.createPolygon(shell, holes);
        }
        return factory.createPolygon(shell);
    }

    Geometry convert(MultiPolygon multiPolygon) {
        int size = multiPolygon.getCoordinates().length;
        com.vividsolutions.jts.geom.Polygon[] polygons = new com.vividsolutions.jts.geom.Polygon[size];
        int i = 0;
        while (i < size) {
            polygons[i] = this.convertToPolygon(multiPolygon.getCoordinates()[i]);
            ++i;
        }
        return factory.createMultiPolygon(polygons);
    }

    Coordinate convert(double[] c) {
        return new Coordinate(c[0], c[1]);
    }

    Coordinate[] convert(double[][] ca) {
        Coordinate[] coordinates = new Coordinate[ca.length];
        int i = 0;
        while (i < ca.length) {
            coordinates[i] = this.convert(ca[i]);
            ++i;
        }
        return coordinates;
    }
}

