/*
 * Decompiled with CFR 0.152.
 */
package org.wololo.jts2geojson;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import java.util.List;
import org.wololo.geojson.Feature;
import org.wololo.geojson.FeatureCollection;
import org.wololo.geojson.Geometry;
import org.wololo.geojson.LineString;
import org.wololo.geojson.MultiLineString;
import org.wololo.geojson.Polygon;
import org.wololo.jts2geojson.GeoJSONReader;

public class GeoJSONWriter {
    static final GeoJSONReader reader = new GeoJSONReader();

    public Geometry write(com.vividsolutions.jts.geom.Geometry geometry) {
        Class<?> c = geometry.getClass();
        if (c.equals(Point.class)) {
            return this.convert((Point)geometry);
        }
        if (c.equals(com.vividsolutions.jts.geom.LineString.class)) {
            return this.convert((com.vividsolutions.jts.geom.LineString)geometry);
        }
        if (c.equals(com.vividsolutions.jts.geom.Polygon.class)) {
            return this.convert((com.vividsolutions.jts.geom.Polygon)geometry);
        }
        if (c.equals(MultiPoint.class)) {
            return this.convert((MultiPoint)geometry);
        }
        if (c.equals(com.vividsolutions.jts.geom.MultiLineString.class)) {
            return this.convert((com.vividsolutions.jts.geom.MultiLineString)geometry);
        }
        if (c.equals(MultiPolygon.class)) {
            return this.convert((MultiPolygon)geometry);
        }
        throw new UnsupportedOperationException();
    }

    public FeatureCollection write(List<Feature> features) {
        int size = features.size();
        Feature[] featuresJson = new Feature[size];
        int i = 0;
        while (i < size) {
            featuresJson[i] = features.get(i);
            ++i;
        }
        return new FeatureCollection(featuresJson);
    }

    org.wololo.geojson.Point convert(Point point) {
        org.wololo.geojson.Point json = new org.wololo.geojson.Point(this.convert(point.getCoordinate()));
        return json;
    }

    org.wololo.geojson.MultiPoint convert(MultiPoint multiPoint) {
        return new org.wololo.geojson.MultiPoint(this.convert(multiPoint.getCoordinates()));
    }

    LineString convert(com.vividsolutions.jts.geom.LineString lineString) {
        return new LineString(this.convert(lineString.getCoordinates()));
    }

    MultiLineString convert(com.vividsolutions.jts.geom.MultiLineString multiLineString) {
        int size = multiLineString.getNumGeometries();
        double[][][] lineStrings = new double[size][][];
        int i = 0;
        while (i < size) {
            lineStrings[i] = this.convert(multiLineString.getGeometryN(i).getCoordinates());
            ++i;
        }
        return new MultiLineString(lineStrings);
    }

    Polygon convert(com.vividsolutions.jts.geom.Polygon polygon) {
        int size = polygon.getNumInteriorRing() + 1;
        double[][][] rings = new double[size][][];
        rings[0] = this.convert(polygon.getExteriorRing().getCoordinates());
        int i = 0;
        while (i < size - 1) {
            rings[i + 1] = this.convert(polygon.getInteriorRingN(i).getCoordinates());
            ++i;
        }
        return new Polygon(rings);
    }

    org.wololo.geojson.MultiPolygon convert(MultiPolygon multiPolygon) {
        int size = multiPolygon.getNumGeometries();
        double[][][][] polygons = new double[size][][][];
        int i = 0;
        while (i < size) {
            polygons[i] = this.convert((com.vividsolutions.jts.geom.Polygon)multiPolygon.getGeometryN(i)).getCoordinates();
            ++i;
        }
        return new org.wololo.geojson.MultiPolygon(polygons);
    }

    double[] convert(Coordinate coordinate) {
        return new double[]{coordinate.x, coordinate.y};
    }

    double[][] convert(Coordinate[] coordinates) {
        double[][] array = new double[coordinates.length][];
        int i = 0;
        while (i < coordinates.length) {
            array[i] = this.convert(coordinates[i]);
            ++i;
        }
        return array;
    }
}

