/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.api.publisher;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.rest.integration.tests.api.publisher.TestUtils;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APICollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APIIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.API;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIBusinessInformation;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APICorsConfiguration;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIInfo;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIList;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.LifecycleState;

public class APIIndividualApiIT {
    private final APIIndividualApi api = new APIIndividualApi();
    private final APICollectionApi apiSetup = new APICollectionApi();
    private final TestUtils testUtils = new TestUtils();
    private String APIID = null;

    @BeforeClass
    public void beforeClass() throws ApiException {
        API body = new API();
        body.setName("Api101");
        body.setContext("api101");
        body.setVersion("1.0.0");
        body.setDescription("This is the api description");
        body.setProvider("admin");
        body.setWsdlUri("https://graphical.weather.gov/xml/SOAP_server/ndfdXMLserver.php?wsdl");
        body.setLifeCycleStatus("CREATED");
        body.setTransport((List)new ArrayList<String>(){
            {
                this.add("http");
            }
        });
        body.setCacheTimeout(Integer.valueOf(100));
        body.setPolicies((List)new ArrayList<String>(){
            {
                this.add("Unlimited");
            }
        });
        body.setVisibility(API.VisibilityEnum.PUBLIC);
        body.setTags(new ArrayList());
        body.setVisibleRoles(new ArrayList());
        body.setVisibleTenants(new ArrayList());
        body.setSequences(new ArrayList());
        body.setBusinessInformation(new APIBusinessInformation());
        body.setCorsConfiguration(new APICorsConfiguration());
        API response = this.apiSetup.apisPost(body);
        this.APIID = response.getId();
    }

    @Test(description="This testcase verifies if created APIS can be viewed through Publisher REST API.")
    public void apisApiIdGetTest() throws ApiException {
        String apiId = this.APIID;
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        try {
            API response = this.api.apisApiIdGet(apiId, ifNoneMatch, ifModifiedSince);
            Assert.assertEquals((String)response.getName(), (String)"Api101", (String)"API name mismatch");
            Assert.assertEquals((String)response.getContext(), (String)"api101", (String)"API context mismatch");
            Assert.assertEquals((String)response.getVersion(), (String)"1.0.0", (String)"API version mismatch");
            Assert.assertEquals((String)response.getId(), (String)apiId, (String)"API id mismatch");
            Assert.assertEquals((String)response.getDescription(), (String)"This is the api description", (String)"API discription mismatch");
            Assert.assertEquals((String)response.getLifeCycleStatus(), (String)"Created", (String)"API lifecycle status mismatch");
        }
        catch (ApiException apiException) {
            System.out.println(apiException.getCode());
            System.out.println(apiException.getResponseBody());
        }
    }

    @Test(description="This testcase verifies if an api can be retrieved when given an invalid api Id - Negative")
    public void apisApiIdGetTest_FailureTest() throws ApiException {
        try {
            String apiId = "InvalidApiId";
            String ifNoneMatch = null;
            String ifModifiedSince = null;
            this.api.apisApiIdGet(apiId, ifNoneMatch, ifModifiedSince);
        }
        catch (ApiException ae) {
            JsonParser parser = new JsonParser();
            JsonObject responseBody = (JsonObject)parser.parse(ae.getResponseBody());
            String errorMsg = responseBody.get("message").getAsString();
            Assert.assertEquals((String)errorMsg, (String)"API not found", (String)"Response message mismatch");
            Assert.assertEquals((int)ae.getCode(), (int)404, (String)"Response code mismatch");
        }
    }

    @Test(description="This testcase verifies if an existing API can be updated successfully. ")
    public void apisApiIdPutTest() throws ApiException {
        block2: {
            String newApiDescription = "New API Description";
            String apiId = this.APIID;
            try {
                API body = this.api.apisApiIdGet(apiId, null, null);
                body.setDescription(newApiDescription);
                String ifMatch = null;
                String ifUnmodifiedSince = null;
                API response = this.api.apisApiIdPut(apiId, body, ifMatch, ifUnmodifiedSince);
                Assert.assertEquals((String)response.getDescription(), (String)newApiDescription, (String)"description mismatch");
            }
            catch (ApiException apiException) {
                System.out.println(apiException.getCode());
                System.out.println(apiException.getResponseBody());
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Test(description="This testcase verifies if an existing API can be updated successfully.", enabled=false)
    public void apisApiIdPutTest_FailureTest_400() throws ApiException {
        String apiId = this.APIID;
        try {
            API body = this.api.apisApiIdGet(apiId, null, null);
            body.setName("Name changed");
            String ifMatch = null;
            String ifUnmodifiedSince = null;
            this.api.apisApiIdPut(apiId, body, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException apiException) {
            int responseCode = apiException.getCode();
            Assert.assertEquals((int)responseCode, (int)400, (String)"response code mismatch");
        }
    }

    @Test(description="This testcase verifies if an existing API can be updated when an invalid APIID is provided. ")
    public void apisApiIdPutTest_NF() throws ApiException {
        try {
            String newApiDescription = "New API Description";
            String apiId = "invalidID";
            API body = this.api.apisApiIdGet(this.APIID, null, null);
            body.setDescription(newApiDescription);
            String ifMatch = null;
            String ifUnmodifiedSince = null;
            this.api.apisApiIdPut(apiId, body, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException ae) {
            JsonParser parser = new JsonParser();
            JsonObject responseBody = (JsonObject)parser.parse(ae.getResponseBody());
            String errorMsg = responseBody.get("message").getAsString();
            Assert.assertEquals((String)errorMsg, (String)"API not found", (String)"Response message mismatch");
            Assert.assertEquals((int)ae.getCode(), (int)404, (String)"status code mismatch");
        }
    }

    @Test(enabled=false, description="This testcase verifies if API's swagger definition can be retrieved. ")
    public void apisApiIdSwaggerGetTest() throws ApiException {
        String apiId = this.APIID;
        String ifModifiedSince = null;
        String ifNoneMatch = null;
        this.api.apisApiIdSwaggerGet(apiId, ifNoneMatch, ifModifiedSince);
    }

    @Test(enabled=false, description="This testcase verifies if API's swagger definition can be retrieved when an invalid APIID is provided.")
    public void apisApiIdSwaggerGetTest_NF() throws ApiException {
        try {
            String apiId = "invalidId";
            String ifModifiedSince = null;
            String ifNoneMatch = null;
            this.api.apisApiIdSwaggerGet(apiId, ifNoneMatch, ifModifiedSince);
        }
        catch (ApiException ae) {
            Assert.assertEquals((int)ae.getCode(), (int)404, (String)"status code mismatch");
            JsonParser parser = new JsonParser();
            JsonObject responseBody = (JsonObject)parser.parse(ae.getResponseBody());
            String errorMsg = responseBody.get("message").getAsString();
            Assert.assertEquals((String)errorMsg, (String)"API not found", (String)"Response message mismatch");
        }
    }

    @Test(enabled=false, description="This testcase verifies if swagger definition can be updated for an existing api. ")
    public void apisApiIdSwaggerPutTest() throws ApiException {
        String apiId = this.APIID;
        String ifMatch = null;
        String endPointId = "{\\r\\n\\t\\\"swagger\\\": \\\"2.0\\\",\\r\\n\\t\\\"info\\\": {\\r\\n\\t\\t\\\"version\\\": \\\"1.0.0\\\",\\r\\n\\t\\t\\\"title\\\": \\\"TestApi\\\",\\r\\n\\t\\t\\\"contact\\\": {}\\r\\n\\t},\\r\\n\\t\\\"paths\\\": {\\r\\n\\t\\t\\\"\\/\\\": {\\r\\n\\t\\t\\t\\\"get\\\": {\\r\\n\\t\\t\\t\\t\\\"operationId\\\": \\\"get\\\",\\r\\n\\t\\t\\t\\t\\\"parameters\\\": [],\\r\\n\\t\\t\\t\\t\\\"responses\\\": {\\r\\n\\t\\t\\t\\t\\t\\\"200\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"description\\\": \\\"OK\\\"\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t},\\r\\n\\t\\t\\t\\\"head\\\": {\\r\\n\\t\\t\\t\\t\\\"operationId\\\": \\\"head\\\",\\r\\n\\t\\t\\t\\t\\\"parameters\\\": [],\\r\\n\\t\\t\\t\\t\\\"responses\\\": {\\r\\n\\t\\t\\t\\t\\t\\\"200\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"description\\\": \\\"OK\\\"\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t},\\r\\n\\t\\t\\t\\\"post\\\": {\\r\\n\\t\\t\\t\\t\\\"operationId\\\": \\\"post\\\",\\r\\n\\t\\t\\t\\t\\\"parameters\\\": [{\\r\\n\\t\\t\\t\\t\\t\\\"in\\\": \\\"body\\\",\\r\\n\\t\\t\\t\\t\\t\\\"name\\\": \\\"Payload\\\",\\r\\n\\t\\t\\t\\t\\t\\\"description\\\": \\\"Request Body\\\",\\r\\n\\t\\t\\t\\t\\t\\\"required\\\": false,\\r\\n\\t\\t\\t\\t\\t\\\"schema\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"properties\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\t\\\"payload\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\t\\t\\\"type\\\": \\\"string\\\"\\r\\n\\t\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}],\\r\\n\\t\\t\\t\\t\\\"responses\\\": {\\r\\n\\t\\t\\t\\t\\t\\\"200\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"description\\\": \\\"OK\\\"\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t},\\r\\n\\t\\t\\t\\\"put\\\": {\\r\\n\\t\\t\\t\\t\\\"operationId\\\": \\\"put\\\",\\r\\n\\t\\t\\t\\t\\\"parameters\\\": [{\\r\\n\\t\\t\\t\\t\\t\\\"in\\\": \\\"body\\\",\\r\\n\\t\\t\\t\\t\\t\\\"name\\\": \\\"Payload\\\",\\r\\n\\t\\t\\t\\t\\t\\\"description\\\": \\\"Request Body1\\\",\\r\\n\\t\\t\\t\\t\\t\\\"required\\\": false,\\r\\n\\t\\t\\t\\t\\t\\\"schema\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"properties\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\t\\\"payload\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\t\\t\\\"type\\\": \\\"string\\\"\\r\\n\\t\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}],\\r\\n\\t\\t\\t\\t\\\"responses\\\": {\\r\\n\\t\\t\\t\\t\\t\\\"200\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"description\\\": \\\"OK\\\"\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t},\\r\\n\\t\\t\\t\\\"delete\\\": {\\r\\n\\t\\t\\t\\t\\\"operationId\\\": \\\"delete\\\",\\r\\n\\t\\t\\t\\t\\\"parameters\\\": [],\\r\\n\\t\\t\\t\\t\\\"responses\\\": {\\r\\n\\t\\t\\t\\t\\t\\\"200\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"description\\\": \\\"OK\\\"\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t},\\r\\n\\t\\t\\t\\\"patch\\\": {\\r\\n\\t\\t\\t\\t\\\"operationId\\\": \\\"patch\\\",\\r\\n\\t\\t\\t\\t\\\"parameters\\\": [{\\r\\n\\t\\t\\t\\t\\t\\\"in\\\": \\\"body\\\",\\r\\n\\t\\t\\t\\t\\t\\\"name\\\": \\\"Payload\\\",\\r\\n\\t\\t\\t\\t\\t\\\"description\\\": \\\"Request Body\\\",\\r\\n\\t\\t\\t\\t\\t\\\"required\\\": false,\\r\\n\\t\\t\\t\\t\\t\\\"schema\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"properties\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\t\\\"payload\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\t\\t\\\"type\\\": \\\"string\\\"\\r\\n\\t\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}],\\r\\n\\t\\t\\t\\t\\\"responses\\\": {\\r\\n\\t\\t\\t\\t\\t\\\"200\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"description\\\": \\\"OK\\\"\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t}\\r\\n\\t\\t}\\r\\n\\t}\\r\\n}";
        String ifUnmodifiedSince = null;
        this.api.apisApiIdSwaggerPut(apiId, endPointId, ifMatch, ifUnmodifiedSince);
    }

    @Test(enabled=false, description="This testcase verifies if swagger definition can be updated for an existing api. ")
    public void apisApiIdSwaggerPutTest_FailureTest_404() throws ApiException {
        String apiId = this.APIID;
        String ifMatch = null;
        String endPointId = "{\\r\\n\\t\\\"swagger\\\": \\\"2.0\\\",\\r\\n\\t\\\"info\\\": {\\r\\n\\t\\t\\\"version\\\": \\\"1.0.0\\\",\\r\\n\\t\\t\\\"title\\\": \\\"TestApi\\\",\\r\\n\\t\\t\\\"contact\\\": {}\\r\\n\\t},\\r\\n\\t\\\"paths\\\": {\\r\\n\\t\\t\\\"\\/\\\": {\\r\\n\\t\\t\\t\\\"get\\\": {\\r\\n\\t\\t\\t\\t\\\"operationId\\\": \\\"get\\\",\\r\\n\\t\\t\\t\\t\\\"parameters\\\": [],\\r\\n\\t\\t\\t\\t\\\"responses\\\": {\\r\\n\\t\\t\\t\\t\\t\\\"200\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"description\\\": \\\"OK\\\"\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t},\\r\\n\\t\\t\\t\\\"head\\\": {\\r\\n\\t\\t\\t\\t\\\"operationId\\\": \\\"head\\\",\\r\\n\\t\\t\\t\\t\\\"parameters\\\": [],\\r\\n\\t\\t\\t\\t\\\"responses\\\": {\\r\\n\\t\\t\\t\\t\\t\\\"200\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"description\\\": \\\"OK\\\"\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t},\\r\\n\\t\\t\\t\\\"post\\\": {\\r\\n\\t\\t\\t\\t\\\"operationId\\\": \\\"post\\\",\\r\\n\\t\\t\\t\\t\\\"parameters\\\": [{\\r\\n\\t\\t\\t\\t\\t\\\"in\\\": \\\"body\\\",\\r\\n\\t\\t\\t\\t\\t\\\"name\\\": \\\"Payload\\\",\\r\\n\\t\\t\\t\\t\\t\\\"description\\\": \\\"Request Body\\\",\\r\\n\\t\\t\\t\\t\\t\\\"required\\\": false,\\r\\n\\t\\t\\t\\t\\t\\\"schema\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"properties\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\t\\\"payload\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\t\\t\\\"type\\\": \\\"string\\\"\\r\\n\\t\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}],\\r\\n\\t\\t\\t\\t\\\"responses\\\": {\\r\\n\\t\\t\\t\\t\\t\\\"200\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"description\\\": \\\"OK\\\"\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t},\\r\\n\\t\\t\\t\\\"put\\\": {\\r\\n\\t\\t\\t\\t\\\"operationId\\\": \\\"put\\\",\\r\\n\\t\\t\\t\\t\\\"parameters\\\": [{\\r\\n\\t\\t\\t\\t\\t\\\"in\\\": \\\"body\\\",\\r\\n\\t\\t\\t\\t\\t\\\"name\\\": \\\"Payload\\\",\\r\\n\\t\\t\\t\\t\\t\\\"description\\\": \\\"Request Body1\\\",\\r\\n\\t\\t\\t\\t\\t\\\"required\\\": false,\\r\\n\\t\\t\\t\\t\\t\\\"schema\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"properties\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\t\\\"payload\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\t\\t\\\"type\\\": \\\"string\\\"\\r\\n\\t\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}],\\r\\n\\t\\t\\t\\t\\\"responses\\\": {\\r\\n\\t\\t\\t\\t\\t\\\"200\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"description\\\": \\\"OK\\\"\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t},\\r\\n\\t\\t\\t\\\"delete\\\": {\\r\\n\\t\\t\\t\\t\\\"operationId\\\": \\\"delete\\\",\\r\\n\\t\\t\\t\\t\\\"parameters\\\": [],\\r\\n\\t\\t\\t\\t\\\"responses\\\": {\\r\\n\\t\\t\\t\\t\\t\\\"200\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"description\\\": \\\"OK\\\"\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t},\\r\\n\\t\\t\\t\\\"patch\\\": {\\r\\n\\t\\t\\t\\t\\\"operationId\\\": \\\"patch\\\",\\r\\n\\t\\t\\t\\t\\\"parameters\\\": [{\\r\\n\\t\\t\\t\\t\\t\\\"in\\\": \\\"body\\\",\\r\\n\\t\\t\\t\\t\\t\\\"name\\\": \\\"Payload\\\",\\r\\n\\t\\t\\t\\t\\t\\\"description\\\": \\\"Request Body\\\",\\r\\n\\t\\t\\t\\t\\t\\\"required\\\": false,\\r\\n\\t\\t\\t\\t\\t\\\"schema\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"properties\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\t\\\"payload\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\t\\t\\\"type\\\": \\\"string\\\"\\r\\n\\t\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}],\\r\\n\\t\\t\\t\\t\\\"responses\\\": {\\r\\n\\t\\t\\t\\t\\t\\\"200\\\": {\\r\\n\\t\\t\\t\\t\\t\\t\\\"description\\\": \\\"OK\\\"\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t}\\r\\n\\t\\t}\\r\\n\\t}\\r\\n}";
        String ifUnmodifiedSince = null;
        this.api.apisApiIdSwaggerPut(apiId, endPointId, ifMatch, ifUnmodifiedSince);
    }

    @Test(enabled=false, description="This testcase verifies if thumbnail image can be uploaded")
    public void apisApiIdThumbnailPostTest() throws ApiException {
        String apiId = this.APIID;
        File file = new File(this.getClass().getResource("/img1.jpg").getFile());
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        this.api.apisApiIdThumbnailPost(apiId, file, ifMatch, ifUnmodifiedSince);
    }

    @Test(enabled=false, description="This testcase verifies if thumbnail image can be uploaded for a given API")
    public void apisApiIdThumbnailGetTest() throws ApiException {
        String apiId = this.APIID;
        Object accept = null;
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        this.api.apisApiIdThumbnailGet(apiId, ifNoneMatch, ifModifiedSince);
    }

    @Test(enabled=false, description="This testcase verifies if API ID's wsdl document can be viewed. ")
    public void apisApiIdWsdlGetTest() throws ApiException {
        String apiId = this.APIID;
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        this.api.apisApiIdWsdlGet(apiId, ifNoneMatch, ifModifiedSince);
    }

    @Test(enabled=true, description="This testcase verifies if API ID's wsdl document can be viewed. ")
    public void apisApiIdWsdlGetTest_failureTest_404() throws ApiException {
        String apiId = "invalidId";
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        try {
            this.api.apisApiIdWsdlGet(apiId, ifNoneMatch, ifModifiedSince);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)404, (String)"Status code mismatch");
        }
    }

    @Test(enabled=false, description="This testcase verifies if API ID's wsdl document can be updated. ")
    public void apisApiIdWsdlPutTest() throws ApiException {
        String apiId = this.APIID;
        File file = new File(this.getClass().getResource("/Phone.wsdl").getFile());
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        this.api.apisApiIdWsdlPut(apiId, file, ifMatch, ifUnmodifiedSince);
        this.api.apisApiIdWsdlGet(apiId, null, null);
    }

    @Test(enabled=false, description="This testcase verifies if API ID's wsdl document can be updated. ")
    public void apisApiIdWsdlPutTest_failureTest_404() throws ApiException {
        String apiId = "invalidApi";
        File file = new File(this.getClass().getResource("/Phone.wsdl").getFile());
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        try {
            this.api.apisApiIdWsdlPut(apiId, file, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)404, (String)"Status code mismatch");
        }
    }

    @Test(enabled=true, description="This testcase verifies if API ID's wsdl document can be updated. ")
    public void apisApiIdWsdlPutTest_failureTest_400() throws ApiException {
        String apiId = this.APIID;
        File file = new File(this.getClass().getResource("/img1.jpg").getFile());
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        try {
            this.api.apisApiIdWsdlPut(apiId, file, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)400, (String)"Status code mismatch");
        }
    }

    @Test(enabled=true, description="This testcase verifies if a new API version can be created for a given existing API.")
    public void apisCopyApiPostTest_FailureTest_404() throws ApiException {
        String newVersion = "2.0.1";
        String apiId = "invalidId";
        try {
            this.api.apisCopyApiPost(newVersion, apiId);
            assert (false);
        }
        catch (ApiException ae) {
            int statusCode = ae.getCode();
            Assert.assertEquals((int)statusCode, (int)404, (String)"status code mismatch");
        }
    }

    @Test(enabled=false, description="This testcase verifies if a new API version can be created for a given existing API.")
    public void apisCopyApiPostTest_() throws ApiException {
        String newVersion = "2.0.1";
        String apiId = this.APIID;
        this.api.apisCopyApiPost(newVersion, apiId);
    }

    @Test(description="Verify if specific api's lifecycle state can be retrieved.")
    public void apisApiIdLifecycleGetTest() throws ApiException {
        String apiId = this.APIID;
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        LifecycleState response = this.api.apisApiIdLifecycleGet(apiId, ifNoneMatch, ifModifiedSince);
        String lifeCycleState = response.getState();
        Assert.assertEquals((String)lifeCycleState, (String)"Created", (String)"Api lifecycle state mismatch");
    }

    @Test(description="Verify if specific api's lifecycle state can be retrieved when an invalid Api Id is provided.")
    public void apisApiIdLifecycleGetTest_NF() throws ApiException {
        try {
            String apiId = "invalidId";
            String ifNoneMatch = null;
            String ifModifiedSince = null;
            this.api.apisApiIdLifecycleGet(apiId, ifNoneMatch, ifModifiedSince);
        }
        catch (ApiException ae) {
            JsonParser parser = new JsonParser();
            JsonObject responseBody = (JsonObject)parser.parse(ae.getResponseBody());
            String errorMsg = responseBody.get("message").getAsString();
            Assert.assertEquals((String)errorMsg, (String)"API not found", (String)"Response message mismatch");
            Assert.assertEquals((int)ae.getCode(), (int)404, (String)"status code mismatch");
        }
    }

    @Test(enabled=false, description="This testcase verifies if state change history of an api life cycle can be retrieved.")
    public void apisApiIdLifecycleHistoryGetTest() throws ApiException {
        String apiId = this.APIID;
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        this.api.apisApiIdLifecycleHistoryGet(apiId, ifNoneMatch, ifModifiedSince);
    }

    @Test(enabled=true, description="This testcase verifies if state change history of an api life cycle can be retrieved.")
    public void apisApiIdLifecycleHistoryGetTest_failureTest() throws ApiException {
        String apiId = "invalidApiId";
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        try {
            this.api.apisApiIdLifecycleHistoryGet(apiId, ifNoneMatch, ifModifiedSince);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)404, (String)"Status code mismatch");
        }
    }

    @Test(enabled=false)
    public void apisApiIdGatewayConfigGetTest() throws ApiException {
        String apiId = this.APIID;
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        this.api.apisApiIdGatewayConfigGet(apiId, ifNoneMatch, ifModifiedSince);
    }

    @Test
    public void apisApiIdGatewayConfigGetTest_failureTest() throws ApiException {
        String apiId = "invalidId";
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        try {
            this.api.apisApiIdGatewayConfigGet(apiId, ifNoneMatch, ifModifiedSince);
            assert (false);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)404, (String)"Status code mismatch");
        }
    }

    @Test(enabled=false)
    public void apisApiIdGatewayConfigPutTest() throws ApiException {
        String apiId = this.APIID;
        String gatewayConfig = null;
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        this.api.apisApiIdGatewayConfigPut(apiId, gatewayConfig, ifMatch, ifUnmodifiedSince);
    }

    @Test(description="This testcase verifies if change of an api life cycle can be done.")
    public void apisChangeLifecyclePostTest() throws ApiException {
        String lifecycleChecklist = null;
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        String apiId = this.testUtils.createApi("API-120", "1.0.0", "API-120");
        this.api.apisChangeLifecyclePost("Prototyped", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
        API response = this.api.apisApiIdGet(apiId, null, null);
        Assert.assertEquals((String)"Prototyped", (String)response.getLifeCycleStatus(), (String)"API status mismatch Created --> Prototyped");
        this.api.apisChangeLifecyclePost("Created", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
        response = this.api.apisApiIdGet(apiId, null, null);
        Assert.assertEquals((String)"Created", (String)response.getLifeCycleStatus(), (String)"API status mismatch Prototyped --> Created");
        this.api.apisChangeLifecyclePost("Published", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
        response = this.api.apisApiIdGet(apiId, null, null);
        Assert.assertEquals((String)"Published", (String)response.getLifeCycleStatus(), (String)"API status mismatch Created --> Published");
        this.api.apisChangeLifecyclePost("Created", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
        response = this.api.apisApiIdGet(apiId, null, null);
        Assert.assertEquals((String)"Created", (String)response.getLifeCycleStatus(), (String)"API status mismatch Published --> Created");
        this.api.apisChangeLifecyclePost("Published", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
        this.api.apisChangeLifecyclePost("Maintenance", apiId, lifecycleChecklist, null, null);
        response = this.api.apisApiIdGet(apiId, null, null);
        Assert.assertEquals((String)"Maintenance", (String)response.getLifeCycleStatus(), (String)"API status mismatch Published --> Maintenance");
        this.api.apisChangeLifecyclePost("Published", apiId, lifecycleChecklist, null, null);
        response = this.api.apisApiIdGet(apiId, null, null);
        Assert.assertEquals((String)"Published", (String)response.getLifeCycleStatus(), (String)"API status mismatch Maintenance --> Published");
        this.api.apisChangeLifecyclePost("Deprecated", apiId, lifecycleChecklist, null, null);
        response = this.api.apisApiIdGet(apiId, null, null);
        Assert.assertEquals((String)"Deprecated", (String)response.getLifeCycleStatus(), (String)"API status mismatch Published --> Deprecated");
        this.api.apisChangeLifecyclePost("Retired", apiId, null, null, null);
        response = this.api.apisApiIdGet(apiId, null, null);
        Assert.assertEquals((String)"Retired", (String)response.getLifeCycleStatus(), (String)"API status mismatch Deprecated --> Retired");
        String apiId2 = this.testUtils.createApi("API-121", "1.0.0", "API-121");
        this.api.apisChangeLifecyclePost("Published", apiId2, lifecycleChecklist, null, null);
        this.api.apisChangeLifecyclePost("Maintenance", apiId2, lifecycleChecklist, null, null);
        this.api.apisChangeLifecyclePost("Deprecated", apiId2, lifecycleChecklist, null, null);
        response = this.api.apisApiIdGet(apiId2, null, null);
        Assert.assertEquals((String)"Deprecated", (String)response.getLifeCycleStatus(), (String)"API status mismatch Maintenance --> Deprecated");
        this.testUtils.deleteApi();
    }

    @Test
    public void apisChangeLifecyclePostTest_FailureTest_404() throws ApiException {
        String lifecycleChecklist = null;
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        String apiId = "invaliApiId";
        try {
            this.api.apisChangeLifecyclePost("Prototyped", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)404, (String)"Status code mismatch");
        }
    }

    @Test(description="This testcase verifies if change of an api life cycle can be done - NF", enabled=false)
    public void apisChangeLifecyclePostTest_FailureTest_400() throws ApiException {
        String apiId;
        String ifUnmodifiedSince;
        String ifMatch;
        String lifecycleChecklist;
        try {
            lifecycleChecklist = null;
            ifMatch = null;
            ifUnmodifiedSince = null;
            apiId = this.testUtils.createApi("API-120", "1.0.0", "API-120");
            this.api.apisChangeLifecyclePost("Maintenance", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException ae) {
            Assert.assertEquals((int)ae.getCode(), (int)400, (String)"Response code mismatch. Created --> Maintenance");
            this.testUtils.deleteApi();
        }
        try {
            lifecycleChecklist = null;
            ifMatch = null;
            ifUnmodifiedSince = null;
            apiId = this.testUtils.createApi("API-120", "1.0.0", "API-120");
            this.api.apisChangeLifecyclePost("Deprecated", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException ae) {
            Assert.assertEquals((int)ae.getCode(), (int)400, (String)"Response code mismatch. Created --> Deprecated");
            this.testUtils.deleteApi();
        }
        try {
            lifecycleChecklist = null;
            ifMatch = null;
            ifUnmodifiedSince = null;
            apiId = this.testUtils.createApi("API-120", "1.0.0", "API-120");
            this.api.apisChangeLifecyclePost("Prototyped", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
            this.api.apisChangeLifecyclePost("Maintenance", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException ae) {
            Assert.assertEquals((int)ae.getCode(), (int)400, (String)"Response code mismatch. Prototyped --> Maintenance");
            this.testUtils.deleteApi();
        }
        try {
            lifecycleChecklist = null;
            ifMatch = null;
            ifUnmodifiedSince = null;
            apiId = this.testUtils.createApi("API-120", "1.0.0", "API-120");
            this.api.apisChangeLifecyclePost("Retired", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException ae) {
            Assert.assertEquals((int)ae.getCode(), (int)400, (String)"Response code mismatch. Created --> Retired");
            this.testUtils.deleteApi();
        }
        try {
            lifecycleChecklist = null;
            ifMatch = null;
            ifUnmodifiedSince = null;
            apiId = this.testUtils.createApi("API-120", "1.0.0", "API-120");
            this.api.apisChangeLifecyclePost("Published", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
            this.api.apisChangeLifecyclePost("Deprecated", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
            this.api.apisChangeLifecyclePost("Maintenance", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException ae) {
            Assert.assertEquals((int)ae.getCode(), (int)400, (String)"Response code mismatch. Deprecated --> Maintenance");
            this.testUtils.deleteApi();
        }
        try {
            lifecycleChecklist = null;
            ifMatch = null;
            ifUnmodifiedSince = null;
            apiId = this.testUtils.createApi("API-120", "1.0.0", "API-120");
            this.api.apisChangeLifecyclePost("Published", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
            this.api.apisChangeLifecyclePost("Deprecated", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
            this.api.apisChangeLifecyclePost("Retired", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
            this.api.apisChangeLifecyclePost("Deprecated", apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException ae) {
            Assert.assertEquals((int)ae.getCode(), (int)400, (String)"Response code mismatch. Retired --> Deprecated");
            this.testUtils.deleteApi();
        }
        this.testUtils.deleteApi();
    }

    @Test(description="This testcase verifies if an API can be deleted through a REST call.")
    public void apisApiIdDeleteTest() throws ApiException {
        String apiId = this.testUtils.createApi("API-118", "1.0.0", "API-118");
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        this.api.apisApiIdDelete(apiId, ifMatch, ifUnmodifiedSince);
        APIList response = this.apiSetup.apisGet(Integer.valueOf(10), Integer.valueOf(0), null, null);
        for (int i = 0; i < response.getCount(); ++i) {
            if (((APIInfo)response.getList().get(i)).getName().equals("API-118")) assert (false);
        }
    }

    @Test(enabled=false)
    public void apisLifecyclePendingTask() throws ApiException {
        String apiId = this.testUtils.createApi("API-200", "1.0.0", "API-200");
        API body = this.api.apisApiIdGet(apiId, null, null);
        body.setWorkflowStatus("PENDING");
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        API response = this.api.apisApiIdPut(apiId, body, ifMatch, ifUnmodifiedSince);
        System.out.println(response);
        this.api.apisApiIdLifecycleLifecyclePendingTaskDelete(this.APIID);
    }

    @Test
    public void apisLifecyclePendingTask_failureTest() throws ApiException {
        String apiId = "invalidApiID";
        try {
            this.api.apisApiIdLifecycleLifecyclePendingTaskDelete(apiId);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)404, (String)"status code mismatch");
        }
    }

    @Test(description="This testcase verifies if an API can be deleted when an invalid Api Id is provided.")
    public void apisApiIdDeleteTest_failureTest() throws ApiException {
        try {
            String apiId = "invaliApi";
            String ifMatch = null;
            String ifUnmodifiedSince = null;
            this.api.apisApiIdDelete(apiId, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException ae) {
            JsonParser parser = new JsonParser();
            JsonObject responseBody = (JsonObject)parser.parse(ae.getResponseBody());
            String errorMsg = responseBody.get("message").getAsString();
            Assert.assertEquals((int)ae.getCode(), (int)404, (String)"Response code mismatch.");
            Assert.assertEquals((String)errorMsg, (String)"API not found", (String)"Response message mismatch");
        }
    }

    @AfterClass
    public void afterClass() throws ApiException {
        APIList response = this.apiSetup.apisGet(Integer.valueOf(10), Integer.valueOf(0), null, null);
        for (int i = 0; i < response.getCount(); ++i) {
            this.api.apisApiIdDelete(((APIInfo)response.getList().get(i)).getId(), null, null);
        }
    }
}

