/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.api.publisher;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.rest.integration.tests.api.publisher.TestUtils;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APICollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APIIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.API;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIBusinessInformation;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APICorsConfiguration;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIInfo;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIList;

public class APICollectionApiIT {
    private final APICollectionApi api = new APICollectionApi();
    private final TestUtils testUtils = new TestUtils();
    private static String apiID;

    @Test(description="This testcase verifies if created APIS can be viewed through Publisher REST API.")
    public void apisGetTest() throws ApiException {
        block4: {
            Integer limit = 10;
            Integer offset = 0;
            String query = null;
            String ifNoneMatch = null;
            try {
                String apiId1 = this.testUtils.createApi("TestApi1", "1.0.0", "testapi1");
                String apiId2 = this.testUtils.createApi("TestApi2", "1.0.0", "testapi2");
                APIList response = this.api.apisGet(limit, offset, query, ifNoneMatch);
                if (((APIInfo)response.getList().get(0)).getName().equals("TestApi1")) {
                    Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getName(), (String)"TestApi1", (String)"API name mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getId(), (String)apiId1, (String)"API Id mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getDescription(), (String)"This is the api description", (String)"API description mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getContext(), (String)"testapi1", (String)"API context mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getVersion(), (String)"1.0.0", (String)"API version mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getLifeCycleStatus(), (String)"Created", (String)"API Lifecycle status mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(1)).getName(), (String)"TestApi2", (String)"API name mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(1)).getId(), (String)apiId2, (String)"API Id mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(1)).getDescription(), (String)"This is the api description", (String)"API description mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(1)).getContext(), (String)"testapi2", (String)"API context mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(1)).getVersion(), (String)"1.0.0", (String)"API version mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(1)).getLifeCycleStatus(), (String)"Created", (String)"API Lifecycle status mismatch");
                } else {
                    Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getName(), (String)"TestApi2", (String)"API name mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getId(), (String)apiId2, (String)"API Id mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getDescription(), (String)"This is the api description", (String)"API description mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getContext(), (String)"testapi2", (String)"API context mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getVersion(), (String)"1.0.0", (String)"API version mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getLifeCycleStatus(), (String)"Created", (String)"API Lifecycle status mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(1)).getName(), (String)"TestApi1", (String)"API name mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(1)).getId(), (String)apiId1, (String)"API Id mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(1)).getDescription(), (String)"This is the api description", (String)"API description mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(1)).getContext(), (String)"testapi1", (String)"API context mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(1)).getVersion(), (String)"1.0.0", (String)"API version mismatch");
                    Assert.assertEquals((String)((APIInfo)response.getList().get(1)).getLifeCycleStatus(), (String)"Created", (String)"API Lifecycle status mismatch");
                }
                this.testUtils.deleteApi();
            }
            catch (ApiException apiException) {
                System.out.println(apiException.getCode());
                System.out.println(apiException.getResponseBody());
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    @Test(enabled=false)
    public void apisHeadTest() throws ApiException {
        try {
            this.testUtils.createApi("API-117", "1.0.0", "API-117");
            String query_name = "name:API-117";
            String query_version = "version:1.0.0";
            String query_context = "context:API-117";
            String ifNoneMatch = null;
            this.api.apisHead(query_name, ifNoneMatch);
            this.api.apisHead(query_version, ifNoneMatch);
            this.api.apisHead(query_context, ifNoneMatch);
            this.testUtils.deleteApi();
        }
        catch (ApiException ae) {
            this.testUtils.deleteApi();
            Assert.assertEquals((int)ae.getCode(), (int)200, (String)"status code mismatch");
        }
    }

    @Test
    public void apisHead_FailureTest() throws ApiException {
        try {
            String query = "name:DoesNotExist";
            String ifNoneMatch = null;
            this.api.apisHead(query, ifNoneMatch);
        }
        catch (ApiException ae) {
            int statusCode = ae.getCode();
            Assert.assertEquals((int)statusCode, (int)404, (String)"status code mismatch");
        }
    }

    @Test(description="This testcase verifies if an API can be created successfully. ")
    public void apisPostTest() throws ApiException {
        block2: {
            try {
                API body = new API();
                body.setName("API-118");
                body.setDescription("This is the api description");
                body.setContext("API-118");
                body.setVersion("1.0.0");
                body.setProvider("admin");
                body.setLifeCycleStatus("CREATED");
                body.setTransport((List)new ArrayList<String>(){
                    {
                        this.add("http");
                    }
                });
                body.setCacheTimeout(Integer.valueOf(100));
                body.setPolicies((List)new ArrayList<String>(){
                    {
                        this.add("Unlimited");
                    }
                });
                body.setVisibility(API.VisibilityEnum.PUBLIC);
                body.setTags(new ArrayList());
                body.setVisibleRoles(new ArrayList());
                body.setVisibleTenants(new ArrayList());
                body.setSequences(new ArrayList());
                body.setBusinessInformation(new APIBusinessInformation());
                body.setCorsConfiguration(new APICorsConfiguration());
                API response = this.api.apisPost(body);
                apiID = response.getId();
                Assert.assertEquals((String)response.getName(), (String)"API-118", (String)"api name mismatch");
                Assert.assertEquals((String)response.getDescription(), (String)"This is the api description", (String)"API description mismatch");
                Assert.assertEquals((String)response.getContext(), (String)"API-118", (String)"API context mismatch");
                Assert.assertEquals((String)response.getVersion(), (String)"1.0.0", (String)"API version mismatch");
                Assert.assertEquals((String)response.getLifeCycleStatus(), (String)"Created", (String)"API Lifecycle status mismatch");
                this.testUtils.deleteApi();
            }
            catch (ApiException apiException) {
                System.out.println(apiException.getResponseBody());
                System.out.println(apiException.getCode());
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="This testcase verifies if API name can be duplicated - The same name, different context")
    public void createApi_existingName_FailureTest() throws ApiException {
        try {
            this.testUtils.createApi("TestApi1", "1.0.0", "testapi1");
            API body = new API();
            body.setName("TestApi1");
            body.setDescription("This is the api description");
            body.setContext("testapi2");
            body.setVersion("1.0.0");
            body.setProvider("admin");
            body.setLifeCycleStatus("CREATED");
            body.setTransport((List)new ArrayList<String>(){
                {
                    this.add("http");
                }
            });
            body.setCacheTimeout(Integer.valueOf(100));
            body.setPolicies((List)new ArrayList<String>(){
                {
                    this.add("Unlimited");
                }
            });
            body.setVisibility(API.VisibilityEnum.PUBLIC);
            body.setTags(new ArrayList());
            body.setVisibleRoles(new ArrayList());
            body.setVisibleTenants(new ArrayList());
            body.setSequences(new ArrayList());
            body.setBusinessInformation(new APIBusinessInformation());
            body.setCorsConfiguration(new APICorsConfiguration());
        }
        catch (ApiException ae) {
            JsonParser parser = new JsonParser();
            JsonObject responseBody = (JsonObject)parser.parse(ae.getResponseBody());
            int errorCode = ae.getCode();
            String errorMsg = responseBody.get("message").getAsString();
            Assert.assertEquals((int)errorCode, (int)409, (String)"Error code mismatch");
            Assert.assertEquals((String)errorMsg, (String)"The API already exists.", (String)"Error message mismatch");
        }
        finally {
            APIList response = this.api.apisGet(Integer.valueOf(10), Integer.valueOf(0), null, null);
            int apiCount = response.getCount();
            Assert.assertEquals((int)apiCount, (int)1, (String)"createApi_existingName() test failed");
            this.testUtils.deleteApi();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="This testcase verifies if api can be created without providing the API name.", enabled=false)
    public void apisPostTest_NF_withoutTheName_FailureTest() throws ApiException {
        API body = new API();
        try {
            body.setName("");
            body.setDescription("This is the api description");
            body.setContext("API-117");
            body.setVersion("1.0.0");
            body.setProvider("admin");
            body.setLifeCycleStatus("CREATED");
            body.setTransport((List)new ArrayList<String>(){
                {
                    this.add("http");
                }
            });
            body.setCacheTimeout(Integer.valueOf(100));
            body.setPolicies((List)new ArrayList<String>(){
                {
                    this.add("Unlimited");
                }
            });
            body.setVisibility(API.VisibilityEnum.PUBLIC);
            body.setTags(new ArrayList());
            body.setVisibleRoles(new ArrayList());
            body.setVisibleTenants(new ArrayList());
            body.setSequences(new ArrayList());
            body.setBusinessInformation(new APIBusinessInformation());
            body.setCorsConfiguration(new APICorsConfiguration());
            this.api.apisPost(body);
        }
        catch (ApiException ae) {
            JsonParser parser = new JsonParser();
            JsonObject responseBody = (JsonObject)parser.parse(ae.getResponseBody());
            String errorMsg = responseBody.get("message").getAsString();
            int errorCode = ae.getCode();
            Assert.assertEquals((int)errorCode, (int)400, (String)"response code mismatch");
            Assert.assertEquals((String)errorMsg, (String)"name may not be null", (String)"response message mismatch");
        }
        finally {
            APIList response = this.api.apisGet(Integer.valueOf(10), Integer.valueOf(0), null, null);
            int apiCount = response.getCount();
            Assert.assertEquals((int)apiCount, (int)0, (String)"createApi_existingName() test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="This testcase verifies if api can be created without providing the API version.", enabled=false)
    public void apisPostTest_withoutTheVersion_FailureTest() throws ApiException {
        API body = new API();
        try {
            body.setName("API-117");
            body.setDescription("This is the api description");
            body.setContext("API-117");
            body.setProvider("admin");
            body.setLifeCycleStatus("CREATED");
            body.setTransport((List)new ArrayList<String>(){
                {
                    this.add("http");
                }
            });
            body.setCacheTimeout(Integer.valueOf(100));
            body.setPolicies((List)new ArrayList<String>(){
                {
                    this.add("Unlimited");
                }
            });
            body.setVisibility(API.VisibilityEnum.PUBLIC);
            body.setTags(new ArrayList());
            body.setVisibleRoles(new ArrayList());
            body.setVisibleTenants(new ArrayList());
            body.setSequences(new ArrayList());
            body.setBusinessInformation(new APIBusinessInformation());
            body.setCorsConfiguration(new APICorsConfiguration());
            this.api.apisPost(body);
        }
        catch (ApiException ae) {
            JsonParser parser = new JsonParser();
            JsonObject responseBody = (JsonObject)parser.parse(ae.getResponseBody());
            String errorMsg = responseBody.get("message").getAsString();
            int errorCode = ae.getCode();
            Assert.assertEquals((int)errorCode, (int)400, (String)"response code mismatch");
            Assert.assertEquals((String)errorMsg, (String)"version may not be null", (String)"response message mismatch");
        }
        finally {
            APIList response = this.api.apisGet(Integer.valueOf(10), Integer.valueOf(0), null, null);
            int apiCount = response.getCount();
            Assert.assertEquals((int)apiCount, (int)0, (String)"createApi_existingName() test failed");
        }
    }

    @AfterClass
    public void afterClass() throws ApiException {
        APIIndividualApi apiClient = new APIIndividualApi();
        APIList response = this.api.apisGet(Integer.valueOf(10), Integer.valueOf(0), null, null);
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        for (int i = 0; i < response.getCount(); ++i) {
            String apiId = ((APIInfo)response.getList().get(i)).getId();
            apiClient.apisApiIdDelete(apiId, ifMatch, ifUnmodifiedSince);
        }
    }
}

