/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.api.publisher;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.rest.integration.tests.api.publisher.TestUtils;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiResponse;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.EndpointCollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.EndpointIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.EndPoint;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.EndPointEndpointSecurity;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.EndPointList;

public class EndpointCollectionApiIT {
    private final EndpointCollectionApi api = new EndpointCollectionApi();
    private final EndpointIndividualApi endpointIndividualApi = new EndpointIndividualApi();
    private final TestUtils testUtils = new TestUtils();

    @Test
    public void endpointsGetTest() throws ApiException {
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        String endPointId1 = this.testUtils.createEndPoint("EndPoint-118", "{\"serviceUrl\":\"http://petstore.swagger.io/\"}", "admin", "admin");
        String endPointId2 = this.testUtils.createEndPoint("EndPoint-119", "{\"serviceUrl\":\"http://petstore.swagger.io/\"}", "user", "pass");
        EndPointList response = this.api.endpointsGet(ifNoneMatch, ifModifiedSince);
        int endPointCount = response.getCount();
        Assert.assertEquals((int)endPointCount, (int)2, (String)"EndPoint count mismatch");
        if (((EndPoint)response.getList().get(0)).getName().equals("EndPoint-118")) {
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getType(), (String)"production", (String)"EndPoint type mismatch");
            Assert.assertEquals((long)((EndPoint)response.getList().get(0)).getMaxTps(), (long)1000L, (String)"EndPoint MaxTps mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getEndpointConfig(), (String)"{\"serviceUrl\":\"http://petstore.swagger.io/\"}", (String)"EndPoint config mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getId(), (String)endPointId1, (String)"EndPoint id mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getEndpointSecurity().getUsername(), (String)"admin", (String)"EndPointSecurity username mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getEndpointSecurity().getPassword(), (String)"admin", (String)"EndPointSecurity password mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getEndpointSecurity().getEnabled().toString(), (String)"false", (String)"EndPointSecurity isEnable mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getEndpointSecurity().getType(), (String)"http", (String)"EndPointSecurity type mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getName(), (String)"EndPoint-119", (String)"Endpoint Name mismatch - index(1)");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getType(), (String)"production", (String)"EndPoint type mismatch");
            Assert.assertEquals((long)((EndPoint)response.getList().get(1)).getMaxTps(), (long)1000L, (String)"EndPoint MaxTps mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getEndpointConfig(), (String)"{\"serviceUrl\":\"http://petstore.swagger.io/\"}", (String)"EndPoint config mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getId(), (String)endPointId2, (String)"EndPoint id mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getEndpointSecurity().getUsername(), (String)"user", (String)"EndPointSecurity username mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getEndpointSecurity().getPassword(), (String)"pass", (String)"EndPointSecurity password mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getEndpointSecurity().getEnabled().toString(), (String)"false", (String)"EndPointSecurity isEnable mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getEndpointSecurity().getType(), (String)"http", (String)"EndPointSecurity type mismatch");
        } else {
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getName(), (String)"EndPoint-119", (String)"Endpoint Name mismatch - index(0)");
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getType(), (String)"production", (String)"EndPoint type mismatch");
            Assert.assertEquals((long)((EndPoint)response.getList().get(0)).getMaxTps(), (long)1000L, (String)"EndPoint MaxTps mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getEndpointConfig(), (String)"{\"serviceUrl\":\"http://petstore.swagger.io/\"}", (String)"EndPoint config mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getId(), (String)endPointId2, (String)"EndPoint id mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getEndpointSecurity().getUsername(), (String)"user", (String)"EndPointSecurity username mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getEndpointSecurity().getPassword(), (String)"pass", (String)"EndPointSecurity password mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getEndpointSecurity().getEnabled().toString(), (String)"false", (String)"EndPointSecurity isEnable mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(0)).getEndpointSecurity().getType(), (String)"http", (String)"EndPointSecurity type mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getName(), (String)"EndPoint-118", (String)"Endpoint Name mismatch - index(1)");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getType(), (String)"production", (String)"EndPoint type mismatch");
            Assert.assertEquals((long)((EndPoint)response.getList().get(1)).getMaxTps(), (long)1000L, (String)"EndPoint MaxTps mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getEndpointConfig(), (String)"{\"serviceUrl\":\"http://petstore.swagger.io/\"}", (String)"EndPoint config mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getId(), (String)endPointId1, (String)"EndPoint id mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getEndpointSecurity().getUsername(), (String)"admin", (String)"EndPointSecurity username mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getEndpointSecurity().getPassword(), (String)"admin", (String)"EndPointSecurity password mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getEndpointSecurity().getEnabled().toString(), (String)"false", (String)"EndPointSecurity isEnable mismatch");
            Assert.assertEquals((String)((EndPoint)response.getList().get(1)).getEndpointSecurity().getType(), (String)"http", (String)"EndPointSecurity type mismatch");
        }
        this.testUtils.deleteEndPoint(endPointId1);
        this.testUtils.deleteEndPoint(endPointId2);
    }

    @Test
    public void endpointsHeadTest_NF() throws ApiException {
        String ifNoneMatch = null;
        String name = "invalidEndpoint";
        try {
            this.api.endpointsHead(name, ifNoneMatch);
            assert (false);
        }
        catch (ApiException ae) {
            Assert.assertEquals((int)ae.getCode(), (int)404, (String)"status code mismatch");
        }
    }

    @Test
    public void endpointsHeadTest() throws ApiException {
        String endpointId = this.testUtils.createEndPoint("Endpoint-120", "{\"serviceUrl\":\"http://petstore.swagger.io/\"}", "user", "user");
        String name = "Endpoint-120";
        String ifNoneMatch = null;
        ApiResponse response = this.api.endpointsHeadWithHttpInfo(name, ifNoneMatch);
        int statusCode = response.getStatusCode();
        Assert.assertEquals((int)200, (int)statusCode, (String)"status code mismatch");
        this.testUtils.deleteEndPoint(endpointId);
    }

    @Test
    public void endpointsPostTest() throws ApiException {
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        long MaxTps = 1000L;
        EndPointEndpointSecurity endPointEndpointSecurity = new EndPointEndpointSecurity();
        endPointEndpointSecurity.setEnabled(Boolean.valueOf(false));
        endPointEndpointSecurity.setType("http");
        endPointEndpointSecurity.setUsername("admin");
        endPointEndpointSecurity.setPassword("admin");
        EndPoint endPoint = new EndPoint();
        endPoint.setId(UUID.randomUUID().toString());
        endPoint.setName("Endpoint1");
        endPoint.setEndpointSecurity(endPointEndpointSecurity);
        endPoint.setType("production");
        endPoint.setMaxTps(Long.valueOf(MaxTps));
        endPoint.setEndpointConfig("{\"serviceUrl\":\"http://petstore.swagger.io/\"}");
        EndPoint response = this.api.endpointsPost(endPoint, ifNoneMatch, ifModifiedSince);
        Assert.assertEquals((String)response.getName(), (String)"Endpoint1", (String)"Endpoint name mismatch");
        Assert.assertEquals((String)response.getEndpointConfig(), (String)"{\"serviceUrl\":\"http://petstore.swagger.io/\"}", (String)"endpoint config mismatch");
        Assert.assertEquals((long)response.getMaxTps(), (long)1000L, (String)"MaxTps mismatch");
        Assert.assertEquals((String)response.getEndpointSecurity().getPassword(), (String)"admin", (String)"Endpoint Security password mismatch");
        Assert.assertEquals((String)response.getEndpointSecurity().getUsername(), (String)"admin", (String)"Endpoint Security username mismatch");
        Assert.assertEquals((String)response.getEndpointSecurity().getType(), (String)"http", (String)"Endpoint Security type mismatch");
        Assert.assertEquals((String)response.getEndpointSecurity().getEnabled().toString(), (String)"false", (String)"Endpoint Security getEnabled mismatch");
        Assert.assertEquals((String)response.getType(), (String)"production", (String)"type mismatch");
        this.testUtils.deleteEndPoint(response.getId());
    }

    @Test
    public void endpointsPost_failuretest_duplicateEndpoints() throws ApiException {
        this.testUtils.createEndPoint("Endpoint200", "{\"serviceUrl\":\"http://petstore.swagger.io/\"}", "admin", "admin");
        try {
            this.testUtils.createEndPoint("Endpoint200", "{\"serviceUrl\":\"http://petstore.swagger.io/\"}", "user", "user");
        }
        catch (ApiException apiException) {
            JsonParser parser = new JsonParser();
            JsonObject responseBody = (JsonObject)parser.parse(apiException.getResponseBody());
            String errorMsg = responseBody.get("message").getAsString();
            Assert.assertEquals((String)errorMsg, (String)"Endpoint already exists", (String)"Response message mismatch");
        }
    }

    @Test
    public void endpointsPostTest_NF() throws ApiException {
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        long MaxTps = 1000L;
        EndPointEndpointSecurity endPointEndpointSecurity = new EndPointEndpointSecurity();
        endPointEndpointSecurity.setEnabled(Boolean.valueOf(false));
        endPointEndpointSecurity.setType("http");
        endPointEndpointSecurity.setUsername("admin");
        endPointEndpointSecurity.setPassword("admin");
        EndPoint endPoint = new EndPoint();
        endPoint.setId(UUID.randomUUID().toString());
        endPoint.setName("");
        endPoint.setEndpointSecurity(endPointEndpointSecurity);
        endPoint.setType("production");
        endPoint.setMaxTps(Long.valueOf(MaxTps));
        endPoint.setEndpointConfig("{\"serviceUrl\":\"http://petstore.swagger.io/\"}");
        try {
            this.api.endpointsPost(endPoint, ifNoneMatch, ifModifiedSince);
            assert (false);
        }
        catch (ApiException ae) {
            Assert.assertEquals((int)ae.getCode(), (int)400, (String)"status code mismatch");
        }
    }

    @AfterClass
    public void afterClass() throws ApiException {
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        EndPointList response = this.api.endpointsGet(ifNoneMatch, ifModifiedSince);
        for (int i = 0; i < response.getCount(); ++i) {
            String endpointId = ((EndPoint)response.getList().get(i)).getId();
            this.testUtils.deleteEndPoint(endpointId);
        }
    }
}

