/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.api.publisher;

import java.io.File;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.rest.integration.tests.api.publisher.TestUtils;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APICollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APIIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.ImportConfigurationApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.API;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIInfo;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIList;

public class ImportConfigurationApiIT {
    private final ImportConfigurationApi api = new ImportConfigurationApi();
    private final APICollectionApi apiSetup = new APICollectionApi();
    private final APIIndividualApi apiIndividualApi = new APIIndividualApi();
    private final TestUtils testUtils = new TestUtils();

    @Test
    public void importApisPostTest() throws ApiException {
        File file = new File(this.getClass().getResource("/sampleapi.zip").getFile());
        String provider = "admin";
        APIList response = this.api.importApisPost(file, provider);
        Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getName(), (String)"SampleAPI", (String)"API name mismatch");
        Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getContext(), (String)"/sample-api", (String)"API context mismatch");
        Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getLifeCycleStatus(), (String)"Created", (String)"API lifecycle status mismatch");
        Assert.assertEquals((String)((APIInfo)response.getList().get(0)).getVersion(), (String)"1.0.0", (String)"API version mismatch");
        this.testUtils.deleteApi();
    }

    @Test(enabled=false)
    public void importApisPost_failureTest() throws ApiException {
        File file = new File(this.getClass().getResource("/file1.txt").getFile());
        String provider = "admin";
        try {
            this.api.importApisPost(file, provider);
            assert (false);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)400, (String)"status code mismatch");
        }
    }

    @Test(enabled=false)
    public void importApisPutTest() throws ApiException {
        String apiId = this.testUtils.createApi("sampleapi", "1.0.0", "/sample-api");
        File file = new File(this.getClass().getResource("/sampleapi.zip").getFile());
        API body = this.apiIndividualApi.apisApiIdGet(apiId, null, null);
        System.out.println(body);
        String provider = "admin";
        APIList response = this.api.importApisPut(file, provider);
        System.out.println(response);
    }

    @AfterClass
    public void afterClass() throws ApiException {
        APIList response = this.apiSetup.apisGet(Integer.valueOf(10), Integer.valueOf(0), null, null);
        for (int i = 0; i < response.getCount(); ++i) {
            this.apiIndividualApi.apisApiIdDelete(((APIInfo)response.getList().get(i)).getId(), null, null);
        }
    }
}

