/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.microgateway;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.rest.integration.tests.microgateway.MockedApiClient;

public class MockedApiClientTest {
    private final MockedApiClient mockedApiClient = new MockedApiClient();
    Logger logger = LoggerFactory.getLogger(MockedApiClientTest.class);
    String validContext = "api";
    String invalidContext = "mockyApi";
    String validApiKey = "122456";
    String invalidApiKey = "111111";

    @Test
    public void validAPIkeyValidContextTest() {
        try {
            String response = this.mockedApiClient.get(this.validApiKey, this.validContext);
            Assert.assertEquals((String)response, (String)"{ \"abc\": \"This is a test\" }", (String)"Mocked api content");
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.info("Failed to initialize SSL handling.", (Throwable)e);
        }
        catch (KeyManagementException e) {
            this.logger.info("Failed to initialize SSL handling.", (Throwable)e);
        }
    }

    @Test
    public void invalidAPIkeyValidContextTest() {
        try {
            String response = this.mockedApiClient.get(this.invalidApiKey, this.validContext);
            Assert.assertEquals((String)response, (String)"{\"code\":900903,\"message\":\"subscription not found\"}", (String)"Error Message for invalid api_key");
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.info("Failed to initialize SSL handling.", (Throwable)e);
        }
        catch (KeyManagementException e) {
            this.logger.info("Failed to initialize SSL handling.", (Throwable)e);
        }
    }

    @Test
    public void validAPIkeyInvalidContextTest() {
        try {
            String response = this.mockedApiClient.get(this.validApiKey, this.invalidContext);
            Assert.assertEquals((String)response, (String)"no matching service found for path : /mockyApi", (String)"Error message for invalid context");
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.info("Failed to initialize SSL handling.", (Throwable)e);
        }
        catch (KeyManagementException e) {
            this.logger.info("Failed to initialize SSL handling.", (Throwable)e);
        }
    }

    @Test
    public void invalidAPIkeyInvalidContextTest() {
        try {
            String response = this.mockedApiClient.get(this.invalidApiKey, this.invalidContext);
            Assert.assertEquals((String)response, (String)"no matching service found for path : /mockyApi", (String)"Error message for invalid context");
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.info("Failed to initialize SSL handling.", (Throwable)e);
        }
        catch (KeyManagementException e) {
            this.logger.info("Failed to initialize SSL handling.", (Throwable)e);
        }
    }
}

