/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.api;

import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.rest.integration.tests.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.api.APICollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.api.APIIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.api.DocumentCollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.model.API;
import org.wso2.carbon.apimgt.rest.integration.tests.model.APIBusinessInformation;
import org.wso2.carbon.apimgt.rest.integration.tests.model.APICorsConfiguration;
import org.wso2.carbon.apimgt.rest.integration.tests.model.APIEndpointSecurity;
import org.wso2.carbon.apimgt.rest.integration.tests.model.APIInfo;
import org.wso2.carbon.apimgt.rest.integration.tests.model.APIList;
import org.wso2.carbon.apimgt.rest.integration.tests.model.APIMaxTps;
import org.wso2.carbon.apimgt.rest.integration.tests.model.Document;
import org.wso2.carbon.apimgt.rest.integration.tests.model.DocumentList;

public class DocumentCollectionApiIT {
    private final DocumentCollectionApi api = new DocumentCollectionApi();
    private final APICollectionApi apiSetup = new APICollectionApi();
    private final APIIndividualApi apiIndividualApi = new APIIndividualApi();
    private String APIID = null;

    @BeforeClass
    public void beforeClass() throws ApiException {
        API body = new API();
        String contentType = "application/json";
        if (body != null) {
            body.setApiDefinition("{ \t\"paths\": { \t\t\"/order\": { \t\t\t\"post\": { \t\t\t\t\"x-auth-type\": \"Application & Application User\", \t\t\t\t\"x-throttling-tier\": \"Unlimited\", \t\t\t\t\"description\": \"Create a new Order\", \t\t\t\t\"parameters\": [{ \t\t\t\t\t\"schema\": { \t\t\t\t\t\t\"$ref\": \"#/definitions/Order\" \t\t\t\t\t}, \t\t\t\t\t\"description\": \"Order object that needs to be added\", \t\t\t\t\t\"name\": \"body\", \t\t\t\t\t\"required\": true, \t\t\t\t\t\"in\": \"body\" \t\t\t\t}], \t\t\t\t\"responses\": { \t\t\t\t\t\"201\": { \t\t\t\t\t\t\"headers\": { \t\t\t\t\t\t\t\"Location\": { \t\t\t\t\t\t\t\t\"description\": \"The URL of the newly created resource.\", \t\t\t\t\t\t\t\t\"type\": \"string\" \t\t\t\t\t\t\t} \t\t\t\t\t\t}, \t\t\t\t\t\t\"schema\": { \t\t\t\t\t\t\t\"$ref\": \"#/definitions/Order\" \t\t\t\t\t\t}, \t\t\t\t\t\t\"description\": \"Created.\" \t\t\t\t\t} \t\t\t\t} \t\t\t} \t\t}, \t\t\"/menu\": { \t\t\t\"get\": { \t\t\t\t\"x-auth-type\": \"Application & Application User\", \t\t\t\t\"x-throttling-tier\": \"Unlimited\", \t\t\t\t\"description\": \"Return a list of available menu items\", \t\t\t\t\"parameters\": [], \t\t\t\t\"responses\": { \t\t\t\t\t\"200\": { \t\t\t\t\t\t\"headers\": {}, \t\t\t\t\t\t\"schema\": { \t\t\t\t\t\t\t\"title\": \"Menu\", \t\t\t\t\t\t\t\"properties\": { \t\t\t\t\t\t\t\t\"list\": { \t\t\t\t\t\t\t\t\t\"items\": { \t\t\t\t\t\t\t\t\t\t\"$ref\": \"#/definitions/MenuItem\" \t\t\t\t\t\t\t\t\t}, \t\t\t\t\t\t\t\t\t\"type\": \"array\" \t\t\t\t\t\t\t\t} \t\t\t\t\t\t\t}, \t\t\t\t\t\t\t\"type\": \"object\" \t\t\t\t\t\t}, \t\t\t\t\t\t\"description\": \"OK.\" \t\t\t\t\t} \t\t\t\t} \t\t\t} \t\t} \t}, \t\"schemes\": [\"https\"], \t\"produces\": [\"application/json\"], \t\"swagger\": \"2.0\", \t\"definitions\": { \t\t\"MenuItem\": { \t\t\t\"title\": \"Pizza menu Item\", \t\t\t\"properties\": { \t\t\t\t\"price\": { \t\t\t\t\t\"type\": \"string\" \t\t\t\t}, \t\t\t\t\"description\": { \t\t\t\t\t\"type\": \"string\" \t\t\t\t}, \t\t\t\t\"name\": { \t\t\t\t\t\"type\": \"string\" \t\t\t\t}, \t\t\t\t\"image\": { \t\t\t\t\t\"type\": \"string\" \t\t\t\t} \t\t\t}, \t\t\t\"required\": [\"name\"] \t\t}, \t\t\"Order\": { \t\t\t\"title\": \"Pizza Order\", \t\t\t\"properties\": { \t\t\t\t\"customerName\": { \t\t\t\t\t\"type\": \"string\" \t\t\t\t}, \t\t\t\t\"delivered\": { \t\t\t\t\t\"type\": \"boolean\" \t\t\t\t}, \t\t\t\t\"address\": { \t\t\t\t\t\"type\": \"string\" \t\t\t\t}, \t\t\t\t\"pizzaType\": { \t\t\t\t\t\"type\": \"string\" \t\t\t\t}, \t\t\t\t\"creditCardNumber\": { \t\t\t\t\t\"type\": \"string\" \t\t\t\t}, \t\t\t\t\"quantity\": { \t\t\t\t\t\"type\": \"number\" \t\t\t\t}, \t\t\t\t\"orderId\": { \t\t\t\t\t\"type\": \"integer\" \t\t\t\t} \t\t\t}, \t\t\t\"required\": [\"orderId\"] \t\t} \t}, \t\"consumes\": [\"application/json\"], \t\"info\": { \t\t\"title\": \"PizzaShackAPI\", \t\t\"description\": \"This document describe a RESTFul API for Pizza Shack online pizza delivery store.\\n\", \t\t\"license\": { \t\t\t\"name\": \"Apache 2.0\", \t\t\t\"url\": \"http://www.apache.org/licenses/LICENSE-2.0.html\" \t\t}, \t\t\"contact\": { \t\t\t\"email\": \"architecture@pizzashack.com\", \t\t\t\"name\": \"John Doe\", \t\t\t\"url\": \"http://www.pizzashack.com\" \t\t}, \t\t\"version\": \"1.0.0\" \t} }");
        }
        body.setName("DocAPI");
        body.setContext("docs");
        body.setVersion("1.0.0");
        body.setProvider("admin");
        body.setLifeCycleStatus("CREATED");
        body.setTransport((List)new ArrayList<String>(){
            {
                this.add("http");
            }
        });
        body.setCacheTimeout(Integer.valueOf(100));
        body.setPolicies((List)new ArrayList<String>(){
            {
                this.add("Unlimited");
            }
        });
        body.setVisibility(API.VisibilityEnum.PUBLIC);
        body.setTags(new ArrayList());
        body.setMaxTps(new APIMaxTps());
        body.setVisibleRoles(new ArrayList());
        body.setVisibleTenants(new ArrayList());
        body.setEndpointSecurity(new APIEndpointSecurity());
        body.setSequences(new ArrayList());
        body.setBusinessInformation(new APIBusinessInformation());
        body.setCorsConfiguration(new APICorsConfiguration());
        API response = this.apiSetup.apisPost(body, contentType);
        this.APIID = response.getId();
    }

    @Test(dependsOnMethods={"apisApiIdDocumentsPostTest"}, enabled=true)
    public void apisApiIdDocumentsGetTest() throws ApiException {
        String apiId = this.APIID;
        Integer limit = null;
        Integer offset = null;
        String accept = null;
        String ifNoneMatch = null;
        DocumentList response = this.api.apisApiIdDocumentsGet(apiId, limit, offset, accept, ifNoneMatch);
        Assert.assertEquals((String)((Document)response.getList().get(0)).getName(), (String)"Help", (String)"Document name mismatch");
    }

    @Test(enabled=true)
    public void apisApiIdDocumentsPostTest() throws ApiException {
        String apiId = this.APIID;
        Document body = new Document();
        body.setName("Help");
        body.setType(Document.TypeEnum.HOWTO);
        body.setSourceType(Document.SourceTypeEnum.INLINE);
        body.setVisibility(Document.VisibilityEnum.API_LEVEL);
        body.setInlineContent("This is the inline content");
        String contentType = "application/json";
        Document response = this.api.apisApiIdDocumentsPost(apiId, body, contentType);
        Assert.assertEquals((String)response.getName(), (String)"Help", (String)"Document name mismatch");
    }

    @AfterClass
    public void afterClass() throws ApiException {
        APIList response = this.apiSetup.apisGet(Integer.valueOf(1), Integer.valueOf(1), null, null, null);
        this.apiIndividualApi.apisApiIdDelete(((APIInfo)response.getList().get(0)).getId(), null, null);
    }
}

