/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.tests.interceptor;

import java.util.List;
import java.util.Map;
import org.wso2.micro.gateway.interceptor.Caller;
import org.wso2.micro.gateway.interceptor.ConfigUtils;
import org.wso2.micro.gateway.interceptor.Interceptor;
import org.wso2.micro.gateway.interceptor.Request;
import org.wso2.micro.gateway.interceptor.Response;

public class ConfigInterceptor
implements Interceptor {
    private String responseString = "";

    public boolean interceptRequest(Caller caller, Request request) {
        String queryParam = request.getQueryParamValue("config");
        switch (queryParam = queryParam != null ? queryParam : "") {
            case "int": {
                int port = ConfigUtils.getAsInt((String)"listenerConfig.httpPort", (int)9080);
                this.responseString = Integer.toString(port);
                break;
            }
            case "float": {
                float portSecured = ConfigUtils.getAsFloat((String)"listenerConfig.httpsPort", (float)9080.0f);
                this.responseString = Float.toString(portSecured);
                break;
            }
            case "boolean": {
                boolean analyticsEnabled = ConfigUtils.getAsBoolean((String)"analytics.enable", (boolean)true);
                this.responseString = Boolean.toString(analyticsEnabled);
                break;
            }
            case "array": {
                List tokenConfig = ConfigUtils.getAsList((String)"jwtTokenConfig");
                this.responseString = (String)((Map)tokenConfig.get(0)).get("issuer");
                break;
            }
            case "map": {
                Map analytics = ConfigUtils.getAsMap((String)"analytics");
                this.responseString = (String)analytics.get("enable");
                break;
            }
            default: {
                this.responseString = ConfigUtils.getAsString((String)"analytics.uploadingEndpoint", (String)"");
            }
        }
        this.respondFromRequest(caller);
        return false;
    }

    public boolean interceptResponse(Caller caller, Response response) {
        return true;
    }

    private void respondFromRequest(Caller caller) {
        Response response = new Response();
        response.setTextPayload(this.responseString);
        caller.respond(response);
    }
}

