/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.das.integration.common.ui.page.main;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.testng.Assert;
import org.wso2.das.integration.common.ui.page.util.UIElementMapper;

public class WebAppListPage {
    private static final Log log = LogFactory.getLog(WebAppListPage.class);
    private WebDriver driver;

    public WebAppListPage(WebDriver driver) throws IOException {
        this.driver = driver;
        UIElementMapper uiElementMapper = UIElementMapper.getInstance();
        driver.findElement(By.xpath((String)uiElementMapper.getElement("webapp.list.xpath"))).click();
        if (!driver.findElement(By.id((String)uiElementMapper.getElement("webapp.list.page.middle"))).getText().contains("Running Applications")) {
            throw new IllegalStateException("This is not the Running Web Applications Page");
        }
    }

    public boolean findWebApp(String webAppContext) {
        WebElement table_element = this.driver.findElement(By.id((String)"webappsTable"));
        List tr_collection = table_element.findElement(By.tagName((String)"tbody")).findElements(By.tagName((String)"tr"));
        log.info((Object)("Number of rows in webapp table = " + tr_collection.size()));
        if (tr_collection.size() == 0) {
            return false;
        }
        int row_num = 1;
        for (WebElement trElement : tr_collection) {
            List td_collection = trElement.findElements(By.tagName((String)"td"));
            int col_num = 1;
            for (WebElement tdElement : td_collection) {
                log.info((Object)("row # " + row_num + ", col # " + col_num + "text=" + tdElement.getText()));
                if (tdElement.getText().equals(webAppContext)) {
                    log.info((Object)"Webapp context found");
                    return true;
                }
                ++col_num;
            }
            ++row_num;
        }
        return false;
    }

    public boolean deleteWebApp(String webAppContext) throws Exception {
        WebElement table_element = this.driver.findElement(By.id((String)"webappsTable"));
        List tr_collection = table_element.findElement(By.tagName((String)"tbody")).findElements(By.tagName((String)"tr"));
        if (tr_collection.size() == 0) {
            throw new Exception("Web App you are trying to delete not exists");
        }
        for (WebElement tr : tr_collection) {
            List td_collection = tr.findElements(By.tagName((String)"td"));
            if (!webAppContext.equals(((WebElement)td_collection.get(1)).getText())) continue;
            ((WebElement)td_collection.get(0)).findElement(By.tagName((String)"input")).click();
            this.driver.findElement(By.id((String)"delete2")).click();
            Assert.assertEquals((String)this.driver.findElement(By.id((String)"messagebox-confirm")).getText(), (String)"Do you want to delete the selected applications?", (String)"Delete Confirmation message mismatched");
            List buttons = this.driver.findElements(By.tagName((String)"button"));
            for (WebElement button : buttons) {
                if (!"yes".equalsIgnoreCase(button.getText())) continue;
                button.click();
                break;
            }
            Assert.assertEquals((String)this.driver.findElement(By.id((String)"messagebox-info")).getText(), (String)"Successfully deleted selected applications", (String)"Web Application deletion failed. Message box content mis matched");
            this.driver.findElement(By.xpath((String)"/html/body/div[3]/div[2]/button")).click();
            return true;
        }
        throw new Exception("Web App you are trying to delete not exists");
    }

    public void loadWebAppURL(String URL) {
        this.driver.get(URL);
    }
}

