/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.client;

import java.io.IOException;
import org.apache.hadoop.hdfs.qjournal.client.AsyncLogger;
import org.apache.hadoop.hdfs.qjournal.client.AsyncLoggerSet;
import org.apache.hadoop.hdfs.qjournal.client.QuorumCall;
import org.apache.hadoop.hdfs.qjournal.client.QuorumJournalManager;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditsDoubleBuffer;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.io.DataOutputBuffer;

class QuorumOutputStream
extends EditLogOutputStream {
    private final AsyncLoggerSet loggers;
    private EditsDoubleBuffer buf;
    private final long segmentTxId;
    private final int writeTimeoutMs;

    public QuorumOutputStream(AsyncLoggerSet loggers, long txId, int outputBufferCapacity, int writeTimeoutMs) throws IOException {
        this.buf = new EditsDoubleBuffer(outputBufferCapacity);
        this.loggers = loggers;
        this.segmentTxId = txId;
        this.writeTimeoutMs = writeTimeoutMs;
    }

    @Override
    public void write(FSEditLogOp op) throws IOException {
        this.buf.writeOp(op);
    }

    @Override
    public void writeRaw(byte[] bytes, int offset, int length) throws IOException {
        this.buf.writeRaw(bytes, offset, length);
    }

    @Override
    public void create() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this.buf != null) {
            this.buf.close();
            this.buf = null;
        }
    }

    @Override
    public void abort() throws IOException {
        QuorumJournalManager.LOG.warn((Object)("Aborting " + this));
        this.buf = null;
        this.close();
    }

    @Override
    public void setReadyToFlush() throws IOException {
        this.buf.setReadyToFlush();
    }

    @Override
    protected void flushAndSync(boolean durable) throws IOException {
        int numReadyBytes = this.buf.countReadyBytes();
        if (numReadyBytes > 0) {
            int numReadyTxns = this.buf.countReadyTxns();
            long firstTxToFlush = this.buf.getFirstReadyTxId();
            assert (numReadyTxns > 0);
            DataOutputBuffer bufToSend = new DataOutputBuffer(numReadyBytes);
            this.buf.flushTo(bufToSend);
            assert (bufToSend.getLength() == numReadyBytes);
            byte[] data = bufToSend.getData();
            assert (data.length == bufToSend.getLength());
            QuorumCall<AsyncLogger, Void> qcall = this.loggers.sendEdits(this.segmentTxId, firstTxToFlush, numReadyTxns, data);
            this.loggers.waitForWriteQuorum(qcall, this.writeTimeoutMs, "sendEdits");
            this.loggers.setCommittedTxId(firstTxToFlush + (long)numReadyTxns - 1L);
        }
    }

    @Override
    public String generateHtmlReport() {
        StringBuilder sb = new StringBuilder();
        sb.append("Writing segment beginning at txid " + this.segmentTxId + "<br/>\n");
        this.loggers.appendHtmlReport(sb);
        return sb.toString();
    }

    public String toString() {
        return "QuorumOutputStream starting at txid " + this.segmentTxId;
    }
}

