/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Iterator;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.util.GSet;
import org.apache.hadoop.util.LightWeightGSet;

class BlocksMap {
    private final int capacity = LightWeightGSet.computeCapacity(2.0, "BlocksMap");
    private volatile GSet<Block, BlockInfo> blocks = new LightWeightGSet<Block, BlockInfo>(this.capacity);

    BlocksMap(float loadFactor) {
    }

    void close() {
        if (this.blocks != null) {
            this.blocks.clear();
            this.blocks = null;
        }
    }

    BlockCollection getBlockCollection(Block b) {
        BlockInfo info = this.blocks.get(b);
        return info != null ? info.getBlockCollection() : null;
    }

    BlockInfo addBlockCollection(BlockInfo b, BlockCollection bc) {
        BlockInfo info = this.blocks.get(b);
        if (info != b) {
            info = b;
            this.blocks.put(info);
        }
        info.setBlockCollection(bc);
        return info;
    }

    void removeBlock(Block block) {
        BlockInfo blockInfo = this.blocks.remove(block);
        if (blockInfo == null) {
            return;
        }
        blockInfo.setBlockCollection(null);
        for (int idx = blockInfo.numNodes() - 1; idx >= 0; --idx) {
            DatanodeDescriptor dn = blockInfo.getDatanode(idx);
            dn.removeBlock(blockInfo);
        }
    }

    BlockInfo getStoredBlock(Block b) {
        return this.blocks.get(b);
    }

    Iterator<DatanodeDescriptor> nodeIterator(Block b) {
        return this.nodeIterator(this.blocks.get(b));
    }

    Iterator<DatanodeDescriptor> nodeIterator(BlockInfo storedBlock) {
        return new NodeIterator(storedBlock);
    }

    int numNodes(Block b) {
        BlockInfo info = this.blocks.get(b);
        return info == null ? 0 : info.numNodes();
    }

    boolean removeNode(Block b, DatanodeDescriptor node) {
        BlockInfo info = this.blocks.get(b);
        if (info == null) {
            return false;
        }
        boolean removed = node.removeBlock(info);
        if (info.getDatanode(0) == null && info.getBlockCollection() == null) {
            this.blocks.remove(b);
        }
        return removed;
    }

    int size() {
        return this.blocks.size();
    }

    Iterable<BlockInfo> getBlocks() {
        return this.blocks;
    }

    int getCapacity() {
        return this.capacity;
    }

    BlockInfo replaceBlock(BlockInfo newBlock) {
        BlockInfo currentBlock = this.blocks.get(newBlock);
        assert (currentBlock != null) : "the block if not in blocksMap";
        for (int idx = currentBlock.numNodes() - 1; idx >= 0; --idx) {
            DatanodeDescriptor dn = currentBlock.getDatanode(idx);
            dn.replaceBlock(currentBlock, newBlock);
        }
        this.blocks.put(newBlock);
        return newBlock;
    }

    private static class NodeIterator
    implements Iterator<DatanodeDescriptor> {
        private BlockInfo blockInfo;
        private int nextIdx = 0;

        NodeIterator(BlockInfo blkInfo) {
            this.blockInfo = blkInfo;
        }

        @Override
        public boolean hasNext() {
            return this.blockInfo != null && this.nextIdx < this.blockInfo.getCapacity() && this.blockInfo.getDatanode(this.nextIdx) != null;
        }

        @Override
        public DatanodeDescriptor next() {
            return this.blockInfo.getDatanode(this.nextIdx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry. can't remove.");
        }
    }
}

