/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.CheckpointFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class GetImageServlet
extends HttpServlet {
    private static final long serialVersionUID = -7669068179452648952L;
    private static final Log LOG = LogFactory.getLog(GetImageServlet.class);
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HADOOP_IMAGE_EDITS_HEADER = "X-Image-Edits-Name";
    private static final String TXID_PARAM = "txid";
    private static final String START_TXID_PARAM = "startTxId";
    private static final String END_TXID_PARAM = "endTxId";
    private static final String STORAGEINFO_PARAM = "storageInfo";
    private static final String LATEST_FSIMAGE_VALUE = "latest";
    private static Set<Long> currentlyDownloadingCheckpoints = Collections.synchronizedSet(new HashSet());

    public void doGet(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        try {
            ServletContext context = this.getServletContext();
            final FSImage nnImage = NameNodeHttpServer.getFsImageFromContext(context);
            final GetImageParams parsedParams = new GetImageParams(request, response);
            final Configuration conf = (Configuration)this.getServletContext().getAttribute("current.conf");
            if (UserGroupInformation.isSecurityEnabled() && !GetImageServlet.isValidRequestor(context, request.getUserPrincipal().getName(), conf)) {
                response.sendError(403, "Only Namenode, Secondary Namenode, and administrators may access this servlet");
                LOG.warn((Object)("Received non-NN/SNN/administrator request for image or edits from " + request.getUserPrincipal().getName() + " at " + request.getRemoteHost()));
                return;
            }
            String myStorageInfoString = nnImage.getStorage().toColonSeparatedString();
            String theirStorageInfoString = parsedParams.getStorageInfoString();
            if (theirStorageInfoString != null && !myStorageInfoString.equals(theirStorageInfoString)) {
                response.sendError(403, "This namenode has storage info " + myStorageInfoString + " but the secondary expected " + theirStorageInfoString);
                LOG.warn((Object)("Received an invalid request file transfer request from a secondary with storage info " + theirStorageInfoString));
                return;
            }
            UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    if (parsedParams.isGetImage()) {
                        long txid = parsedParams.getTxId();
                        File imageFile = null;
                        String errorMessage = "Could not find image";
                        if (parsedParams.shouldFetchLatest()) {
                            imageFile = nnImage.getStorage().getHighestFsImageName();
                        } else {
                            errorMessage = errorMessage + " with txid " + txid;
                            imageFile = nnImage.getStorage().getFsImageName(txid);
                        }
                        if (imageFile == null) {
                            throw new IOException(errorMessage);
                        }
                        CheckpointFaultInjector.getInstance().beforeGetImageSetsHeaders();
                        this.serveFile(imageFile);
                    } else if (parsedParams.isGetEdit()) {
                        long startTxId = parsedParams.getStartTxId();
                        long endTxId = parsedParams.getEndTxId();
                        File editFile = nnImage.getStorage().findFinalizedEditsFile(startTxId, endTxId);
                        this.serveFile(editFile);
                    } else if (parsedParams.isPutImage()) {
                        long txid = parsedParams.getTxId();
                        if (!currentlyDownloadingCheckpoints.add(txid)) {
                            response.sendError(409, "Another checkpointer is already in the process of uploading a checkpoint made at transaction ID " + txid);
                            return null;
                        }
                        try {
                            if (nnImage.getStorage().findImageFile(txid) != null) {
                                response.sendError(409, "Another checkpointer already uploaded an checkpoint for txid " + txid);
                                Void endTxId = null;
                                return endTxId;
                            }
                            if (UserGroupInformation.isSecurityEnabled()) {
                                UserGroupInformation.getCurrentUser().checkTGTAndReloginFromKeytab();
                            }
                            MD5Hash downloadImageDigest = TransferFsImage.downloadImageToStorage(parsedParams.getInfoServer(), txid, nnImage.getStorage(), true);
                            nnImage.saveDigestAndRenameCheckpointImage(txid, downloadImageDigest);
                            nnImage.purgeOldStorage();
                        }
                        finally {
                            currentlyDownloadingCheckpoints.remove(txid);
                        }
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void serveFile(File file) throws IOException {
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        GetImageServlet.setVerificationHeaders(response, file);
                        GetImageServlet.setFileNameHeaders(response, file);
                        if (!file.exists()) {
                            throw new FileNotFoundException(file.toString());
                        }
                        TransferFsImage.getFileServer((ServletResponse)response, file, fis, GetImageServlet.getThrottler(conf));
                    }
                    finally {
                        IOUtils.closeStream(fis);
                    }
                }
            });
        }
        catch (Throwable t) {
            String errMsg = "GetImage failed. " + StringUtils.stringifyException(t);
            response.sendError(410, errMsg);
            throw new IOException(errMsg);
        }
        finally {
            response.getOutputStream().close();
        }
    }

    public static void setFileNameHeaders(HttpServletResponse response, File file) {
        response.setHeader(CONTENT_DISPOSITION, "attachment; filename=" + file.getName());
        response.setHeader(HADOOP_IMAGE_EDITS_HEADER, file.getName());
    }

    public static final DataTransferThrottler getThrottler(Configuration conf) {
        long transferBandwidth = conf.getLong("dfs.image.transfer.bandwidthPerSec", 0L);
        DataTransferThrottler throttler = null;
        if (transferBandwidth > 0L) {
            throttler = new DataTransferThrottler(transferBandwidth);
        }
        return throttler;
    }

    @VisibleForTesting
    static boolean isValidRequestor(ServletContext context, String remoteUser, Configuration conf) throws IOException {
        if (remoteUser == null) {
            LOG.warn((Object)"Received null remoteUser while authorizing access to getImage servlet");
            return false;
        }
        HashSet<String> validRequestors = new HashSet<String>();
        validRequestors.add(SecurityUtil.getServerPrincipal(conf.get("dfs.namenode.kerberos.principal"), NameNode.getAddress(conf).getHostName()));
        validRequestors.add(SecurityUtil.getServerPrincipal(conf.get("dfs.secondary.namenode.kerberos.principal"), SecondaryNameNode.getHttpAddress(conf).getHostName()));
        if (HAUtil.isHAEnabled(conf, DFSUtil.getNamenodeNameServiceId(conf))) {
            Configuration otherNnConf = HAUtil.getConfForOtherNode(conf);
            validRequestors.add(SecurityUtil.getServerPrincipal(otherNnConf.get("dfs.namenode.kerberos.principal"), NameNode.getAddress(otherNnConf).getHostName()));
        }
        for (String v : validRequestors) {
            if (v == null || !v.equals(remoteUser)) continue;
            LOG.info((Object)("GetImageServlet allowing checkpointer: " + remoteUser));
            return true;
        }
        if (HttpServer.userHasAdministratorAccess(context, remoteUser)) {
            LOG.info((Object)("GetImageServlet allowing administrator: " + remoteUser));
            return true;
        }
        LOG.info((Object)("GetImageServlet rejecting: " + remoteUser));
        return false;
    }

    public static void setVerificationHeaders(HttpServletResponse response, File file) throws IOException {
        response.setHeader("Content-Length", String.valueOf(file.length()));
        MD5Hash hash = MD5FileUtils.readStoredMd5ForFile(file);
        if (hash != null) {
            response.setHeader("X-MD5-Digest", hash.toString());
        }
    }

    static String getParamStringForMostRecentImage() {
        return "getimage=1&txid=latest";
    }

    static String getParamStringForImage(long txid, StorageInfo remoteStorageInfo) {
        return "getimage=1&txid=" + txid + "&" + STORAGEINFO_PARAM + "=" + remoteStorageInfo.toColonSeparatedString();
    }

    static String getParamStringForLog(RemoteEditLog log, StorageInfo remoteStorageInfo) {
        return "getedit=1&startTxId=" + log.getStartTxId() + "&" + END_TXID_PARAM + "=" + log.getEndTxId() + "&" + STORAGEINFO_PARAM + "=" + remoteStorageInfo.toColonSeparatedString();
    }

    static String getParamStringToPutImage(long txid, InetSocketAddress imageListenAddress, Storage storage) {
        String machine = !imageListenAddress.isUnresolved() && imageListenAddress.getAddress().isAnyLocalAddress() ? null : imageListenAddress.getHostName();
        return "putimage=1&txid=" + txid + "&port=" + imageListenAddress.getPort() + (machine != null ? "&machine=" + machine : "") + "&" + STORAGEINFO_PARAM + "=" + storage.toColonSeparatedString();
    }

    static class GetImageParams {
        private boolean isGetImage;
        private boolean isGetEdit;
        private boolean isPutImage;
        private int remoteport;
        private String machineName;
        private long startTxId;
        private long endTxId;
        private long txId;
        private String storageInfoString;
        private boolean fetchLatest;

        public GetImageParams(HttpServletRequest request, HttpServletResponse response) throws IOException {
            int numGets;
            Map pmap = request.getParameterMap();
            this.fetchLatest = false;
            this.isPutImage = false;
            this.isGetEdit = false;
            this.isGetImage = false;
            this.remoteport = 0;
            for (Map.Entry entry : pmap.entrySet()) {
                String key = (String)entry.getKey();
                String[] val = (String[])entry.getValue();
                if (key.equals("getimage")) {
                    this.isGetImage = true;
                    try {
                        this.txId = ServletUtil.parseLongParam((ServletRequest)request, GetImageServlet.TXID_PARAM);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        if (request.getParameter(GetImageServlet.TXID_PARAM).equals(GetImageServlet.LATEST_FSIMAGE_VALUE)) {
                            this.fetchLatest = true;
                            continue;
                        }
                        throw nfe;
                    }
                }
                if (key.equals("getedit")) {
                    this.isGetEdit = true;
                    this.startTxId = ServletUtil.parseLongParam((ServletRequest)request, GetImageServlet.START_TXID_PARAM);
                    this.endTxId = ServletUtil.parseLongParam((ServletRequest)request, GetImageServlet.END_TXID_PARAM);
                    continue;
                }
                if (key.equals("putimage")) {
                    this.isPutImage = true;
                    this.txId = ServletUtil.parseLongParam((ServletRequest)request, GetImageServlet.TXID_PARAM);
                    continue;
                }
                if (key.equals("port")) {
                    this.remoteport = new Integer(val[0]);
                    continue;
                }
                if (key.equals("machine")) {
                    this.machineName = val[0];
                    continue;
                }
                if (!key.equals(GetImageServlet.STORAGEINFO_PARAM)) continue;
                this.storageInfoString = val[0];
            }
            if (this.machineName == null) {
                this.machineName = request.getRemoteHost();
                if (InetAddresses.isInetAddress((String)this.machineName)) {
                    this.machineName = NetUtils.getHostNameOfIP(this.machineName);
                }
            }
            if ((numGets = (this.isGetImage ? 1 : 0) + (this.isGetEdit ? 1 : 0)) > 1 || numGets == 0 && !this.isPutImage) {
                throw new IOException("Illegal parameters to TransferFsImage");
            }
        }

        public String getStorageInfoString() {
            return this.storageInfoString;
        }

        public long getTxId() {
            Preconditions.checkState((this.isGetImage || this.isPutImage ? 1 : 0) != 0);
            return this.txId;
        }

        public long getStartTxId() {
            Preconditions.checkState((boolean)this.isGetEdit);
            return this.startTxId;
        }

        public long getEndTxId() {
            Preconditions.checkState((boolean)this.isGetEdit);
            return this.endTxId;
        }

        boolean isGetEdit() {
            return this.isGetEdit;
        }

        boolean isGetImage() {
            return this.isGetImage;
        }

        boolean isPutImage() {
            return this.isPutImage;
        }

        String getInfoServer() throws IOException {
            if (this.machineName == null || this.remoteport == 0) {
                throw new IOException("MachineName and port undefined");
            }
            return this.machineName + ":" + this.remoteport;
        }

        boolean shouldFetchLatest() {
            return this.fetchLatest;
        }
    }
}

