/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.util.Diff;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public abstract class INode
implements INodeAttributes,
Diff.Element<byte[]> {
    public static final Log LOG = LogFactory.getLog(INode.class);
    private INode parent = null;

    INode(INode parent) {
        this.parent = parent;
    }

    public abstract long getId();

    final boolean isRoot() {
        return this.getLocalNameBytes().length == 0;
    }

    abstract PermissionStatus getPermissionStatus(Snapshot var1);

    final PermissionStatus getPermissionStatus() {
        return this.getPermissionStatus(null);
    }

    abstract String getUserName(Snapshot var1);

    @Override
    public final String getUserName() {
        return this.getUserName(null);
    }

    abstract void setUser(String var1);

    final INode setUser(String user, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        INode nodeToUpdate = this.recordModification(latest, inodeMap);
        nodeToUpdate.setUser(user);
        return nodeToUpdate;
    }

    abstract String getGroupName(Snapshot var1);

    @Override
    public final String getGroupName() {
        return this.getGroupName(null);
    }

    abstract void setGroup(String var1);

    final INode setGroup(String group, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        INode nodeToUpdate = this.recordModification(latest, inodeMap);
        nodeToUpdate.setGroup(group);
        return nodeToUpdate;
    }

    abstract FsPermission getFsPermission(Snapshot var1);

    @Override
    public final FsPermission getFsPermission() {
        return this.getFsPermission(null);
    }

    abstract void setPermission(FsPermission var1);

    INode setPermission(FsPermission permission, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        INode nodeToUpdate = this.recordModification(latest, inodeMap);
        nodeToUpdate.setPermission(permission);
        return nodeToUpdate;
    }

    public INodeAttributes getSnapshotINode(Snapshot snapshot) {
        return this;
    }

    public final boolean isInLatestSnapshot(Snapshot latest) {
        if (latest == null) {
            return false;
        }
        if (this.parent != null && this.parent.isReference()) {
            return true;
        }
        INodeDirectory parentDir = this.getParent();
        if (parentDir == null) {
            return true;
        }
        if (!parentDir.isInLatestSnapshot(latest)) {
            return false;
        }
        INode child = parentDir.getChild(this.getLocalNameBytes(), latest);
        if (this == child) {
            return true;
        }
        if (child == null || !child.isReference()) {
            return false;
        }
        return this == child.asReference().getReferredINode();
    }

    public final boolean isAncestorDirectory(INodeDirectory dir) {
        for (INodeDirectory p = this.getParent(); p != null; p = p.getParent()) {
            if (p != dir) continue;
            return true;
        }
        return false;
    }

    public final boolean shouldRecordInSrcSnapshot(Snapshot latestInDst) {
        int dstSnapshotId;
        Preconditions.checkState((!this.isReference() ? 1 : 0) != 0);
        if (latestInDst == null) {
            return true;
        }
        INodeReference withCount = this.getParentReference();
        return withCount != null && (dstSnapshotId = withCount.getParentReference().getDstSnapshotId()) >= latestInDst.getId();
    }

    abstract INode recordModification(Snapshot var1, INodeMap var2) throws QuotaExceededException;

    public boolean isReference() {
        return false;
    }

    public INodeReference asReference() {
        throw new IllegalStateException("Current inode is not a reference: " + this.toDetailString());
    }

    public boolean isFile() {
        return false;
    }

    public INodeFile asFile() {
        throw new IllegalStateException("Current inode is not a file: " + this.toDetailString());
    }

    public boolean isDirectory() {
        return false;
    }

    public INodeDirectory asDirectory() {
        throw new IllegalStateException("Current inode is not a directory: " + this.toDetailString());
    }

    public boolean isSymlink() {
        return false;
    }

    public INodeSymlink asSymlink() {
        throw new IllegalStateException("Current inode is not a symlink: " + this.toDetailString());
    }

    public abstract Quota.Counts cleanSubtree(Snapshot var1, Snapshot var2, BlocksMapUpdateInfo var3, List<INode> var4, boolean var5) throws QuotaExceededException;

    public abstract void destroyAndCollectBlocks(BlocksMapUpdateInfo var1, List<INode> var2);

    public final ContentSummary computeContentSummary() {
        Content.Counts counts = this.computeContentSummary(Content.Counts.newInstance());
        return new ContentSummary(counts.get(Content.LENGTH), counts.get(Content.FILE) + counts.get(Content.SYMLINK), counts.get(Content.DIRECTORY), this.getNsQuota(), counts.get(Content.DISKSPACE), this.getDsQuota());
    }

    public abstract Content.Counts computeContentSummary(Content.Counts var1);

    public void addSpaceConsumed(long nsDelta, long dsDelta, boolean verify) throws QuotaExceededException {
        if (this.parent != null) {
            this.parent.addSpaceConsumed(nsDelta, dsDelta, verify);
        }
    }

    public long getNsQuota() {
        return -1L;
    }

    public long getDsQuota() {
        return -1L;
    }

    public final boolean isQuotaSet() {
        return this.getNsQuota() >= 0L || this.getDsQuota() >= 0L;
    }

    public final Quota.Counts computeQuotaUsage() {
        return this.computeQuotaUsage(new Quota.Counts(), true);
    }

    public abstract Quota.Counts computeQuotaUsage(Quota.Counts var1, boolean var2, int var3);

    public final Quota.Counts computeQuotaUsage(Quota.Counts counts, boolean useCache) {
        return this.computeQuotaUsage(counts, useCache, -1);
    }

    public final String getLocalName() {
        byte[] name = this.getLocalNameBytes();
        return name == null ? null : DFSUtil.bytes2String(name);
    }

    @Override
    public final byte[] getKey() {
        return this.getLocalNameBytes();
    }

    public abstract void setLocalName(byte[] var1);

    public String getFullPathName() {
        return FSDirectory.getFullPathName(this);
    }

    public String toString() {
        return this.getLocalName();
    }

    @VisibleForTesting
    public final String getObjectString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(super.hashCode());
    }

    @VisibleForTesting
    public final String getParentString() {
        INodeReference parentRef = this.getParentReference();
        if (parentRef != null) {
            return "parentRef=" + parentRef.getLocalName() + "->";
        }
        INodeDirectory parentDir = this.getParent();
        if (parentDir != null) {
            return "parentDir=" + parentDir.getLocalName() + "/";
        }
        return "parent=null";
    }

    @VisibleForTesting
    public String toDetailString() {
        return this.toString() + "(" + this.getObjectString() + "), " + this.getParentString();
    }

    public final INodeDirectory getParent() {
        return this.parent == null ? null : (this.parent.isReference() ? this.getParentReference().getParent() : this.parent.asDirectory());
    }

    public INodeReference getParentReference() {
        return this.parent == null || !this.parent.isReference() ? null : (INodeReference)this.parent;
    }

    public final void setParent(INodeDirectory parent) {
        this.parent = parent;
    }

    public final void setParentReference(INodeReference parent) {
        this.parent = parent;
    }

    public void clear() {
        this.setParent(null);
    }

    abstract long getModificationTime(Snapshot var1);

    @Override
    public final long getModificationTime() {
        return this.getModificationTime(null);
    }

    public abstract INode updateModificationTime(long var1, Snapshot var3, INodeMap var4) throws QuotaExceededException;

    public abstract void setModificationTime(long var1);

    public final INode setModificationTime(long modificationTime, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        INode nodeToUpdate = this.recordModification(latest, inodeMap);
        nodeToUpdate.setModificationTime(modificationTime);
        return nodeToUpdate;
    }

    abstract long getAccessTime(Snapshot var1);

    @Override
    public final long getAccessTime() {
        return this.getAccessTime(null);
    }

    public abstract void setAccessTime(long var1);

    public final INode setAccessTime(long accessTime, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        INode nodeToUpdate = this.recordModification(latest, inodeMap);
        nodeToUpdate.setAccessTime(accessTime);
        return nodeToUpdate;
    }

    static byte[][] getPathComponents(String path) {
        return INode.getPathComponents(INode.getPathNames(path));
    }

    static byte[][] getPathComponents(String[] strings) {
        if (strings.length == 0) {
            return new byte[][]{null};
        }
        byte[][] bytes = new byte[strings.length][];
        for (int i = 0; i < strings.length; ++i) {
            bytes[i] = DFSUtil.string2Bytes(strings[i]);
        }
        return bytes;
    }

    static String[] getPathNames(String path) {
        if (path == null || !path.startsWith("/")) {
            throw new AssertionError((Object)"Absolute path required");
        }
        return StringUtils.split(path, '/');
    }

    @Override
    public final int compareTo(byte[] bytes) {
        return DFSUtil.compareBytes(this.getLocalNameBytes(), bytes);
    }

    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !(that instanceof INode)) {
            return false;
        }
        return this.getId() == ((INode)that).getId();
    }

    public final int hashCode() {
        long id = this.getId();
        return (int)(id ^ id >>> 32);
    }

    @VisibleForTesting
    public final StringBuffer dumpTreeRecursively() {
        StringWriter out = new StringWriter();
        this.dumpTreeRecursively(new PrintWriter((Writer)out, true), new StringBuilder(), null);
        return out.getBuffer();
    }

    @VisibleForTesting
    public final void dumpTreeRecursively(PrintStream out) {
        this.dumpTreeRecursively(new PrintWriter(out, true), new StringBuilder(), null);
    }

    @VisibleForTesting
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, Snapshot snapshot) {
        out.print(prefix);
        out.print(" ");
        String name = this.getLocalName();
        out.print(name.isEmpty() ? "/" : name);
        out.print("   (");
        out.print(this.getObjectString());
        out.print("), ");
        out.print(this.getParentString());
        out.print(", " + this.getPermissionStatus(snapshot));
    }

    public static class BlocksMapUpdateInfo {
        private List<Block> toDeleteList;

        public BlocksMapUpdateInfo(List<Block> toDeleteList) {
            this.toDeleteList = toDeleteList == null ? new ArrayList() : toDeleteList;
        }

        public BlocksMapUpdateInfo() {
            this.toDeleteList = new ArrayList<Block>();
        }

        public List<Block> getToDeleteList() {
            return this.toDeleteList;
        }

        public void addDeleteBlock(Block toDelete) {
            if (toDelete != null) {
                this.toDeleteList.add(toDelete);
            }
        }

        public void clear() {
            this.toDeleteList.clear();
        }
    }
}

