/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapred.YarnOutputFiles;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.log4j.LogManager;

class YarnChild {
    private static final Log LOG = LogFactory.getLog(YarnChild.class);
    static volatile TaskAttemptID taskid = null;
    private static final FsPermission urw_gr = FsPermission.createImmutable((short)416);

    YarnChild() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        Thread.setDefaultUncaughtExceptionHandler(new YarnUncaughtExceptionHandler());
        LOG.debug((Object)"Child starting");
        final JobConf defaultConf = new JobConf();
        defaultConf.addResource("job.xml");
        UserGroupInformation.setConfiguration(defaultConf);
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        final InetSocketAddress address = NetUtils.createSocketAddrForHost(host, port);
        TaskAttemptID firstTaskid = TaskAttemptID.forName(args[2]);
        int jvmIdInt = Integer.parseInt(args[3]);
        JVMId jvmId = new JVMId(firstTaskid.getJobID(), firstTaskid.getTaskType() == TaskType.MAP, jvmIdInt);
        DefaultMetricsSystem.initialize(StringUtils.camelize(firstTaskid.getTaskType().name()) + "Task");
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        LOG.info((Object)"Executing with tokens:");
        for (Token<? extends TokenIdentifier> token : credentials.getAllTokens()) {
            LOG.info(token);
        }
        UserGroupInformation taskOwner = UserGroupInformation.createRemoteUser(firstTaskid.getJobID().toString());
        Token<JobTokenIdentifier> jt = TokenCache.getJobToken(credentials);
        SecurityUtil.setTokenService(jt, address);
        taskOwner.addToken(jt);
        final TaskUmbilicalProtocol umbilical = taskOwner.doAs(new PrivilegedExceptionAction<TaskUmbilicalProtocol>(){

            @Override
            public TaskUmbilicalProtocol run() throws Exception {
                return RPC.getProxy(TaskUmbilicalProtocol.class, 19L, address, defaultConf);
            }
        });
        JvmContext context = new JvmContext(jvmId, "-1000");
        LOG.debug((Object)("PID: " + System.getenv().get("JVM_PID")));
        Task task = null;
        UserGroupInformation childUGI = null;
        try {
            boolean idleLoopCount = false;
            JvmTask myTask = null;
            int idle = 0;
            while (null == myTask) {
                long sleepTimeMilliSecs = Math.min(idle * 500, 1500);
                LOG.info((Object)("Sleeping for " + sleepTimeMilliSecs + "ms before retrying again. Got null now."));
                TimeUnit.MILLISECONDS.sleep(sleepTimeMilliSecs);
                myTask = umbilical.getTask(context);
                ++idle;
            }
            if (myTask.shouldDie()) {
                return;
            }
            task = myTask.getTask();
            taskid = task.getTaskID();
            final JobConf job = YarnChild.configureTask(task, credentials, jt);
            JvmMetrics.initSingleton(jvmId.toString(), job.getSessionId());
            childUGI = UserGroupInformation.createRemoteUser(System.getenv(ApplicationConstants.Environment.USER.toString()));
            childUGI.addCredentials(credentials);
            MRApps.setJobClassLoader(job);
            final Task taskFinal = task;
            childUGI.doAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    FileSystem.get(job).setWorkingDirectory(job.getWorkingDirectory());
                    taskFinal.run(job, umbilical);
                    return null;
                }
            });
        }
        catch (FSError e) {
            LOG.fatal((Object)"FSError from child", (Throwable)e);
            umbilical.fsError(taskid, e.getMessage());
        }
        catch (Exception exception) {
            LOG.warn((Object)("Exception running child : " + StringUtils.stringifyException(exception)));
            try {
                if (task != null) {
                    if (childUGI == null) {
                        task.taskCleanup(umbilical);
                    } else {
                        final Task taskFinal = task;
                        childUGI.doAs(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                taskFinal.taskCleanup(umbilical);
                                return null;
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                LOG.info((Object)("Exception cleaning up: " + StringUtils.stringifyException(e)));
            }
            if (taskid != null) {
                umbilical.fatalError(taskid, StringUtils.stringifyException(exception));
            }
        }
        catch (Throwable throwable) {
            LOG.fatal((Object)("Error running child : " + StringUtils.stringifyException(throwable)));
            if (taskid != null) {
                Throwable tCause = throwable.getCause();
                String cause = tCause == null ? throwable.getMessage() : StringUtils.stringifyException(tCause);
                umbilical.fatalError(taskid, cause);
            }
        }
        finally {
            RPC.stopProxy(umbilical);
            DefaultMetricsSystem.shutdown();
            LogManager.shutdown();
        }
    }

    private static void configureLocalDirs(Task task, JobConf job) throws IOException {
        String[] localSysDirs = StringUtils.getTrimmedStrings(System.getenv(ApplicationConstants.Environment.LOCAL_DIRS.name()));
        job.setStrings("mapreduce.cluster.local.dir", localSysDirs);
        LOG.info((Object)("mapreduce.cluster.local.dir for child: " + job.get("mapreduce.cluster.local.dir")));
        LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapreduce.cluster.local.dir");
        Path workDir = null;
        try {
            workDir = lDirAlloc.getLocalPathToRead("work", job);
        }
        catch (DiskChecker.DiskErrorException e) {
            // empty catch block
        }
        if (workDir == null) {
            workDir = lDirAlloc.getLocalPathForWrite("work", job);
            FileSystem lfs = FileSystem.getLocal(job).getRaw();
            boolean madeDir = false;
            try {
                madeDir = lfs.mkdirs(workDir);
            }
            catch (FileAlreadyExistsException e) {
                madeDir = true;
                workDir = lDirAlloc.getLocalPathToRead("work", job);
            }
            if (!madeDir) {
                throw new IOException("Mkdirs failed to create " + workDir.toString());
            }
        }
        job.set("mapreduce.job.local.dir", workDir.toString());
    }

    private static JobConf configureTask(Task task, Credentials credentials, Token<JobTokenIdentifier> jt) throws IOException {
        JobConf job = new JobConf("job.xml");
        job.setCredentials(credentials);
        ApplicationAttemptId appAttemptId = ConverterUtils.toContainerId(System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name())).getApplicationAttemptId();
        LOG.debug((Object)("APPLICATION_ATTEMPT_ID: " + appAttemptId));
        job.setInt("mapreduce.job.application.attempt.id", appAttemptId.getAttemptId());
        job.setBoolean("ipc.client.tcpnodelay", true);
        job.setClass("mapreduce.task.local.output.class", YarnOutputFiles.class, MapOutputFile.class);
        task.setJobTokenSecret(JobTokenSecretManager.createSecretKey(jt.getPassword()));
        byte[] shuffleSecret = TokenCache.getShuffleSecretKey(credentials);
        if (shuffleSecret == null) {
            LOG.warn((Object)"Shuffle secret missing from task credentials. Using job token secret as shuffle secret.");
            shuffleSecret = jt.getPassword();
        }
        task.setShuffleSecret(JobTokenSecretManager.createSecretKey(shuffleSecret));
        YarnChild.configureLocalDirs(task, job);
        task.localizeConfiguration(job);
        YarnChild.setupDistributedCacheConfig(job);
        Path localTaskFile = new Path("job.xml");
        YarnChild.writeLocalJobFile(localTaskFile, job);
        task.setJobFile(localTaskFile.toString());
        task.setConf(job);
        return job;
    }

    private static void setupDistributedCacheConfig(JobConf job) throws IOException {
        URI[] cacheFiles;
        String localWorkDir = System.getenv("PWD");
        URI[] cacheArchives = DistributedCache.getCacheArchives(job);
        if (cacheArchives != null) {
            ArrayList<String> localArchives = new ArrayList<String>();
            for (int i = 0; i < cacheArchives.length; ++i) {
                URI u = cacheArchives[i];
                Path p = new Path(u);
                Path name = new Path(null == u.getFragment() ? p.getName() : u.getFragment());
                String linkName = name.toUri().getPath();
                localArchives.add(new Path(localWorkDir, linkName).toUri().getPath());
            }
            if (!localArchives.isEmpty()) {
                job.set("mapreduce.job.cache.local.archives", StringUtils.arrayToString(localArchives.toArray(new String[localArchives.size()])));
            }
        }
        if ((cacheFiles = DistributedCache.getCacheFiles(job)) != null) {
            ArrayList<String> localFiles = new ArrayList<String>();
            for (int i = 0; i < cacheFiles.length; ++i) {
                URI u = cacheFiles[i];
                Path p = new Path(u);
                Path name = new Path(null == u.getFragment() ? p.getName() : u.getFragment());
                String linkName = name.toUri().getPath();
                localFiles.add(new Path(localWorkDir, linkName).toUri().getPath());
            }
            if (!localFiles.isEmpty()) {
                job.set("mapreduce.job.cache.local.files", StringUtils.arrayToString(localFiles.toArray(new String[localFiles.size()])));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLocalJobFile(Path jobFile, JobConf conf) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal(conf);
        localFs.delete(jobFile);
        FSDataOutputStream out = null;
        try {
            out = FileSystem.create(localFs, jobFile, urw_gr);
            conf.writeXml(out);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(LOG, out);
            throw throwable;
        }
        IOUtils.cleanup(LOG, out);
    }
}

