/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.jobhistory;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.jobhistory.FileNameIndexUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobIndexInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobHistoryUtils {
    public static final FsPermission HISTORY_STAGING_DIR_PERMISSIONS = FsPermission.createImmutable((short)448);
    public static final FsPermission HISTORY_STAGING_USER_DIR_PERMISSIONS = FsPermission.createImmutable((short)448);
    public static final FsPermission HISTORY_DONE_DIR_PERMISSION = FsPermission.createImmutable((short)504);
    public static final FsPermission HISTORY_DONE_FILE_PERMISSION = FsPermission.createImmutable((short)504);
    public static final FsPermission HISTORY_DONE_DIR_UMASK = FsPermission.createImmutable((short)7);
    public static final FsPermission HISTORY_INTERMEDIATE_DONE_DIR_PERMISSIONS = FsPermission.createImmutable((short)1023);
    public static final FsPermission HISTORY_INTERMEDIATE_USER_DIR_PERMISSIONS = FsPermission.createImmutable((short)504);
    public static final FsPermission HISTORY_INTERMEDIATE_FILE_PERMISSIONS = FsPermission.createImmutable((short)504);
    public static final String CONF_FILE_NAME_SUFFIX = "_conf.xml";
    public static final String SUMMARY_FILE_NAME_SUFFIX = ".summary";
    public static final String JOB_HISTORY_FILE_EXTENSION = ".jhist";
    public static final int VERSION = 4;
    public static final int SERIAL_NUMBER_DIRECTORY_DIGITS = 6;
    public static final String TIMESTAMP_DIR_REGEX = "\\d{4}\\/\\d{2}\\/\\d{2}";
    public static final Pattern TIMESTAMP_DIR_PATTERN = Pattern.compile("\\d{4}\\/\\d{2}\\/\\d{2}");
    private static final String TIMESTAMP_DIR_FORMAT = "%04d" + File.separator + "%02d" + File.separator + "%02d";
    private static final PathFilter CONF_FILTER = new PathFilter(){

        @Override
        public boolean accept(Path path) {
            return path.getName().endsWith(JobHistoryUtils.CONF_FILE_NAME_SUFFIX);
        }
    };
    private static final PathFilter JOB_HISTORY_FILE_FILTER = new PathFilter(){

        @Override
        public boolean accept(Path path) {
            return path.getName().endsWith(JobHistoryUtils.JOB_HISTORY_FILE_EXTENSION);
        }
    };

    public static boolean isValidJobHistoryFileName(String pathString) {
        return pathString.endsWith(JOB_HISTORY_FILE_EXTENSION);
    }

    public static JobID getJobIDFromHistoryFilePath(String pathString) throws IOException {
        String[] parts = pathString.split("/");
        String fileNamePart = parts[parts.length - 1];
        JobIndexInfo jobIndexInfo = FileNameIndexUtils.getIndexInfo(fileNamePart);
        return TypeConverter.fromYarn(jobIndexInfo.getJobId());
    }

    public static PathFilter getConfFileFilter() {
        return CONF_FILTER;
    }

    public static PathFilter getHistoryFileFilter() {
        return JOB_HISTORY_FILE_FILTER;
    }

    public static String getConfiguredHistoryStagingDirPrefix(Configuration conf, String jobId) throws IOException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path stagingPath = MRApps.getStagingAreaDir(conf, user);
        Path path = new Path(stagingPath, jobId);
        String logDir = path.toString();
        return logDir;
    }

    public static String getConfiguredHistoryIntermediateDoneDirPrefix(Configuration conf) {
        String doneDirPrefix = conf.get("mapreduce.jobhistory.intermediate-done-dir");
        if (doneDirPrefix == null) {
            doneDirPrefix = conf.get("yarn.app.mapreduce.am.staging-dir", "/tmp/hadoop-yarn/staging") + "/history/done_intermediate";
        }
        return doneDirPrefix;
    }

    public static String getConfiguredHistoryServerDoneDirPrefix(Configuration conf) {
        String doneDirPrefix = conf.get("mapreduce.jobhistory.done-dir");
        if (doneDirPrefix == null) {
            doneDirPrefix = conf.get("yarn.app.mapreduce.am.staging-dir", "/tmp/hadoop-yarn/staging") + "/history/done";
        }
        return doneDirPrefix;
    }

    public static String getHistoryIntermediateDoneDirForUser(Configuration conf) throws IOException {
        return JobHistoryUtils.getConfiguredHistoryIntermediateDoneDirPrefix(conf) + File.separator + UserGroupInformation.getCurrentUser().getShortUserName();
    }

    public static boolean shouldCreateNonUserDirectory(Configuration conf) {
        return conf.getBoolean("yarn.app.mapreduce.am.create-intermediate-jh-base-dir", true);
    }

    public static Path getStagingJobHistoryFile(Path dir, JobId jobId, int attempt) {
        return JobHistoryUtils.getStagingJobHistoryFile(dir, TypeConverter.fromYarn(jobId).toString(), attempt);
    }

    public static Path getStagingJobHistoryFile(Path dir, String jobId, int attempt) {
        return new Path(dir, jobId + "_" + attempt + JOB_HISTORY_FILE_EXTENSION);
    }

    public static String getIntermediateConfFileName(JobId jobId) {
        return TypeConverter.fromYarn(jobId).toString() + CONF_FILE_NAME_SUFFIX;
    }

    public static String getIntermediateSummaryFileName(JobId jobId) {
        return TypeConverter.fromYarn(jobId).toString() + SUMMARY_FILE_NAME_SUFFIX;
    }

    public static Path getStagingConfFile(Path logDir, JobId jobId, int attempt) {
        Path jobFilePath = null;
        if (logDir != null) {
            jobFilePath = new Path(logDir, TypeConverter.fromYarn(jobId).toString() + "_" + attempt + CONF_FILE_NAME_SUFFIX);
        }
        return jobFilePath;
    }

    public static String serialNumberDirectoryComponent(JobId id, String serialNumberFormat) {
        return String.format(serialNumberFormat, JobHistoryUtils.jobSerialNumber(id)).substring(0, 6);
    }

    public static String getTimestampPartFromPath(String path) {
        Matcher matcher = TIMESTAMP_DIR_PATTERN.matcher(path);
        if (matcher.find()) {
            String matched = matcher.group();
            String ret = matched.intern();
            return ret;
        }
        return null;
    }

    public static String historyLogSubdirectory(JobId id, String timestampComponent, String serialNumberFormat) {
        String result = "";
        String serialNumberDirectory = JobHistoryUtils.serialNumberDirectoryComponent(id, serialNumberFormat);
        result = result + timestampComponent + File.separator + serialNumberDirectory + File.separator;
        return result;
    }

    public static String timestampDirectoryComponent(long millisecondTime) {
        Calendar timestamp = Calendar.getInstance();
        timestamp.setTimeInMillis(millisecondTime);
        String dateString = null;
        dateString = String.format(TIMESTAMP_DIR_FORMAT, timestamp.get(1), timestamp.get(2) + 1, timestamp.get(5));
        dateString = dateString.intern();
        return dateString;
    }

    public static String doneSubdirsBeforeSerialTail() {
        String result = "/*/*/*";
        return result;
    }

    public static int jobSerialNumber(JobId id) {
        return id.getId();
    }

    public static List<FileStatus> localGlobber(FileContext fc, Path root, String tail) throws IOException {
        return JobHistoryUtils.localGlobber(fc, root, tail, null);
    }

    public static List<FileStatus> localGlobber(FileContext fc, Path root, String tail, PathFilter filter) throws IOException {
        return JobHistoryUtils.localGlobber(fc, root, tail, filter, null);
    }

    public static List<FileStatus> localGlobber(FileContext fc, Path root, String tail, PathFilter filter, AtomicBoolean hasFlatFiles) throws IOException {
        if (tail.equals("")) {
            return JobHistoryUtils.listFilteredStatus(fc, root, filter);
        }
        if (tail.startsWith("/*")) {
            Path[] subdirs = JobHistoryUtils.filteredStat2Paths(JobHistoryUtils.remoteIterToList(fc.listStatus(root)), true, hasFlatFiles);
            LinkedList<List<FileStatus>> subsubdirs = new LinkedList<List<FileStatus>>();
            int subsubdirCount = 0;
            if (subdirs.length == 0) {
                return new LinkedList<FileStatus>();
            }
            String newTail = tail.substring(2);
            for (int i = 0; i < subdirs.length; ++i) {
                subsubdirs.add(JobHistoryUtils.localGlobber(fc, subdirs[i], newTail, filter, null));
                subsubdirCount += ((List)subsubdirs.get(i)).size();
            }
            LinkedList<FileStatus> result = new LinkedList<FileStatus>();
            for (int i = 0; i < subsubdirs.size(); ++i) {
                result.addAll((Collection)subsubdirs.get(i));
            }
            return result;
        }
        if (tail.startsWith("/")) {
            int split = tail.indexOf(47, 1);
            if (split < 0) {
                return JobHistoryUtils.listFilteredStatus(fc, new Path(root, tail.substring(1)), filter);
            }
            String thisSegment = tail.substring(1, split);
            String newTail = tail.substring(split);
            return JobHistoryUtils.localGlobber(fc, new Path(root, thisSegment), newTail, filter, hasFlatFiles);
        }
        IOException e = new IOException("localGlobber: bad tail");
        throw e;
    }

    private static List<FileStatus> listFilteredStatus(FileContext fc, Path root, PathFilter filter) throws IOException {
        List<FileStatus> fsList = JobHistoryUtils.remoteIterToList(fc.listStatus(root));
        if (filter == null) {
            return fsList;
        }
        LinkedList<FileStatus> filteredList = new LinkedList<FileStatus>();
        for (FileStatus fs : fsList) {
            if (!filter.accept(fs.getPath())) continue;
            filteredList.add(fs);
        }
        return filteredList;
    }

    private static List<FileStatus> remoteIterToList(RemoteIterator<FileStatus> rIter) throws IOException {
        LinkedList<FileStatus> fsList = new LinkedList<FileStatus>();
        if (rIter == null) {
            return fsList;
        }
        while (rIter.hasNext()) {
            fsList.add(rIter.next());
        }
        return fsList;
    }

    private static Path[] filteredStat2Paths(List<FileStatus> stats, boolean dirs, AtomicBoolean hasMismatches) {
        int resultCount = 0;
        if (hasMismatches == null) {
            hasMismatches = new AtomicBoolean(false);
        }
        for (int i = 0; i < stats.size(); ++i) {
            if (stats.get(i).isDirectory() == dirs) {
                stats.set(resultCount++, stats.get(i));
                continue;
            }
            hasMismatches.set(true);
        }
        Path[] result = new Path[resultCount];
        for (int i = 0; i < resultCount; ++i) {
            result[i] = stats.get(i).getPath();
        }
        return result;
    }

    public static Path getPreviousJobHistoryPath(Configuration conf, ApplicationAttemptId applicationAttemptId) throws IOException {
        String jobId = TypeConverter.fromYarn(applicationAttemptId.getApplicationId()).toString();
        String jobhistoryDir = JobHistoryUtils.getConfiguredHistoryStagingDirPrefix(conf, jobId);
        Path histDirPath = FileContext.getFileContext(conf).makeQualified(new Path(jobhistoryDir));
        FileContext fc = FileContext.getFileContext(histDirPath.toUri(), conf);
        return fc.makeQualified(JobHistoryUtils.getStagingJobHistoryFile(histDirPath, jobId, applicationAttemptId.getAttemptId() - 1));
    }
}

