/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.InvalidContainerRequestException;
import org.apache.hadoop.yarn.client.api.NMTokenCache;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.RackResolver;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AMRMClientImpl<T extends AMRMClient.ContainerRequest>
extends AMRMClient<T> {
    private static final Log LOG = LogFactory.getLog(AMRMClientImpl.class);
    private static final List<String> ANY_LIST = Collections.singletonList("*");
    private int lastResponseId = 0;
    protected ApplicationMasterProtocol rmClient;
    protected Resource clusterAvailableResources;
    protected int clusterNodeCount;
    protected final Set<String> blacklistAdditions = new HashSet<String>();
    protected final Set<String> blacklistRemovals = new HashSet<String>();
    protected final Map<Priority, Map<String, TreeMap<Resource, ResourceRequestInfo>>> remoteRequestsTable = new TreeMap<Priority, Map<String, TreeMap<Resource, ResourceRequestInfo>>>();
    protected final Set<ResourceRequest> ask = new TreeSet<ResourceRequest>(new ResourceRequest.ResourceRequestComparator());
    protected final Set<ContainerId> release = new TreeSet<ContainerId>();

    static boolean canFit(Resource arg0, Resource arg1) {
        int mem0 = arg0.getMemory();
        int mem1 = arg1.getMemory();
        int cpu0 = arg0.getVirtualCores();
        int cpu1 = arg1.getVirtualCores();
        return mem0 <= mem1 && cpu0 <= cpu1;
    }

    public AMRMClientImpl() {
        super(AMRMClientImpl.class.getName());
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        RackResolver.init(conf);
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        YarnConfiguration conf = new YarnConfiguration(this.getConfig());
        try {
            this.rmClient = ClientRMProxy.createRMProxy(conf, ApplicationMasterProtocol.class);
        }
        catch (IOException e) {
            throw new YarnRuntimeException(e);
        }
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.rmClient != null) {
            RPC.stopProxy(this.rmClient);
        }
        super.serviceStop();
    }

    @Override
    public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl) throws YarnException, IOException {
        Preconditions.checkArgument((appHostName != null ? 1 : 0) != 0, (Object)"The host name should not be null");
        Preconditions.checkArgument((appHostPort >= -1 ? 1 : 0) != 0, (Object)"Port number of the host should be any integers larger than or equal to -1");
        RegisterApplicationMasterRequest request = RegisterApplicationMasterRequest.newInstance(appHostName, appHostPort, appTrackingUrl);
        RegisterApplicationMasterResponse response = this.rmClient.registerApplicationMaster(request);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocateResponse allocate(float progressIndicator) throws YarnException, IOException {
        AllocateResponse allocateResponse;
        block19: {
            AMRMClientImpl aMRMClientImpl;
            Preconditions.checkArgument((progressIndicator >= 0.0f ? 1 : 0) != 0, (Object)"Progress indicator should not be negative");
            allocateResponse = null;
            ArrayList<ResourceRequest> askList = null;
            ArrayList<ContainerId> releaseList = null;
            AllocateRequest allocateRequest = null;
            ArrayList<String> blacklistToAdd = new ArrayList<String>();
            ArrayList<String> blacklistToRemove = new ArrayList<String>();
            try {
                aMRMClientImpl = this;
                synchronized (aMRMClientImpl) {
                    askList = new ArrayList<ResourceRequest>(this.ask.size());
                    for (ResourceRequest r : this.ask) {
                        askList.add(ResourceRequest.newInstance(r.getPriority(), r.getResourceName(), r.getCapability(), r.getNumContainers(), r.getRelaxLocality()));
                    }
                    releaseList = new ArrayList<ContainerId>(this.release);
                    this.ask.clear();
                    this.release.clear();
                    blacklistToAdd.addAll(this.blacklistAdditions);
                    blacklistToRemove.addAll(this.blacklistRemovals);
                    ResourceBlacklistRequest blacklistRequest = blacklistToAdd != null || blacklistToRemove != null ? ResourceBlacklistRequest.newInstance(blacklistToAdd, blacklistToRemove) : null;
                    allocateRequest = AllocateRequest.newInstance(this.lastResponseId, progressIndicator, askList, releaseList, blacklistRequest);
                    this.blacklistAdditions.clear();
                    this.blacklistRemovals.clear();
                }
                allocateResponse = this.rmClient.allocate(allocateRequest);
                aMRMClientImpl = this;
                synchronized (aMRMClientImpl) {
                    this.clusterNodeCount = allocateResponse.getNumClusterNodes();
                    this.lastResponseId = allocateResponse.getResponseId();
                    this.clusterAvailableResources = allocateResponse.getAvailableResources();
                    if (!allocateResponse.getNMTokens().isEmpty()) {
                        this.populateNMTokens(allocateResponse);
                    }
                }
                if (allocateResponse != null) break block19;
                aMRMClientImpl = this;
            }
            catch (Throwable throwable) {
                if (allocateResponse == null) {
                    AMRMClientImpl aMRMClientImpl2 = this;
                    synchronized (aMRMClientImpl2) {
                        this.release.addAll(releaseList);
                        for (ResourceRequest oldAsk : askList) {
                            if (this.ask.contains(oldAsk)) continue;
                            this.ask.add(oldAsk);
                        }
                        this.blacklistAdditions.addAll(blacklistToAdd);
                        this.blacklistRemovals.addAll(blacklistToRemove);
                    }
                }
                throw throwable;
            }
            synchronized (aMRMClientImpl) {
                this.release.addAll(releaseList);
                for (ResourceRequest oldAsk : askList) {
                    if (this.ask.contains(oldAsk)) continue;
                    this.ask.add(oldAsk);
                }
                this.blacklistAdditions.addAll(blacklistToAdd);
                this.blacklistRemovals.addAll(blacklistToRemove);
            }
        }
        return allocateResponse;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void populateNMTokens(AllocateResponse allocateResponse) {
        for (NMToken token : allocateResponse.getNMTokens()) {
            String nodeId = token.getNodeId().toString();
            if (NMTokenCache.containsNMToken(nodeId)) {
                LOG.debug((Object)("Replacing token for : " + nodeId));
            } else {
                LOG.debug((Object)("Received new token for : " + nodeId));
            }
            NMTokenCache.setNMToken(nodeId, token.getToken());
        }
    }

    @Override
    public void unregisterApplicationMaster(FinalApplicationStatus appStatus, String appMessage, String appTrackingUrl) throws YarnException, IOException {
        Preconditions.checkArgument((appStatus != null ? 1 : 0) != 0, (Object)"AppStatus should not be null.");
        FinishApplicationMasterRequest request = FinishApplicationMasterRequest.newInstance(appStatus, appMessage, appTrackingUrl);
        try {
            FinishApplicationMasterResponse response;
            while (!(response = this.rmClient.finishApplicationMaster(request)).getIsUnregistered()) {
                LOG.info((Object)"Waiting for application to be successfully unregistered.");
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Interrupted while waiting for application to be removed from RMStateStore");
        }
    }

    @Override
    public synchronized void addContainerRequest(T req) {
        Preconditions.checkArgument((req != null ? 1 : 0) != 0, (Object)"Resource request can not be null.");
        HashSet<String> dedupedRacks = new HashSet<String>();
        if (((AMRMClient.ContainerRequest)req).getRacks() != null) {
            dedupedRacks.addAll(((AMRMClient.ContainerRequest)req).getRacks());
            if (((AMRMClient.ContainerRequest)req).getRacks().size() != dedupedRacks.size()) {
                Joiner joiner = Joiner.on((char)',');
                LOG.warn((Object)("ContainerRequest has duplicate racks: " + joiner.join(((AMRMClient.ContainerRequest)req).getRacks())));
            }
        }
        Set<String> inferredRacks = this.resolveRacks(((AMRMClient.ContainerRequest)req).getNodes());
        inferredRacks.removeAll(dedupedRacks);
        this.checkLocalityRelaxationConflict(((AMRMClient.ContainerRequest)req).getPriority(), ANY_LIST, ((AMRMClient.ContainerRequest)req).getRelaxLocality());
        this.checkLocalityRelaxationConflict(((AMRMClient.ContainerRequest)req).getPriority(), dedupedRacks, true);
        this.checkLocalityRelaxationConflict(((AMRMClient.ContainerRequest)req).getPriority(), inferredRacks, ((AMRMClient.ContainerRequest)req).getRelaxLocality());
        if (((AMRMClient.ContainerRequest)req).getNodes() != null) {
            HashSet<String> dedupedNodes = new HashSet<String>(((AMRMClient.ContainerRequest)req).getNodes());
            if (dedupedNodes.size() != ((AMRMClient.ContainerRequest)req).getNodes().size()) {
                Joiner joiner = Joiner.on((char)',');
                LOG.warn((Object)("ContainerRequest has duplicate nodes: " + joiner.join(((AMRMClient.ContainerRequest)req).getNodes())));
            }
            for (String node : dedupedNodes) {
                this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), node, ((AMRMClient.ContainerRequest)req).getCapability(), req, true);
            }
        }
        for (String rack : dedupedRacks) {
            this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), rack, ((AMRMClient.ContainerRequest)req).getCapability(), req, true);
        }
        for (String rack : inferredRacks) {
            this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), rack, ((AMRMClient.ContainerRequest)req).getCapability(), req, ((AMRMClient.ContainerRequest)req).getRelaxLocality());
        }
        this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), "*", ((AMRMClient.ContainerRequest)req).getCapability(), req, ((AMRMClient.ContainerRequest)req).getRelaxLocality());
    }

    @Override
    public synchronized void removeContainerRequest(T req) {
        Preconditions.checkArgument((req != null ? 1 : 0) != 0, (Object)"Resource request can not be null.");
        HashSet<String> allRacks = new HashSet<String>();
        if (((AMRMClient.ContainerRequest)req).getRacks() != null) {
            allRacks.addAll(((AMRMClient.ContainerRequest)req).getRacks());
        }
        allRacks.addAll(this.resolveRacks(((AMRMClient.ContainerRequest)req).getNodes()));
        if (((AMRMClient.ContainerRequest)req).getNodes() != null) {
            for (String node : new HashSet<String>(((AMRMClient.ContainerRequest)req).getNodes())) {
                this.decResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), node, ((AMRMClient.ContainerRequest)req).getCapability(), req);
            }
        }
        for (String rack : allRacks) {
            this.decResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), rack, ((AMRMClient.ContainerRequest)req).getCapability(), req);
        }
        this.decResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), "*", ((AMRMClient.ContainerRequest)req).getCapability(), req);
    }

    @Override
    public synchronized void releaseAssignedContainer(ContainerId containerId) {
        Preconditions.checkArgument((containerId != null ? 1 : 0) != 0, (Object)"ContainerId can not be null.");
        this.release.add(containerId);
    }

    @Override
    public synchronized Resource getAvailableResources() {
        return this.clusterAvailableResources;
    }

    @Override
    public synchronized int getClusterNodeCount() {
        return this.clusterNodeCount;
    }

    @Override
    public synchronized List<? extends Collection<T>> getMatchingRequests(Priority priority, String resourceName, Resource capability) {
        Preconditions.checkArgument((capability != null ? 1 : 0) != 0, (Object)"The Resource to be requested should not be null ");
        Preconditions.checkArgument((priority != null ? 1 : 0) != 0, (Object)"The priority at which to request containers should not be null ");
        LinkedList list = new LinkedList();
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            return list;
        }
        TreeMap<Resource, ResourceRequestInfo> reqMap = remoteRequests.get(resourceName);
        if (reqMap == null) {
            return list;
        }
        ResourceRequestInfo resourceRequestInfo = reqMap.get(capability);
        if (resourceRequestInfo != null && !resourceRequestInfo.containerRequests.isEmpty()) {
            list.add(resourceRequestInfo.containerRequests);
            return list;
        }
        SortedMap<Resource, ResourceRequestInfo> tailMap = reqMap.tailMap(capability);
        for (Map.Entry<Resource, ResourceRequestInfo> entry : tailMap.entrySet()) {
            if (!AMRMClientImpl.canFit(entry.getKey(), capability) || entry.getValue().containerRequests.isEmpty()) continue;
            list.add(entry.getValue().containerRequests);
        }
        return list;
    }

    private Set<String> resolveRacks(List<String> nodes) {
        HashSet<String> racks = new HashSet<String>();
        if (nodes != null) {
            for (String node : nodes) {
                String rack = RackResolver.resolve(node).getNetworkLocation();
                if (rack == null) {
                    LOG.warn((Object)("Failed to resolve rack for node " + node + "."));
                    continue;
                }
                racks.add(rack);
            }
        }
        return racks;
    }

    private void checkLocalityRelaxationConflict(Priority priority, Collection<String> locations, boolean relaxLocality) {
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            return;
        }
        for (String location : locations) {
            TreeMap<Resource, ResourceRequestInfo> reqs = remoteRequests.get(location);
            if (reqs == null || reqs.isEmpty() || reqs.values().iterator().next().remoteRequest.getRelaxLocality() == relaxLocality) continue;
            throw new InvalidContainerRequestException("Cannot submit a ContainerRequest asking for location " + location + " with locality relaxation " + relaxLocality + " when it has " + "already been requested with locality relaxation " + relaxLocality);
        }
    }

    private void addResourceRequestToAsk(ResourceRequest remoteRequest) {
        if (this.ask.contains(remoteRequest)) {
            this.ask.remove(remoteRequest);
        }
        this.ask.add(remoteRequest);
    }

    private void addResourceRequest(Priority priority, String resourceName, Resource capability, T req, boolean relaxLocality) {
        ResourceRequestInfo resourceRequestInfo;
        TreeMap<Resource, ResourceRequestInfo> reqMap;
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            remoteRequests = new HashMap<String, TreeMap<Resource, ResourceRequestInfo>>();
            this.remoteRequestsTable.put(priority, remoteRequests);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Added priority=" + priority));
            }
        }
        if ((reqMap = remoteRequests.get(resourceName)) == null) {
            reqMap = new TreeMap(new ResourceReverseMemoryThenCpuComparator());
            remoteRequests.put(resourceName, reqMap);
        }
        if ((resourceRequestInfo = reqMap.get(capability)) == null) {
            resourceRequestInfo = new ResourceRequestInfo(priority, resourceName, capability, relaxLocality);
            reqMap.put(capability, resourceRequestInfo);
        }
        resourceRequestInfo.remoteRequest.setNumContainers(resourceRequestInfo.remoteRequest.getNumContainers() + 1);
        if (relaxLocality) {
            resourceRequestInfo.containerRequests.add(req);
        }
        this.addResourceRequestToAsk(resourceRequestInfo.remoteRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addResourceRequest: applicationId= priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }

    private void decResourceRequest(Priority priority, String resourceName, Resource capability, T req) {
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not decrementing resource as priority " + priority + " is not present in request table"));
            }
            return;
        }
        Map reqMap = remoteRequests.get(resourceName);
        if (reqMap == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not decrementing resource as " + resourceName + " is not present in request table"));
            }
            return;
        }
        ResourceRequestInfo resourceRequestInfo = (ResourceRequestInfo)reqMap.get(capability);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEFORE decResourceRequest: applicationId= priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
        resourceRequestInfo.remoteRequest.setNumContainers(resourceRequestInfo.remoteRequest.getNumContainers() - 1);
        resourceRequestInfo.containerRequests.remove(req);
        if (resourceRequestInfo.remoteRequest.getNumContainers() < 0) {
            resourceRequestInfo.remoteRequest.setNumContainers(0);
        }
        this.addResourceRequestToAsk(resourceRequestInfo.remoteRequest);
        if (resourceRequestInfo.remoteRequest.getNumContainers() == 0) {
            reqMap.remove(capability);
            if (reqMap.size() == 0) {
                remoteRequests.remove(resourceName);
            }
            if (remoteRequests.size() == 0) {
                this.remoteRequestsTable.remove(priority);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("AFTER decResourceRequest: applicationId= priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }

    @Override
    public synchronized void updateBlacklist(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        if (blacklistAdditions != null) {
            this.blacklistAdditions.addAll(blacklistAdditions);
            this.blacklistRemovals.removeAll(blacklistAdditions);
        }
        if (blacklistRemovals != null) {
            this.blacklistRemovals.addAll(blacklistRemovals);
            this.blacklistAdditions.removeAll(blacklistRemovals);
        }
        if (blacklistAdditions != null && blacklistRemovals != null && blacklistAdditions.removeAll(blacklistRemovals)) {
            LOG.warn((Object)"The same resources appear in both blacklistAdditions and blacklistRemovals in updateBlacklist.");
        }
    }

    class ResourceReverseMemoryThenCpuComparator
    implements Comparator<Resource> {
        ResourceReverseMemoryThenCpuComparator() {
        }

        @Override
        public int compare(Resource arg0, Resource arg1) {
            int mem0 = arg0.getMemory();
            int mem1 = arg1.getMemory();
            int cpu0 = arg0.getVirtualCores();
            int cpu1 = arg1.getVirtualCores();
            if (mem0 == mem1) {
                if (cpu0 == cpu1) {
                    return 0;
                }
                if (cpu0 < cpu1) {
                    return 1;
                }
                return -1;
            }
            if (mem0 < mem1) {
                return 1;
            }
            return -1;
        }
    }

    class ResourceRequestInfo {
        ResourceRequest remoteRequest;
        LinkedHashSet<T> containerRequests;

        ResourceRequestInfo(Priority priority, String resourceName, Resource capability, boolean relaxLocality) {
            this.remoteRequest = ResourceRequest.newInstance(priority, resourceName, capability, 0);
            this.remoteRequest.setRelaxLocality(relaxLocality);
            this.containerRequests = new LinkedHashSet();
        }
    }
}

