/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.security;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.security.BaseContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.security.MasterKeyData;

public class NMContainerTokenSecretManager
extends BaseContainerTokenSecretManager {
    private static final Log LOG = LogFactory.getLog(NMContainerTokenSecretManager.class);
    private MasterKeyData previousMasterKey;
    private final TreeMap<Long, List<ContainerId>> recentlyStartedContainerTracker = new TreeMap();
    private String nodeHostAddr;

    public NMContainerTokenSecretManager(Configuration conf) {
        super(conf);
    }

    @InterfaceAudience.Private
    public synchronized void setMasterKey(MasterKey masterKeyRecord) {
        LOG.info((Object)("Rolling master-key for container-tokens, got key with id " + masterKeyRecord.getKeyId()));
        if (this.currentMasterKey == null) {
            this.currentMasterKey = new MasterKeyData(masterKeyRecord, NMContainerTokenSecretManager.createSecretKey(masterKeyRecord.getBytes().array()));
        } else if (this.currentMasterKey.getMasterKey().getKeyId() != masterKeyRecord.getKeyId()) {
            this.previousMasterKey = this.currentMasterKey;
            this.currentMasterKey = new MasterKeyData(masterKeyRecord, NMContainerTokenSecretManager.createSecretKey(masterKeyRecord.getBytes().array()));
        }
    }

    @Override
    public synchronized byte[] retrievePassword(ContainerTokenIdentifier identifier) throws SecretManager.InvalidToken {
        int keyId = identifier.getMasterKeyId();
        MasterKeyData masterKeyToUse = null;
        if (this.previousMasterKey != null && keyId == this.previousMasterKey.getMasterKey().getKeyId()) {
            masterKeyToUse = this.previousMasterKey;
        } else if (keyId == this.currentMasterKey.getMasterKey().getKeyId()) {
            masterKeyToUse = this.currentMasterKey;
        }
        if (this.nodeHostAddr != null && !identifier.getNmHostAddress().equals(this.nodeHostAddr)) {
            throw new SecretManager.InvalidToken("Given Container " + identifier.getContainerID().toString() + " identifier is not valid for current Node manager. Expected : " + this.nodeHostAddr + " Found : " + identifier.getNmHostAddress());
        }
        if (masterKeyToUse != null) {
            return this.retrievePasswordInternal(identifier, masterKeyToUse);
        }
        throw new SecretManager.InvalidToken("Given Container " + identifier.getContainerID().toString() + " seems to have an illegally generated token.");
    }

    public synchronized void startContainerSuccessful(ContainerTokenIdentifier tokenId) {
        this.removeAnyContainerTokenIfExpired();
        Long expTime = tokenId.getExpiryTimeStamp();
        if (!this.recentlyStartedContainerTracker.containsKey(expTime)) {
            this.recentlyStartedContainerTracker.put(expTime, new ArrayList());
        }
        this.recentlyStartedContainerTracker.get(expTime).add(tokenId.getContainerID());
    }

    protected synchronized void removeAnyContainerTokenIfExpired() {
        Map.Entry<Long, List<ContainerId>> containerEntry;
        Iterator<Map.Entry<Long, List<ContainerId>>> containersI = this.recentlyStartedContainerTracker.entrySet().iterator();
        Long currTime = System.currentTimeMillis();
        while (containersI.hasNext() && (containerEntry = containersI.next()).getKey() < currTime) {
            containersI.remove();
        }
    }

    public synchronized boolean isValidStartContainerRequest(ContainerTokenIdentifier containerTokenIdentifier) {
        this.removeAnyContainerTokenIfExpired();
        Long expTime = containerTokenIdentifier.getExpiryTimeStamp();
        List<ContainerId> containers = this.recentlyStartedContainerTracker.get(expTime);
        return containers == null || !containers.contains(containerTokenIdentifier.getContainerID());
    }

    public synchronized void setNodeId(NodeId nodeId) {
        this.nodeHostAddr = nodeId.toString();
        LOG.info((Object)("Updating node address : " + this.nodeHostAddr));
    }
}

