/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.security;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.security.BaseNMTokenSecretManager;
import org.apache.hadoop.yarn.server.security.MasterKeyData;

public class NMTokenSecretManagerInNM
extends BaseNMTokenSecretManager {
    private static final Log LOG = LogFactory.getLog(NMTokenSecretManagerInNM.class);
    private MasterKeyData previousMasterKey;
    private final Map<ApplicationAttemptId, MasterKeyData> oldMasterKeys = new HashMap<ApplicationAttemptId, MasterKeyData>();
    private final Map<ApplicationId, List<ApplicationAttemptId>> appToAppAttemptMap = new HashMap<ApplicationId, List<ApplicationAttemptId>>();
    private NodeId nodeId;

    @InterfaceAudience.Private
    public synchronized void setMasterKey(MasterKey masterKey) {
        LOG.info((Object)("Rolling master-key for nm-tokens, got key with id :" + masterKey.getKeyId()));
        if (this.currentMasterKey == null) {
            this.currentMasterKey = new MasterKeyData(masterKey, NMTokenSecretManagerInNM.createSecretKey(masterKey.getBytes().array()));
        } else if (this.currentMasterKey.getMasterKey().getKeyId() != masterKey.getKeyId()) {
            this.previousMasterKey = this.currentMasterKey;
            this.currentMasterKey = new MasterKeyData(masterKey, NMTokenSecretManagerInNM.createSecretKey(masterKey.getBytes().array()));
        }
    }

    @Override
    public synchronized byte[] retrievePassword(NMTokenIdentifier identifier) throws SecretManager.InvalidToken {
        MasterKeyData oldMasterKey;
        int keyId = identifier.getKeyId();
        ApplicationAttemptId appAttemptId = identifier.getApplicationAttemptId();
        MasterKeyData masterKeyToUse = oldMasterKey = this.oldMasterKeys.get(appAttemptId);
        if (this.previousMasterKey != null && keyId == this.previousMasterKey.getMasterKey().getKeyId()) {
            masterKeyToUse = this.previousMasterKey;
        } else if (keyId == this.currentMasterKey.getMasterKey().getKeyId()) {
            masterKeyToUse = this.currentMasterKey;
        }
        if (this.nodeId != null && !identifier.getNodeId().equals(this.nodeId)) {
            throw new SecretManager.InvalidToken("Given NMToken for application : " + appAttemptId.toString() + " is not valid for current node manager." + "expected : " + this.nodeId.toString() + " found : " + identifier.getNodeId().toString());
        }
        if (masterKeyToUse != null) {
            byte[] password = this.retrivePasswordInternal(identifier, masterKeyToUse);
            LOG.debug((Object)"NMToken password retrieved successfully!!");
            return password;
        }
        throw new SecretManager.InvalidToken("Given NMToken for application : " + appAttemptId.toString() + " seems to have been generated illegally.");
    }

    public synchronized void appFinished(ApplicationId appId) {
        List<ApplicationAttemptId> appAttemptList = this.appToAppAttemptMap.get(appId);
        if (appAttemptList != null) {
            LOG.debug((Object)("Removing application attempts NMToken keys for application " + appId));
            for (ApplicationAttemptId appAttemptId : appAttemptList) {
                this.oldMasterKeys.remove(appAttemptId);
            }
            this.appToAppAttemptMap.remove(appId);
        } else {
            LOG.error((Object)("No application Attempt for application : " + appId + " started on this NM."));
        }
    }

    public synchronized void appAttemptStartContainer(NMTokenIdentifier identifier) throws SecretManager.InvalidToken {
        MasterKeyData oldKey;
        ApplicationAttemptId appAttemptId = identifier.getApplicationAttemptId();
        if (!this.appToAppAttemptMap.containsKey(appAttemptId.getApplicationId())) {
            this.appToAppAttemptMap.put(appAttemptId.getApplicationId(), new ArrayList());
        }
        if ((oldKey = this.oldMasterKeys.get(appAttemptId)) == null) {
            this.appToAppAttemptMap.get(appAttemptId.getApplicationId()).add(appAttemptId);
        }
        if (oldKey == null || oldKey.getMasterKey().getKeyId() != identifier.getKeyId()) {
            LOG.debug((Object)("NMToken key updated for application attempt : " + identifier.getApplicationAttemptId().toString()));
            if (identifier.getKeyId() == this.currentMasterKey.getMasterKey().getKeyId()) {
                this.oldMasterKeys.put(appAttemptId, this.currentMasterKey);
            } else if (this.previousMasterKey != null && identifier.getKeyId() == this.previousMasterKey.getMasterKey().getKeyId()) {
                this.oldMasterKeys.put(appAttemptId, this.previousMasterKey);
            } else {
                throw new SecretManager.InvalidToken("Older NMToken should not be used while starting the container.");
            }
        }
    }

    public synchronized void setNodeId(NodeId nodeId) {
        LOG.debug((Object)("updating nodeId : " + nodeId));
        this.nodeId = nodeId;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized boolean isAppAttemptNMTokenKeyPresent(ApplicationAttemptId appAttemptId) {
        return this.oldMasterKeys.containsKey(appAttemptId);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized NodeId getNodeId() {
        return this.nodeId;
    }
}

