/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class AllApplicationsPage
extends NMView {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.commonPreHead(html);
        this.setTitle("Applications running on this node");
        this.set("ui.dataTables.id", "applications");
        this.set(JQueryUI.initID("ui.dataTables", "applications"), this.appsTableInit());
        this.setTableStyles(html, "applications", new String[0]);
    }

    private String appsTableInit() {
        return JQueryUI.tableInit().append(", aaSorting: [[0, 'asc']]").append(", aoColumns:[null, null]} ").toString();
    }

    @Override
    protected Class<? extends SubView> content() {
        return AllApplicationsBlock.class;
    }

    public static class AllApplicationsBlock
    extends HtmlBlock
    implements YarnWebParams {
        private final Context nmContext;

        @Inject
        public AllApplicationsBlock(Context nmContext) {
            this.nmContext = nmContext;
        }

        @Override
        protected void render(HtmlBlock.Block html) {
            HamletSpec.TBODY tableBody = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((Hamlet.THEAD)((Hamlet.TABLE)((Hamlet.BODY)html.body()).table("#applications")).thead()).tr()).td())._(new Object[]{"ApplicationId"})))._()).td())._(new Object[]{"ApplicationState"})))._())._())._()).tbody();
            for (Map.Entry entry : this.nmContext.getApplications().entrySet()) {
                AppInfo info = new AppInfo((Application)entry.getValue());
                ((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((Hamlet.TBODY)tableBody).tr()).td()).a(this.url("application", info.getId()), info.getId())))._()).td())._(new Object[]{info.getState()})))._())._();
            }
            ((Hamlet.BODY)((Hamlet.TABLE)((HamletImpl.EImp)((Object)tableBody))._())._())._();
        }
    }
}

