/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMController;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMWebServices;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class WebServer
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(WebServer.class);
    private final Context nmContext;
    private final NMWebApp nmWebApp;
    private WebApp webApp;
    private int port;

    public WebServer(Context nmContext, ResourceView resourceView, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        super(WebServer.class.getName());
        this.nmContext = nmContext;
        this.nmWebApp = new NMWebApp(resourceView, aclsManager, dirsHandler);
    }

    @Override
    protected void serviceStart() throws Exception {
        String bindAddress = WebAppUtils.getNMWebAppURLWithoutScheme(this.getConfig());
        LOG.info((Object)("Instantiating NMWebApp at " + bindAddress));
        try {
            this.webApp = WebApps.$for("node", Context.class, this.nmContext, "ws").at(bindAddress).with(this.getConfig()).withHttpSpnegoPrincipalKey("yarn.nodemanager.webapp.spnego-principal").withHttpSpnegoKeytabKey("yarn.nodemanager.webapp.spnego-keytab-file").start(this.nmWebApp);
            this.port = this.webApp.httpServer().getPort();
        }
        catch (Exception e) {
            String msg = "NMWebapps failed to start.";
            LOG.error((Object)msg, (Throwable)e);
            throw new YarnRuntimeException(msg, e);
        }
        super.serviceStart();
    }

    public int getPort() {
        return this.port;
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            LOG.debug((Object)"Stopping webapp");
            this.webApp.stop();
        }
        super.serviceStop();
    }

    public static class NMWebApp
    extends WebApp
    implements YarnWebParams {
        private final ResourceView resourceView;
        private final ApplicationACLsManager aclsManager;
        private final LocalDirsHandlerService dirsHandler;

        public NMWebApp(ResourceView resourceView, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
            this.resourceView = resourceView;
            this.aclsManager = aclsManager;
            this.dirsHandler = dirsHandler;
        }

        @Override
        public void setup() {
            this.bind(NMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            this.bind(JAXBContextResolver.class);
            this.bind(ResourceView.class).toInstance((Object)this.resourceView);
            this.bind(ApplicationACLsManager.class).toInstance((Object)this.aclsManager);
            this.bind(LocalDirsHandlerService.class).toInstance((Object)this.dirsHandler);
            this.route("/", NMController.class, "info");
            this.route("/node", NMController.class, "node");
            this.route("/allApplications", NMController.class, "allApplications");
            this.route("/allContainers", NMController.class, "allContainers");
            this.route(StringHelper.pajoin("/application", "app.id"), NMController.class, "application");
            this.route(StringHelper.pajoin("/container", "container.id"), NMController.class, "container");
            this.route(StringHelper.pajoin("/containerlogs", "container.id", "app.owner", "log.type"), NMController.class, "logs");
        }
    }
}

